/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.biz.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class UnitFormatUtils {
    private static final UnitFormatService formatService = (val, origLarge, targetLager) -> Optional.ofNullable(val).orElse(BigDecimal.ZERO).multiply(BigDecimal.valueOf(origLarge)).divide(BigDecimal.valueOf(targetLager), 2, RoundingMode.CEILING);

    public static BigDecimal formatVolume(BigDecimal val, String origUnit, String targetUnit) {
        return formatService.format(val, VolumeEnum.forCode(origUnit).getLargeNum(), VolumeEnum.forCode(targetUnit).largeNum);
    }

    @FunctionalInterface
    public static interface UnitFormatService {
        public BigDecimal format(BigDecimal var1, Long var2, Long var3);
    }

    public static enum VolumeEnum {
        CM("\u7acb\u65b9\u5398\u7c73", 1L),
        MM("\u7acb\u65b9\u5206\u7c73", 1000L),
        M("\u7acb\u65b9\u7c73", 1000000L);

        private final String name;
        private final Long largeNum;
        public static final Map<String, VolumeEnum> CODE_LOOKUP;

        private VolumeEnum(String name, Long largeNum) {
            this.name = name;
            this.largeNum = largeNum;
        }

        public String getName() {
            return this.name;
        }

        public Long getLargeNum() {
            return this.largeNum;
        }

        public static VolumeEnum forCode(String code) {
            return CODE_LOOKUP.get(code);
        }

        static {
            CODE_LOOKUP = Arrays.stream(VolumeEnum.values()).collect(Collectors.toMap(VolumeEnum::getName, thisEnum -> thisEnum));
        }
    }
}

