/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.mq.internal.inventory;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.model.AuditFinishedGoodsInventoryOrderParams;
import com.dtyunxi.cis.pms.biz.service.FinishedGoodsInventoryService;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsTransferOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderRespDto;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="PUBLISH_TOPIC", tag="TRANSFER_CREATE")
public class TransferOrderCreateSuccessProcessor
implements IMessageProcessor<MessageVo> {
    private static final Logger log = LoggerFactory.getLogger(TransferOrderCreateSuccessProcessor.class);
    @Autowired
    ICsTransferOrderApi csTransferOrderApi;
    @Autowired
    private FinishedGoodsInventoryService finishedGoodsInventoryService;
    private static final List<String> autoTransferTypeList = Lists.newArrayList((Object[])new String[]{CsPcpBusinessTypeEnum.MAIYOU_BC_ALLOT.getCode(), CsPcpBusinessTypeEnum.CC_ALLOT.getCode(), CsPcpBusinessTypeEnum.MAIYOU_ALLOT_OUT.getCode()});

    public MessageResponse process(MessageVo message) {
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        log.info("\u8c03\u62e8\u5355\u521b\u5efa\u6210\u529f\u63a5\u6536mq\u6d88\u606f={}", message.getData());
        try {
            this.doAutoProcess((String)message.getData());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u8c03\u62e8\u5355\u521b\u5efa\u6210\u529f\u63a5\u6536mq\u6d88\u606f\u5904\u7406\u5931\u8d25:{}", (Object)e.getMessage());
        }
        return MessageResponse.SUCCESS;
    }

    private void doAutoProcess(String message) {
        CsTransferOrderRespDto csTransferOrderRespDto = (CsTransferOrderRespDto)JSON.parseObject((String)message, CsTransferOrderRespDto.class);
        if (StringUtils.isNotEmpty((CharSequence)csTransferOrderRespDto.getSaleOrderNo()) && autoTransferTypeList.contains(csTransferOrderRespDto.getType())) {
            AuditFinishedGoodsInventoryOrderParams csAuditReqDto = new AuditFinishedGoodsInventoryOrderParams();
            csAuditReqDto.setAuditResult(Integer.valueOf(1));
            csAuditReqDto.setBussinessOrderNo(csTransferOrderRespDto.getTransferOrderNo());
            csAuditReqDto.setType(csTransferOrderRespDto.getType());
            csAuditReqDto.setAuditReason("\u81ea\u52a8\u5ba1\u6838\u901a\u8fc7");
            log.info("\u8c03\u62e8\u5355\u81ea\u52a8\u5ba1\u6838\u901a\u8fc7={}", JSON.toJSON((Object)csAuditReqDto));
            RestResponse resultResponse = this.finishedGoodsInventoryService.auditFinishedGoodsInventoryOrder(csAuditReqDto);
            log.info("\u8c03\u62e8\u5355\u81ea\u52a8\u5ba1\u6838\u901a\u8fc7\u5904\u7406\u7ed3\u679c={}", JSON.toJSON((Object)resultResponse));
        }
    }
}

