/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.mq.external.trade;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.service.ExternalService;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.transform.api.IPcpOrderApi;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PcpOrderReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderAddrReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderItemReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderPcpExtendReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderSpExtReqDto;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="OP_EXTERNAL_TOPIC", tag="ORDER_ADD_PROCESS")
public class AddSaleOrderProcessor
implements IMessageProcessor<Map<String, Object>> {
    private static final Logger log = LoggerFactory.getLogger(AddSaleOrderProcessor.class);
    @Autowired
    private ExternalService externalService;
    @Autowired
    private IPcpOrderApi pcpOrderApi;
    @Autowired
    private ILockService lockService;
    @Autowired
    private ICacheService cacheService;

    public boolean isDuplicationMessage(String msgId, Map<String, Object> message) {
        log.info("\u63a5\u6536\u5230\u65b0\u589e\u9500\u552e\u8ba2\u5355msgId:" + msgId);
        return this.cacheService.setIfAbsent(msgId, (Object)1, 60) == false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageResponse process(Map<String, Object> message) {
        block7: {
            MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
            String msgStr = JSON.toJSONString(message);
            log.info("\u63a5\u6536\u5230\u65b0\u589e\u9500\u552e\u8ba2\u5355\uff1a{}", (Object)msgStr);
            String resultCode = "0";
            String resultMsg = "success";
            Mutex mutex = null;
            try {
                Object obj = message.get("platformOrderNo");
                String platformOrderNoLock = "_default";
                if (obj != null) {
                    platformOrderNoLock = obj.toString();
                }
                if (null == (mutex = this.lockService.lock("mq_add_pcp_order", platformOrderNoLock, 10, 15, TimeUnit.SECONDS))) {
                    throw new BizException("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25~");
                }
                RestResponse<Long> response = this.addPcpOrderProcess(message, msgStr);
                resultCode = response.getResultCode();
                resultMsg = response.getResultMsg();
                this.lockService.unlock(mutex);
            }
            catch (Exception e) {
                log.error("\u65b0\u589e\u9500\u552e\u8ba2\u5355\u6d88\u8d39\u5931\u8d25", (Throwable)e);
                resultCode = "100000";
                resultMsg = e.getMessage();
                break block7;
            }
            finally {
                this.lockService.unlock(mutex);
                String sendLogId = this.externalService.getSendLogId(message);
                this.externalService.backMsg(sendLogId, resultCode, resultMsg);
            }
            String sendLogId = this.externalService.getSendLogId(message);
            this.externalService.backMsg(sendLogId, resultCode, resultMsg);
        }
        return MessageResponse.SUCCESS;
    }

    private RestResponse<Long> addPcpOrderProcess(Map<String, Object> message, String msgStr) {
        PcpOrderReqDto pcpOrderReqDto = new PcpOrderReqDto();
        BeanUtil.copyProperties(message, (Object)pcpOrderReqDto, (String[])new String[0]);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("subDistributionId", message.get("subDistributionId"));
        map.put("disDelearId", message.get("disDelearId"));
        map.put("thirdOrgID", message.get("thirdOrgID"));
        map.put("thirdPartyId", message.get("thirdPartyId"));
        map.put("maiyouEasNo", message.get("maiyouEasNo"));
        map.put("maiyouCspNo", message.get("maiyouCspNo"));
        map.put("thirdPartyActualId", message.get("thirdPartyActualId"));
        map.put("subdivisionplatform", message.get("subdivisionplatform"));
        map.put("costCenter", message.get("costCenter"));
        map.put("budgetCode", message.get("budgetCode"));
        map.put("billingCustomerName", message.get("billingCustomerName"));
        map.put("billingCustomerCode", message.get("billingCustomerCode"));
        map.put("collectionPurpose", message.get("collectionPurpose"));
        map.put("customerCategory", message.get("customerCategory"));
        map.put("sapPlatformOrderNo", message.get("sapPlatformOrderNo"));
        map.put("distributionChannel", message.get("distributionChannel"));
        map.put("distributor", message.get("distributor"));
        map.put("distributorUcc", message.get("distributorUcc"));
        pcpOrderReqDto.setExtFields(map);
        PlatformOrderPcpExtendReqDto orderExt = new PlatformOrderPcpExtendReqDto();
        BeanUtil.copyProperties(message, (Object)orderExt, (String[])new String[0]);
        orderExt.setCspExtendJson(msgStr);
        PlatformOrderAddrReqDto orderAddrDto = new PlatformOrderAddrReqDto();
        Object addrReqDto = message.get("platformOrderAddrReqDto");
        BeanUtil.copyProperties((Object)addrReqDto, (Object)orderAddrDto, (String[])new String[0]);
        PlatformOrderSpExtReqDto platformOrderSpExtReqDto = new PlatformOrderSpExtReqDto();
        Object spExtReqDto = message.get("spExtReqDto");
        BeanUtil.copyProperties((Object)spExtReqDto, (Object)platformOrderSpExtReqDto, (String[])new String[0]);
        List itemReqDtoList = (List)MapUtil.get(message, (Object)"itemReqDtoList", List.class);
        List itemList = itemReqDtoList.stream().map(items -> {
            PlatformOrderItemReqDto dto = new PlatformOrderItemReqDto();
            BeanUtil.copyProperties((Object)items, (Object)dto, (String[])new String[0]);
            dto.setCspItemExtendJson(JSON.toJSONString((Object)items));
            if (Objects.isNull(dto.getPrice())) {
                dto.setPrice(dto.getSaleUnitPrice());
            }
            BigDecimal taxRate = BigDecimal.ZERO;
            if (Objects.nonNull(items.get("taxRate"))) {
                taxRate = new BigDecimal(items.get("taxRate").toString());
            }
            dto.setTaxRate(taxRate);
            HashMap itemExt = new HashMap();
            if (ObjectUtil.isNotEmpty(items.get("sapLineNo"))) {
                itemExt.put("sourceBillEntryId", items.get("sapLineNo"));
            }
            if (ObjectUtil.isNotEmpty(items.get("cspLineNo"))) {
                itemExt.put("cspLineNo", items.get("cspLineNo"));
            }
            if (ObjectUtil.isNotEmpty(items.get("sapLineNo"))) {
                itemExt.put("sapLineNo", items.get("sapLineNo"));
            }
            if (Objects.nonNull(items.get("orderTotalAmount"))) {
                dto.setEasOrderTotalAmount(new BigDecimal(items.get("orderTotalAmount").toString()));
            }
            if (ObjectUtil.isNotEmpty(itemExt) && !itemExt.isEmpty()) {
                dto.setExtension(JSON.toJSONString(itemExt));
            }
            return dto;
        }).collect(Collectors.toList());
        pcpOrderReqDto.setPlatformOrderPcpExtendReqDto(orderExt);
        pcpOrderReqDto.setPlatformOrderAddrReqDto(orderAddrDto);
        pcpOrderReqDto.setItemReqDtoList(itemList);
        pcpOrderReqDto.setSpExtReqDto(platformOrderSpExtReqDto);
        pcpOrderReqDto.setEasVerifyStatus(Integer.valueOf(1));
        pcpOrderReqDto.setEasVerifyTime(new Date());
        if (ObjectUtil.isNotEmpty((Object)message.get("sapPlatformOrderNo"))) {
            pcpOrderReqDto.setSapPlatformOrderNo(message.get("sapPlatformOrderNo").toString());
        }
        log.info("\u63a5\u6536\u5230\u65b0\u589e\u9500\u552e\u8ba2\u5355addPcpOrderProcess\uff1a{}", (Object)JSON.toJSONString((Object)pcpOrderReqDto));
        RestResponse pcpOrderRest = this.pcpOrderApi.addPcpOrderProcess(pcpOrderReqDto);
        pcpOrderReqDto.setId((Long)pcpOrderRest.getData());
        return pcpOrderRest;
    }
}

