/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.mq.internal.trade;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.service.ExternalPointService;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleRefundReqDto;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="OP_SALE_EXTERNAL_TOPIC", tag="SALE_REFUND_COMPLETE_TAG")
public class SaleOrderRefundCompleteProcessor
implements IMessageProcessor<MessageVo> {
    private static final Logger logger = LoggerFactory.getLogger(SaleOrderRefundCompleteProcessor.class);
    @Resource
    private ExternalPointService externalPointService;
    @Resource
    private ICacheService cacheService;

    public boolean isDuplicationMessage(String msgId, MessageVo message) {
        return this.cacheService.setIfAbsent(msgId, (Object)1, 60) == false;
    }

    public MessageResponse process(MessageVo message) {
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        logger.info("\u9500\u552e\u9000\u5355\u5b8c\u6210\u76d1\u542c\uff1a{}", (Object)JSON.toJSONString((Object)message));
        SaleRefundReqDto saleRefundReqDto = (SaleRefundReqDto)JSON.parseObject((String)message.getData().toString(), SaleRefundReqDto.class);
        try {
            if (ObjectUtil.isNotEmpty((Object)saleRefundReqDto.getPlatformRefundNo())) {
                this.externalPointService.refundOrderToSap(saleRefundReqDto.getId());
            }
        }
        catch (Exception e) {
            logger.error("\u6dfb\u52a0sap\u9000\u8d27\u8ba2\u5355\u5f02\u5e38");
            logger.error(e.getMessage(), (Throwable)e);
        }
        try {
            if (ObjectUtil.isNotEmpty((Object)saleRefundReqDto.getPlatformRefundNo())) {
                this.externalPointService.refundOrderStatusUpdateToCspPoint(saleRefundReqDto);
            }
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0CSP\u9000\u8ba2\u5355\u72b6\u6001\u5f02\u5e38");
            logger.error(e.getMessage(), (Throwable)e);
        }
        return MessageResponse.SUCCESS;
    }
}

