/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.mq.saleorder;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.center.source.api.vo.SourceOrderResultMessageVo;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleOrderOptApi;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SearchSourceReqDto;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class SaleOrderSourceCallbackProcessor
implements IMessageProcessor<MessageVo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaleOrderSourceCallbackProcessor.class);
    @Resource
    private ISaleOrderOptApi saleOrderOptApi;

    public MessageResponse process(MessageVo message) {
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        ServiceContext.getContext().setAttachment("yes.req.requestId", requestId);
        LOGGER.info("\u63a5\u6536\u5bfb\u6e90\u7ed3\u679c\u6d88\u606f\uff1a{}", (Object)JSON.toJSONString((Object)message.getData()));
        Object messageData = message.getData();
        if (messageData instanceof SourceOrderResultMessageVo) {
            SourceOrderResultMessageVo sourceOrderResultRespDto = (SourceOrderResultMessageVo)messageData;
            SearchSourceReqDto searchSourceReqDto = new SearchSourceReqDto();
            searchSourceReqDto.setSgOrderId(sourceOrderResultRespDto.getId());
            searchSourceReqDto.setSgOrderNo(sourceOrderResultRespDto.getSgOrderNo());
            searchSourceReqDto.setSaleOrderNo(sourceOrderResultRespDto.getLinkOrderNo());
            RestResponse restResponse = this.saleOrderOptApi.searchSourceForDeliver(sourceOrderResultRespDto.getId(), searchSourceReqDto);
            RestResponseHelper.checkOrThrow((RestResponse)restResponse);
            return MessageResponse.SUCCESS;
        }
        return MessageResponse.SUCCESS;
    }
}

