/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.mq.saleorder;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.ISaleOrderApportionApi;
import com.dtyunxi.tcbj.api.dto.request.SaleOrderApportionReqDto;
import com.dtyunxi.tcbj.center.openapi.api.dto.response.StringCodeCheckRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsOutNoticeOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsOutResultOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsOtherStorageOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsOtherStorageOrderEditReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.CsOtherStorageOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsOutResultOrderStringValidReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsOutNoticeOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleOrderOptApi;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleTransferTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.CspUpdateEasOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleTransferOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleTransferOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleTransferOrderQueryApi;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="OP_EXTERNAL_TOPIC", tag="string_check_result_tag")
public class SaleOrderStringCodeProcessor
implements IMessageProcessor<String> {
    private static final Logger log = LoggerFactory.getLogger(SaleOrderStringCodeProcessor.class);
    private static final Logger logger = LoggerFactory.getLogger(SaleOrderStringCodeProcessor.class);
    @Resource
    private ISaleOrderOptApi saleOrderOptApi;
    @Resource
    private ICsOutResultOrderApi csOutResultOrderApi;
    @Resource
    private ICsOutNoticeOrderQueryApi csOutNoticeOrderQueryApi;
    @Resource
    private ISaleOrderApportionApi saleOrderApportionApi;
    @Resource
    private ISaleTransferOrderQueryApi saleTransferOrderQueryApi;
    @Resource
    private ICsOtherStorageOrderApi csOtherStorageOrderApi;
    @Resource
    private ICsOtherStorageOrderApi csOtherStorageOrderQueryApi;

    public MessageResponse process(String message) {
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        ServiceContext.getContext().setAttachment("yes.req.requestId", requestId);
        logger.info("\u63a5\u53d7\u5230\u4e32\u7801\u6821\u9a8c\u56de\u4f20\u7ed3\u679c\uff1a{}", (Object)message);
        List list = JSON.parseArray((String)message, StringCodeCheckRespDto.class);
        if (CollectionUtils.isEmpty((Collection)list)) {
            logger.info("\u6570\u636e\u4e3a\u7a7a");
            return MessageResponse.SUCCESS;
        }
        ArrayList<CsOutResultOrderStringValidReqDto> stringValidReqDtoList = new ArrayList<CsOutResultOrderStringValidReqDto>();
        for (StringCodeCheckRespDto stringCodeCheckRespDto : list) {
            String documentNo = stringCodeCheckRespDto.getEasSaleOrderNo();
            boolean checkResult = stringCodeCheckRespDto.isCheckResult();
            try {
                logger.info("\u5904\u7406\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)stringCodeCheckRespDto));
                CspUpdateEasOrderReqDto cspUpdateEasOrderReqDto = new CspUpdateEasOrderReqDto();
                CsOutNoticeOrderRespDto noticeOrder = (CsOutNoticeOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csOutNoticeOrderQueryApi.queryByDocumentNo(stringCodeCheckRespDto.getDocumentNo()));
                if (ObjectUtil.isNotEmpty((Object)noticeOrder) && noticeOrder.getRelevanceTableName().equals(CsRelevanceTableNameEnum.CS_TRANSFER_ORDER.getCode())) {
                    logger.info("\u539f\u5355\u4e3a\u8c03\u62e8\u5355");
                    SaleTransferOrderReqDto reqDto = new SaleTransferOrderReqDto();
                    reqDto.setTransferOrderNo(noticeOrder.getRelevanceNo());
                    reqDto.setTransferType(SaleTransferTypeEnum.SALE.getCode());
                    List saleTransferOrderList = (List)RestResponseHelper.extractData((RestResponse)this.saleTransferOrderQueryApi.queryByParam(reqDto));
                    if (CollectionUtils.isNotEmpty((Collection)saleTransferOrderList)) {
                        cspUpdateEasOrderReqDto.setPlatformOrderNo(((SaleTransferOrderRespDto)saleTransferOrderList.get(0)).getSaleOrderNo());
                        cspUpdateEasOrderReqDto.setCheckResult(checkResult);
                        if (checkResult) {
                            this.refreshFinanceOpenPullDate(null, cspUpdateEasOrderReqDto.getPlatformOrderNo());
                        }
                    }
                } else if (ObjectUtil.isNotEmpty((Object)noticeOrder) && noticeOrder.getRelevanceTableName().equals(CsRelevanceTableNameEnum.CS_OTHER_STORAGE_ORDER.getCode())) {
                    logger.info("\u5176\u4ed6\u51fa\u5e93\u5355");
                    this.otherOutUpdateStringCheck(noticeOrder, checkResult);
                } else {
                    logger.info("\u539f\u5355\u4e3a\u9500\u552e\u5355");
                    cspUpdateEasOrderReqDto.setPlatformOrderNo(documentNo);
                    cspUpdateEasOrderReqDto.setCheckResult(checkResult);
                    if (checkResult) {
                        this.refreshFinanceOpenPullDate(stringCodeCheckRespDto.getDocumentNo(), stringCodeCheckRespDto.getEasSaleOrderNo());
                    }
                }
                RestResponseHelper.extractData((RestResponse)this.saleOrderOptApi.updateSaleOrderStringCodeResult(cspUpdateEasOrderReqDto));
            }
            catch (Exception e) {
                logger.info("\u4fee\u6539\u9500\u552e\u5355\u4e32\u7801\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38:{}", (Object)e.getMessage());
                logger.error("{},{}", (Object)e, (Object)e.getMessage());
            }
            CsOutResultOrderStringValidReqDto outResultOrderStringValidReqDto = new CsOutResultOrderStringValidReqDto();
            outResultOrderStringValidReqDto.setExternalOrderNo(stringCodeCheckRespDto.getEasSaleOrderNo());
            outResultOrderStringValidReqDto.setPreOrderNo(stringCodeCheckRespDto.getDocumentNo());
            outResultOrderStringValidReqDto.setOrderType("out");
            outResultOrderStringValidReqDto.setStringValidResult(checkResult ? "2" : "1");
            stringValidReqDtoList.add(outResultOrderStringValidReqDto);
        }
        this.csOutResultOrderApi.updateStringValidResult(stringValidReqDtoList);
        logger.info("\u51fa\u5165\u5e93\u7ed3\u679c\u5355\u8bfb\u53d6\u4e32\u7801\u5ba1\u6838\u7ed3\u679c");
        return MessageResponse.SUCCESS;
    }

    private void refreshFinanceOpenPullDate(String documentNo, String easSaleOrderNo) {
        try {
            logger.info("\u4e32\u7801\u9a8c\u8bc1\u901a\u8fc7\uff0c\u5237\u65b0\u5141\u8bb8\u8d22\u52a1\u62c9\u5355\u65f6\u95f4\uff1a{}", (Object)documentNo);
            if (StringUtils.isBlank((CharSequence)documentNo)) {
                SaleOrderApportionReqDto reqDto = new SaleOrderApportionReqDto();
                reqDto.setOrderNo(easSaleOrderNo);
                RestResponseHelper.extractData((RestResponse)this.saleOrderApportionApi.refreshOpenPullDate(reqDto));
            } else {
                CsOutNoticeOrderRespDto csOutNoticeOrderRespDto = (CsOutNoticeOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csOutNoticeOrderQueryApi.queryByDocumentNo(documentNo));
                if (ObjectUtil.isEmpty((Object)csOutNoticeOrderRespDto)) {
                    logger.error("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u51fa\u5e93\u901a\u77e5\u5355");
                    return;
                }
                if (csOutNoticeOrderRespDto.getRelevanceTableName().equals(CsRelevanceTableNameEnum.CS_ORDER_SALE.getCode())) {
                    SaleOrderApportionReqDto reqDto = new SaleOrderApportionReqDto();
                    reqDto.setOrderNo(csOutNoticeOrderRespDto.getRelevanceNo());
                    RestResponseHelper.extractData((RestResponse)this.saleOrderApportionApi.refreshOpenPullDate(reqDto));
                }
            }
        }
        catch (Exception e) {
            logger.error("\u5237\u65b0\u5141\u8bb8\u8d22\u52a1\u62c9\u5355\u65f6\u95f4\u5f02\u5e38\uff01");
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void otherOutUpdateStringCheck(CsOutNoticeOrderRespDto noticeOrder, boolean checkResult) {
        CsOtherStorageOrderRespDto otherStorage = (CsOtherStorageOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csOtherStorageOrderQueryApi.queryByOtherStorageNo(noticeOrder.getRelevanceNo()));
        if (ObjectUtil.isEmpty((Object)otherStorage)) {
            logger.error("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5176\u4ed6\u51fa\u5e93\u5355");
            return;
        }
        CsOtherStorageOrderEditReqDto reqDto = new CsOtherStorageOrderEditReqDto();
        reqDto.setId(otherStorage.getId());
        reqDto.setStorageOrderNo(otherStorage.getStorageOrderNo());
        reqDto.setStringCodeResult(Integer.valueOf(checkResult ? 2 : 1));
        reqDto.setStringCodeTime(new Date());
        RestResponseHelper.extractData((RestResponse)this.csOtherStorageOrderApi.editOtherStorageOrder(reqDto));
    }
}

