/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.mq.internal.inventory;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.service.AdjustmentInventoryHelper;
import com.dtyunxi.cis.pms.biz.service.helper.InventoryTransferHelper;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.tcbj.api.dto.response.LogicWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsLogicInventoryQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsLogicInventoryQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsLogicInventoryRespDto;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutResultOrderDetailRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutResultOrderRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderRespDto;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
public class InTransitAdjustProcessor
implements IMessageProcessor<MessageVo> {
    private static final Logger log = LoggerFactory.getLogger(InTransitAdjustProcessor.class);
    @Resource
    private AdjustmentInventoryHelper adjustmentInventoryHelper;
    @Resource
    private InventoryTransferHelper inventoryTransferHelper;
    @Resource
    private ICsLogicInventoryQueryApi csLogicInventoryQueryApi;

    public MessageResponse process(MessageVo message) {
        log.info("\u5728\u9014\u8c03\u6574\u5355\u751f\u6210\u903b\u8f91:" + message.getData());
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        this.doProcess((String)message.getData());
        return MessageResponse.SUCCESS;
    }

    private void doProcess(String documentNo) {
        Optional.ofNullable(documentNo).map(this::loadData).filter(this::check).map(this::transfer).ifPresent(arg_0 -> ((AdjustmentInventoryHelper)this.adjustmentInventoryHelper).save(arg_0));
    }

    private AdjustmentInventoryHelper.AdjustmentInventoryAddVo transfer(CsOutResultOrderRespDto csOutResultOrderRespDto) {
        return Optional.ofNullable(this.inventoryTransferHelper.getLogicWarehouseByCode(csOutResultOrderRespDto.getInLogicWarehouseCode())).map(req -> this.inventoryTransferHelper.getTransitWarehouse(req.getId())).map(ware -> this.buildAdjustmentInventoryAddVo(csOutResultOrderRespDto, (LogicWarehouseRespDto)ware)).orElse(null);
    }

    private AdjustmentInventoryHelper.AdjustmentInventoryAddVo buildAdjustmentInventoryAddVo(CsOutResultOrderRespDto csOutResultOrderRespDto, LogicWarehouseRespDto ware) {
        AdjustmentInventoryHelper.AdjustmentInventoryAddVo addVo = (AdjustmentInventoryHelper.AdjustmentInventoryAddVo)BeanUtil.copyProperties((Object)csOutResultOrderRespDto, AdjustmentInventoryHelper.AdjustmentInventoryAddVo.class, (String[])new String[0]);
        addVo.setDetailRespDtoList(csOutResultOrderRespDto.getDetailRespDtoList().stream().map(detail -> {
            AdjustmentInventoryHelper.DetailRespDto detailRespDto = (AdjustmentInventoryHelper.DetailRespDto)BeanUtil.copyProperties((Object)detail, AdjustmentInventoryHelper.DetailRespDto.class, (String[])new String[0]);
            CsLogicInventoryRespDto csLogicInventory = this.getCsLogicInventory((CsOutResultOrderDetailRespDto)detail);
            detailRespDto.setProduceTime(csLogicInventory.getProduceTime());
            detailRespDto.setExpireTime(csLogicInventory.getExpireTime());
            return detailRespDto;
        }).collect(Collectors.toList()));
        addVo.setWarehouseCode(ware.getWarehouseCode());
        addVo.setPreOrderNo(csOutResultOrderRespDto.getDocumentNo());
        addVo.setRelevanceNo(csOutResultOrderRespDto.getRelevanceNo());
        boolean out = Objects.equals(csOutResultOrderRespDto.getOrderType(), "out");
        addVo.setOrderType(out ? "in" : "out");
        addVo.setSourceType(out ? "deliverResult" : "receiveResult");
        return addVo;
    }

    private CsOutResultOrderRespDto loadData(String documentNo) {
        return Optional.ofNullable(this.inventoryTransferHelper.getCsOutResultOrder(documentNo)).filter(d -> StringUtils.isNotBlank((CharSequence)d.getDocumentNo())).map(csOutResultOrder -> {
            csOutResultOrder.setInLogicWarehouseCode(Optional.ofNullable(csOutResultOrder.getInLogicWarehouseCode()).filter(StringUtils::isNotBlank).orElseGet(() -> Optional.ofNullable(this.inventoryTransferHelper.getTransferByNo(csOutResultOrder.getRelevanceNo())).map(CsTransferOrderRespDto::getInLogicWarehouseCode).orElse(null)));
            return csOutResultOrder;
        }).orElse(null);
    }

    private boolean check(CsOutResultOrderRespDto csOutResultOrderRespDto) {
        log.info("\u8fdb\u5165\u8c03\u6574\u5355\u6821\u9a8c\u903b\u8f91:{}", (Object)JSON.toJSONString((Object)csOutResultOrderRespDto));
        if (StringUtils.isBlank((CharSequence)csOutResultOrderRespDto.getInLogicWarehouseCode())) {
            return false;
        }
        if (Objects.equals(csOutResultOrderRespDto.getInPhysicsWarehouseCode(), csOutResultOrderRespDto.getOutPhysicsWarehouseCode())) {
            return false;
        }
        return !CollectionUtils.isEmpty((Collection)csOutResultOrderRespDto.getDetailRespDtoList());
    }

    private CsLogicInventoryRespDto getCsLogicInventory(CsOutResultOrderDetailRespDto csOutResultOrderDetailRespDto) {
        CsLogicInventoryQueryDto req = new CsLogicInventoryQueryDto();
        req.setLongCode(csOutResultOrderDetailRespDto.getLongCode());
        req.setBatch(csOutResultOrderDetailRespDto.getBatch());
        req.setFilterProduceTime(Boolean.valueOf(true));
        req.setPageNum(Integer.valueOf(1));
        req.setPageSize(Integer.valueOf(1));
        return Optional.ofNullable(((PageInfo)this.csLogicInventoryQueryApi.queryByPage(req).getData()).getList()).filter(CollectionUtils::isNotEmpty).map(list -> (CsLogicInventoryRespDto)list.get(0)).orElse(new CsLogicInventoryRespDto());
    }
}

