/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.mq.external.trade;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.transform.api.IPcpOrderApi;
import com.dtyunxi.yundt.cube.center.transform.api.constant.PlatformTransformOrderStatus;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderQueryReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.PlatformOrderRespDto;
import com.dtyunxi.yundt.cube.center.transform.api.query.IPlatformOrderQueryApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="SINGLE_TOPIC", tag="DISPLACE_PREEMPT_COMPLITE")
public class YyjPlatformOrderTransformProcessor
implements IMessageProcessor<Set<String>> {
    private static final Logger log = LoggerFactory.getLogger(YyjPlatformOrderTransformProcessor.class);
    @Autowired
    private IPcpOrderApi pcpOrderApi;
    @Autowired
    private IPlatformOrderQueryApi platformOrderQueryApi;
    @Value(value="${yundt.com.yyj.maximumPool.size:20}")
    private Integer yyjMaximumPoolSize = 20;
    private final ExecutorService executorService = new ThreadPoolExecutor(2, this.yyjMaximumPoolSize, 1L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(5, true), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());

    public MessageResponse process(Set<String> message) {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        log.info("\u63a5\u6536\u5230\u8425\u517b\u5bb6\u5b50\u5355\u7f6e\u6362\u5e93\u5b58\u6210\u529f\u8f6c\u5355\u6d88\u606f\uff1a{}", (Object)JSON.toJSONString(message));
        if (message == null || message.isEmpty()) {
            return MessageResponse.SUCCESS;
        }
        PlatformOrderQueryReqDto platformOrderQueryReqDto = new PlatformOrderQueryReqDto();
        platformOrderQueryReqDto.setSaleOrderNoList(new ArrayList<String>(message));
        platformOrderQueryReqDto.setTransferOrderStatus(Integer.valueOf(PlatformTransformOrderStatus.STATUS_INIT_1.code));
        List platformOrderRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.platformOrderQueryApi.queryListByParam(platformOrderQueryReqDto));
        if (CollectionUtils.isEmpty((Collection)platformOrderRespDtos)) {
            log.info("\u672a\u67e5\u8be2\u5230\u5f85\u8f6c\u6e20\u9053\u4fe1\u606f");
            return MessageResponse.SUCCESS;
        }
        final String reqId = ServiceContext.getContext().getAttachment("yes.req.requestId");
        for (final PlatformOrderRespDto platformOrderRespDto : platformOrderRespDtos) {
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    MDC.put((String)"yes.req.requestId", (String)reqId);
                    ServiceContext.getContext().setAttachment("yes.req.requestId", reqId);
                    try {
                        RestResponseHelper.extractData((RestResponse)YyjPlatformOrderTransformProcessor.this.pcpOrderApi.transformPcpOrder(platformOrderRespDto.getId()));
                    }
                    catch (Exception e) {
                        log.error("\u8425\u517b\u5bb6\u5b50\u5355\u8f6c\u5355\u5931\u8d25", (Throwable)e);
                    }
                }
            });
        }
        return MessageResponse.SUCCESS;
    }
}

