/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.mq.saleorder;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleOrderOptApi;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderQueryApi;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="ORDER_SALE_REFUND_WMS_CANCEL_TAG")
public class WmsNotifyCancelProcessor
implements IMessageProcessor<MessageVo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WmsNotifyCancelProcessor.class);
    private final String ORDER_NO = "ORDER_NO";
    @Resource
    private ISaleOrderOptApi saleOrderOptApi;
    @Resource
    private ISaleOrderQueryApi saleOrderQueryApi;

    public MessageResponse process(MessageVo message) {
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        ServiceContext.getContext().setAttachment("yes.req.requestId", requestId);
        LOGGER.info("[\u63a5\u53d7WMS\u53d6\u6d88\u8ba2\u5355\u6d88\u606f]\uff1a{}", (Object)JSON.toJSONString((Object)message.getData()));
        Object messageData = message.getData();
        if (messageData instanceof Map) {
            try {
                Map map = (Map)messageData;
                RestResponse saleOrderRespDtoRestResp = this.saleOrderQueryApi.queryByOrderNo(MapUtil.getStr((Map)map, (Object)"ORDER_NO"));
                BizSaleOrderRespDto bizSaleOrderRespDto = (BizSaleOrderRespDto)RestResponseHelper.extractData((RestResponse)saleOrderRespDtoRestResp);
                RestResponse restResponse = this.saleOrderOptApi.cancelWmsOrder(bizSaleOrderRespDto.getId());
                RestResponseHelper.checkOrThrow((RestResponse)restResponse);
                return MessageResponse.SUCCESS;
            }
            catch (Exception e) {
                LOGGER.error("[\u63a5\u53d7WMS\u53d6\u6d88\u8ba2\u5355\u6d88\u606f]\u5f02\u5e38", (Throwable)e);
                return MessageResponse.SUCCESS;
            }
        }
        return MessageResponse.SUCCESS;
    }
}

