/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.mq.external.inventory;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.pms.biz.service.ExternalService;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsTransferOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.EasTransferOrderDetailReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.EasTransferOrderReqDto;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="OP_EXTERNAL_TOPIC", tag="ALLOT_ORDER_ADD")
public class AllotOrderAddProcessor
implements IMessageProcessor<Map<String, Object>> {
    private static final Logger log = LoggerFactory.getLogger(AllotOrderAddProcessor.class);
    @Autowired
    private ExternalService externalService;
    @Autowired
    private ICsTransferOrderApi transferOrderApi;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageResponse process(Map<String, Object> message) {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        log.info("\u63a5\u6536\u65b0\u589e\u8c03\u62e8\u5355\uff1a{}", (Object)JSON.toJSONString(message));
        String resultCode = "0";
        String resultMsg = "success";
        try {
            RestResponse<Long> response = this.easAddTransferOrder(message);
            resultCode = response.getResultCode();
            resultMsg = response.getResultMsg();
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u8c03\u62e8\u5355\u6d88\u8d39\u5931\u8d25", (Throwable)e);
            resultCode = "100000";
            resultMsg = e.getMessage();
        }
        finally {
            String sendLogId = this.externalService.getSendLogId(message);
            this.externalService.backMsg(sendLogId, resultCode, resultMsg);
        }
        return MessageResponse.SUCCESS;
    }

    private RestResponse<Long> easAddTransferOrder(Map<String, Object> message) {
        EasTransferOrderReqDto transferorder = (EasTransferOrderReqDto)BeanUtil.copyProperties(message, EasTransferOrderReqDto.class, (String[])new String[0]);
        List itemReqDtoList = (List)MapUtil.get(message, (Object)"itemDetailList", List.class);
        List itemList = itemReqDtoList.stream().map(items -> {
            EasTransferOrderDetailReqDto dto = new EasTransferOrderDetailReqDto();
            BeanUtil.copyProperties((Object)items, (Object)dto, (String[])new String[0]);
            dto.setLongCode(Convert.toStr(items.get("skuCode")));
            return dto;
        }).collect(Collectors.toList());
        String inWarehouseCode = transferorder.getInWarehouseCode();
        String outWarehouseCode = transferorder.getOutWarehouseCode();
        Map item = (Map)itemReqDtoList.get(0);
        if (StringUtils.isBlank((CharSequence)inWarehouseCode)) {
            transferorder.setInWarehouseCode(Convert.toStr(item.get("inWarehouseCode")));
        }
        if (StringUtils.isBlank((CharSequence)outWarehouseCode)) {
            transferorder.setOutWarehouseCode(Convert.toStr(item.get("outWarehouseCode")));
        }
        transferorder.setItemDetailList(itemList);
        return this.transferOrderApi.easAddTransferOrder(transferorder);
    }
}

