/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.mq.saleorder;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsDeliveryNoticeOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IChannelInventoryExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.CsInventoryOperateCargoReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.CsInventoryOperateReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SecondSaleOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.YesOrNoEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderQueryReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderItemQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.dto.domain.CsDeliveryNoticeOrderQueryDto;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="PUBLISH_TOPIC", tag="PREEMPT_VIRTUAL_BY_LOGIC_SUCCESS")
public class SaleOrderPreemptVirtualByLogicProcessor
implements IMessageProcessor<MessageVo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaleOrderPreemptVirtualByLogicProcessor.class);
    @Resource
    private ISaleOrderQueryApi saleOrderQueryApi;
    @Resource
    private ISaleOrderItemQueryApi saleOrderItemQueryApi;
    @Resource
    private IChannelInventoryExposedApi shareChannelInventoryExposedApi;
    @Resource
    private ICsDeliveryNoticeOrderQueryApi csDeliveryNoticeOrderQueryApi;

    public MessageResponse process(MessageVo message) {
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        ServiceContext.getContext().setAttachment("yes.req.requestId", requestId);
        LOGGER.info("[\u63a5\u6536\u5e93\u5b58\u9884\u5360\u4f9b\u8d27\u4ed3\u6d88\u606f]\uff1a{}", (Object)JSON.toJSONString((Object)message.getData()));
        Object messageData = message.getData();
        if (Objects.isNull(messageData)) {
            LOGGER.info("\u63a5\u6536\u7684\u6d88\u606f\u4e3a\u7a7a");
            return MessageResponse.SUCCESS;
        }
        String platformOrderNo = messageData.toString();
        SaleOrderQueryReqDto saleOrderQueryReqDto = new SaleOrderQueryReqDto();
        saleOrderQueryReqDto.setPlatformOrderNo(platformOrderNo);
        saleOrderQueryReqDto.setOrderStatusList((List)Lists.newArrayList((Object[])new String[]{SaleOrderStatusEnum.WAIT_CHECK.getCode(), SaleOrderStatusEnum.WAIT_PICK.getCode(), SaleOrderStatusEnum.CANCEL.getCode()}));
        List saleOrderRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByParamList(saleOrderQueryReqDto));
        if (CollectionUtils.isEmpty((Collection)saleOrderRespDtos)) {
            LOGGER.info("\u5df2\u9884\u5360\u6e20\u9053\u4ed3\u4f46\u662f\u672a\u9884\u5360\u903b\u8f91\u4ed3\u7684\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
            return MessageResponse.SUCCESS;
        }
        List orderIdList = saleOrderRespDtos.stream().map(SaleOrderRespDto::getId).collect(Collectors.toList());
        List saleOrderItemRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.saleOrderItemQueryApi.queryNormalItemsByOrderIds((List)Lists.newArrayList(orderIdList)));
        Map<Object, Object> orderDetailMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)saleOrderItemRespDtos)) {
            orderDetailMap = saleOrderItemRespDtos.stream().collect(Collectors.groupingBy(SaleOrderItemRespDto::getOrderId));
        }
        for (SaleOrderRespDto saleOrderRespDto : saleOrderRespDtos) {
            if (StringUtils.isEmpty((CharSequence)saleOrderRespDto.getMainOrderNo())) {
                LOGGER.info("\u4e3b\u5355\u4e0d\u505a\u66f4\u65b0\u9884\u5360\u5e93\u5b58");
                continue;
            }
            if (Objects.equals(saleOrderRespDto.getOrderStatus(), SaleOrderStatusEnum.WAIT_PICK.getCode()) && Objects.equals(saleOrderRespDto.getSecondOrderStatus(), SecondSaleOrderStatusEnum.WAIT_PICK_LOCK_UN_APPOINT.getCode())) {
                LOGGER.info("\u8ba2\u5355\u5df2\u9884\u5360\u903b\u8f91\u4ed3\u5e93\u5b58");
                continue;
            }
            boolean logicInventoryFlag = this.getLogicInventoryFlag(saleOrderRespDto.getSaleOrderNo());
            if (logicInventoryFlag) {
                LOGGER.info("\u8ba2\u5355\u5df2\u6709\u903b\u8f91\u4ed3\u9884\u5360\u8bb0\u5f55");
                continue;
            }
            List itemRespDtoList = (List)orderDetailMap.get(saleOrderRespDto.getId());
            try {
                LOGGER.info("\u66f4\u65b0\u9884\u5360\u5e93\u5b58");
                this.updateInventoryByPreemption(saleOrderRespDto, itemRespDtoList);
            }
            catch (Exception e) {
                LOGGER.info("\u66f4\u65b0\u9884\u5360\u5e93\u5b58\u5931\u8d25:{}", (Object)e.getMessage());
            }
        }
        return MessageResponse.SUCCESS;
    }

    public void updateInventoryByPreemption(SaleOrderRespDto saleOrderEo, List<SaleOrderItemRespDto> orderItemEos) {
        CsInventoryOperateReqDto inventoryOperateReqDto = new CsInventoryOperateReqDto();
        inventoryOperateReqDto.setSourceNo(saleOrderEo.getSaleOrderNo());
        inventoryOperateReqDto.setSourceType(saleOrderEo.getOrderType());
        inventoryOperateReqDto.setPlatformOrderNo(saleOrderEo.getPlatformOrderNo());
        if (this.isClaimOrder(saleOrderEo.getOrderType())) {
            if (StringUtils.isNotBlank((CharSequence)saleOrderEo.getMainOrderNo())) {
                inventoryOperateReqDto.setPlatformOrderNo(saleOrderEo.getMainOrderNo());
            } else {
                inventoryOperateReqDto.setPlatformOrderNo(saleOrderEo.getSaleOrderNo());
            }
        }
        inventoryOperateReqDto.setChannelCode(saleOrderEo.getChannelCode());
        inventoryOperateReqDto.setOperateVersion(Integer.valueOf(2));
        inventoryOperateReqDto.setReleaseSourceNo(saleOrderEo.getMainOrderNo());
        LOGGER.info("AllowSplitFlag==>{},StoragePlace==>{}", (Object)saleOrderEo.getAllowSplitFlag(), (Object)saleOrderEo.getStoragePlace());
        if (Objects.equals(saleOrderEo.getAllowSplitFlag(), YesOrNoEnum.NO.getType()) && StringUtils.isNotBlank((CharSequence)saleOrderEo.getStoragePlace())) {
            inventoryOperateReqDto.setIsShoutVirtualWarehouse(Boolean.TRUE);
            inventoryOperateReqDto.setShoutVirtualWarehouseCode(saleOrderEo.getStoragePlace());
        }
        List operateCargoReqDtoList = orderItemEos.stream().map(saleOrderItemEo -> {
            CsInventoryOperateCargoReqDto inventoryOperateCargoReqDto = new CsInventoryOperateCargoReqDto();
            inventoryOperateCargoReqDto.setSkuCode(saleOrderItemEo.getSkuCode());
            inventoryOperateCargoReqDto.setChangeInventory(saleOrderItemEo.getItemNum());
            inventoryOperateCargoReqDto.setWarehouseCode(saleOrderItemEo.getChannelWarehouseCode());
            inventoryOperateCargoReqDto.setBatch(saleOrderItemEo.getBatchNo());
            return inventoryOperateCargoReqDto;
        }).collect(Collectors.toList());
        inventoryOperateReqDto.setOperateCargoReqDtoList(operateCargoReqDtoList);
        LOGGER.info("\u66f4\u65b0\u9884\u5360\u5e93\u5b58\u53d1\u8d77\u7684\u53c2\u6570\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)inventoryOperateReqDto));
        RestResponseHelper.extractData((RestResponse)this.shareChannelInventoryExposedApi.updateInventoryByPreemption((List)Lists.newArrayList((Object[])new CsInventoryOperateReqDto[]{inventoryOperateReqDto})));
    }

    private boolean isClaimOrder(String orderType) {
        return SaleOrderTypeEnum.CLAIM_POSTING.getType().equals(orderType) || SaleOrderTypeEnum.CLAIM_REISSUE.getType().equals(orderType);
    }

    private boolean getLogicInventoryFlag(String saleOrderNo) {
        CsDeliveryNoticeOrderQueryDto params = new CsDeliveryNoticeOrderQueryDto();
        params.setPreOrderNo(saleOrderNo);
        params.setPageNum(Integer.valueOf(1));
        params.setPageSize(Integer.valueOf(100));
        LOGGER.info("\u67e5\u8be2\u53d1\u8d27\u901a\u77e5\u5355\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)params));
        PageInfo csDeliveryNoticeOrderRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csDeliveryNoticeOrderQueryApi.queryByPage(params));
        LOGGER.info("\u67e5\u8be2\u53d1\u8d27\u901a\u77e5\u5355\u54cd\u5e94:{}", (Object)JSON.toJSONString((Object)csDeliveryNoticeOrderRespDtoPageInfo));
        if (CollectionUtils.isEmpty((Collection)csDeliveryNoticeOrderRespDtoPageInfo.getList())) {
            return false;
        }
        List notCancelList = csDeliveryNoticeOrderRespDtoPageInfo.getList().stream().filter(dto -> !Objects.equals(dto.getOrderStatus(), BaseOrderStatusEnum.DNO_CANCEL.getCode())).collect(Collectors.toList());
        return !CollectionUtils.isEmpty(notCancelList);
    }
}

