/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.mq.external.item;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.tcbj.center.openapi.api.external.IExternalWmsApi;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsStockReqDto;
import com.dtyunxi.yundt.cube.center.data.api.dto.DictDto;
import com.dtyunxi.yundt.cube.center.data.api.query.IDictQueryApi;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="ITEM_STOCK_SYNC_TAG")
public class AddItemToWmsProcessor
implements IMessageProcessor<String> {
    private static final Logger log = LoggerFactory.getLogger(AddItemToWmsProcessor.class);
    @Resource
    private IExternalWmsApi externalWmsApi;
    @Resource
    private IDictQueryApi dictQueryApi;

    public MessageResponse process(String message) {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        log.info("\u63a5\u6536item\u5546\u54c1\u521b\u5efa\u540c\u6b65\uff1a{}", (Object)message);
        try {
            WmsStockReqDto wmsStockReqDto = (WmsStockReqDto)JSONObject.parseObject((String)message, WmsStockReqDto.class);
            DictDto dictDto = (DictDto)this.dictQueryApi.queryByGroupCodeAndCode(Long.valueOf(1L), "PUSH_ITEM_DATA", "PUSH_ITEM_DATA_TO_RQ").getData();
            Map map = (Map)JSON.parseObject((String)dictDto.getValue(), Map.class);
            map.keySet().forEach(n -> {
                wmsStockReqDto.setWarehouseCode(n);
                wmsStockReqDto.setCustomerId(String.valueOf(map.get(n)));
                this.externalWmsApi.singleItemSynchronize(wmsStockReqDto);
            });
        }
        catch (Exception e) {
            log.error("\u63a5\u6536item\u5546\u54c1\u521b\u5efa\u540c\u6b65\u5931\u8d25", (Throwable)e);
        }
        return MessageResponse.SUCCESS;
    }
}

