/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.pms.mq.external.inventory;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cis.pms.biz.enums.YesOrNoEnum;
import com.dtyunxi.cis.pms.biz.service.helper.SaleAllotMqHelper;
import com.dtyunxi.cis.pms.mq.utils.RestUtil;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.ICsLogisticsInfoApi;
import com.dtyunxi.tcbj.api.ISaleTransferExtApi;
import com.dtyunxi.tcbj.api.dto.request.CountRelateNoticeOrderReqDto;
import com.dtyunxi.tcbj.api.dto.request.CsLogisticsInfoReqDto;
import com.dtyunxi.tcbj.api.dto.request.SaleTransferExtReqDto;
import com.dtyunxi.tcbj.api.dto.response.ConsignmentOrderDeliveryInfoRespDto;
import com.dtyunxi.tcbj.api.dto.response.CountRelateNoticeOrderRespDto;
import com.dtyunxi.tcbj.api.dto.response.SaleTransferExtRespDto;
import com.dtyunxi.tcbj.api.query.IConsignmentOrderQueryApi;
import com.dtyunxi.tcbj.api.query.IOutNoticeOrderQueryApi;
import com.dtyunxi.tcbj.api.query.ISaleOrderReportQueryApi;
import com.dtyunxi.tcbj.center.openapi.api.external.IExternalWmsApi;
import com.dtyunxi.tcbj.center.openapi.common.wms.WmsIntransitInfoDto;
import com.dtyunxi.tcbj.center.openapi.common.wms.WmsOrderBaseDto;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsItemLine;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsStockEntryOrderReqDto;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsStockOutOrderReqDto;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.ICsInventoryPreemptionApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsLogicWarehouseExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsWarehouseAddressApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsOtherStorageOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsTransferOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsTransferOrderDetailApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.CsOtherStorageOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.CsOtherStorageOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.resp.CsOtherStorageOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryPreemptionQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsWarehouseAddressParamQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsWarehouseAddressRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsPcpBusinessTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderLevelEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderTagBaseRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderItemExtRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleRefundItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderQueryApi;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleRefundQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderDetailRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderRespDto;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.LogUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class StockOutAndInAddProcessor
implements IMessageProcessor<MessageVo> {
    private static final Logger log = LoggerFactory.getLogger(StockOutAndInAddProcessor.class);
    @Resource
    private IExternalWmsApi externalWmsApi;
    @Resource
    private ISaleOrderQueryApi saleOrderQueryApi;
    @Resource
    private ICsTransferOrderApi csTransferOrderQueryApi;
    @Resource
    private ISaleRefundQueryApi saleRefundQueryApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private ICacheService cacheService;
    @Resource
    private ICsLogisticsInfoApi csLogisticsInfoApi;
    @Resource
    private ICsWarehouseAddressApi csWarehouseAddressQueryApi;
    @Resource
    private IOutNoticeOrderQueryApi outNoticeOrderQueryApi;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private ISaleOrderReportQueryApi saleOrderReportQueryApi;
    @Resource
    private ICsOtherStorageOrderApi csOtherStorageOrderQueryApi;
    @Resource
    private ICsLogicWarehouseExposedApi csLogicWarehouseExposedQueryApi;
    @Autowired
    ISaleTransferExtApi saleTransferExtApi;
    @Autowired
    IConsignmentOrderQueryApi consignmentOrderQueryApi;
    @Autowired
    ICsTransferOrderDetailApi csTransferOrderDetailApi;
    @Resource
    private SaleAllotMqHelper saleAllotMqHelper;
    @Autowired
    ICsInventoryPreemptionApi csInventoryPreemptionApi;
    @Autowired
    ILockService lockService;
    protected static final String MERGE_LOCK = "merge_lock";
    protected static final int LOCK_TIME_OUT = 10;
    private final String defaultCustomer = "QTKH";
    private final String defaultCustomerName = "\u5176\u4ed6\u5ba2\u6237";
    @Value(value="#{'${pms.push.wms.wh:ZHK}'.split(',')}")
    private List<String> zhWhs;
    ThreadLocal<String> msg = new ThreadLocal();
    private final String redisMergeOrderGroup = "ORDER_MERGE";

    public boolean isDuplicationMessage(String msgId, MessageVo message) {
        this.msg.set(msgId);
        return this.cacheService.setIfAbsent(msgId, (Object)1, 60) == false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageResponse process(MessageVo message) {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        ServiceContext.getContext().setAttachment("yes.req.requestId", RequestId.createReqId());
        log.info("\u63a5\u6536WMS\u51fa\u5165\u5e93\u521b\u5efa\u540c\u6b65\uff1a{}", (Object)JSON.toJSONString((Object)message));
        try {
            this.doProcess(message);
        }
        catch (Exception e) {
            this.cacheService.delCache(this.msg.get());
            WmsOrderBaseDto wmsStockOutOrderReqDto = (WmsOrderBaseDto)JSONObject.parseObject((String)((String)message.getData()), WmsOrderBaseDto.class);
            log.error("\u63a5\u6536WMS\u51fa\u5165\u5e93\u521b\u5efa\u540c\u6b65\u5931\u8d25:{},:{},:{}", new Object[]{e.getMessage(), this.msg.get(), wmsStockOutOrderReqDto.getDocumentNo()});
            e.printStackTrace();
            MessageResponse messageResponse = MessageResponse.ERROR;
            return messageResponse;
        }
        finally {
            this.msg.remove();
        }
        return MessageResponse.SUCCESS;
    }

    private void doProcess(MessageVo message) {
        if (message.getExtValue1() != null) {
            RestResponseHelper.extractData((RestResponse)this.externalWmsApi.stockOutCreate(this.transferWmsStockOutOrderReqDto(message)));
        } else {
            RestResponseHelper.extractData((RestResponse)this.externalWmsApi.entryOrderCreate(this.transferWmsStockEntryOrderReqDto(message)));
        }
    }

    private void editData(WmsOrderBaseDto wmsOrderBaseDto) {
        this.loadCustomerData(wmsOrderBaseDto);
        this.settingOrderPrice(wmsOrderBaseDto);
        this.settingBatch(wmsOrderBaseDto);
        this.businessTypeTransfer(wmsOrderBaseDto);
        this.orderLineHandler(wmsOrderBaseDto);
        this.transferOutNo(wmsOrderBaseDto);
        this.settingCustomerCode(wmsOrderBaseDto);
        this.addressProcess(wmsOrderBaseDto);
        this.saleOrderEASVerify(wmsOrderBaseDto);
        this.saleOrderExtend(wmsOrderBaseDto);
        this.saleAllotExtend(wmsOrderBaseDto);
    }

    private void saleOrderExtend(WmsOrderBaseDto wmsOrderBaseDto) {
        try {
            String relevanceNo = wmsOrderBaseDto.getRelevanceNo();
            BizSaleOrderRespDto bizSaleOrderRespDto = null;
            try {
                bizSaleOrderRespDto = (BizSaleOrderRespDto)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderNo(relevanceNo));
            }
            catch (Exception e) {
                log.info("\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5f02\u5e38: {}, {}", (Object)relevanceNo, (Object)e.getMessage());
            }
            log.info("saleOrderExtend bizSaleOrderRespDto: {}", (Object)LogUtils.buildLogContent((Object)bizSaleOrderRespDto));
            if (Objects.isNull(bizSaleOrderRespDto) || null == bizSaleOrderRespDto.getId()) {
                log.info("orderId \u4e3a\u7a7a...............");
                return;
            }
            Long orderId = bizSaleOrderRespDto.getId();
            SaleTransferExtReqDto saleTransferExtReqDto = new SaleTransferExtReqDto();
            saleTransferExtReqDto.setOrderId(orderId);
            List saleTransferExtRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.saleTransferExtApi.queryList(saleTransferExtReqDto));
            if (null == saleTransferExtRespDtoList) {
                saleTransferExtRespDtoList = Lists.newArrayList();
            }
            log.info("saleOrderExtend saleTransferExtRespDtoList:{}", (Object)LogUtils.buildLogContent((Collection)saleTransferExtRespDtoList));
            List consignmentOrderDeliveryInfoRespDtoList = Lists.newArrayList();
            List transferNoList = saleTransferExtRespDtoList.stream().map(SaleTransferExtRespDto::getTransferOrderNo).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(transferNoList)) {
                consignmentOrderDeliveryInfoRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.consignmentOrderQueryApi.queryDeliveryInfoByBusinessNoList(transferNoList));
            }
            log.info("saleOrderExtend consignmentOrderDeliveryInfoRespDtoList:{}", (Object)LogUtils.buildLogContent((Collection)consignmentOrderDeliveryInfoRespDtoList));
            CsInventoryPreemptionQueryDto queryDto = new CsInventoryPreemptionQueryDto();
            queryDto.setSourceNo(wmsOrderBaseDto.getRelevanceNo());
            List preemptionRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.csInventoryPreemptionApi.queryList(queryDto));
            if (CollectionUtils.isEmpty((Collection)preemptionRespDtoList)) {
                log.info("\u9884\u5360\u8bb0\u5f55\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a..................");
                return;
            }
            log.info("saleOrderExtend preemptionRespDtoList: {}", (Object)LogUtils.buildLogContent((Collection)preemptionRespDtoList));
            ArrayList mainIntransitInfo = Lists.newArrayList();
            boolean mainIntransitFlag = Boolean.FALSE;
            for (WmsItemLine itemLine : wmsOrderBaseDto.getItemLines()) {
                ArrayList itemIntransitInfo = Lists.newArrayList();
                List transferExtRespDtos = saleTransferExtRespDtoList.stream().filter(o -> StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)itemLine.getCargoCode())).collect(Collectors.toList());
                log.info("saleOrderExtend transferExtRespDtos:{}", (Object)LogUtils.buildLogContent(transferExtRespDtos));
                if (CollectionUtil.isEmpty(transferExtRespDtos)) {
                    WmsIntransitInfoDto intransitInfoDto = new WmsIntransitInfoDto();
                    intransitInfoDto.setIntransitFlag(0);
                    itemIntransitInfo.add(intransitInfoDto);
                    itemLine.setIntransitInfo((List)itemIntransitInfo);
                    continue;
                }
                List transferNos = transferExtRespDtos.stream().map(SaleTransferExtRespDto::getTransferOrderNo).distinct().collect(Collectors.toList());
                List consignmentOrderDeliveryInfoRespDtos = consignmentOrderDeliveryInfoRespDtoList.stream().filter(o -> transferNos.contains(o.getBusinessNo())).collect(Collectors.toList());
                boolean intransitFlag = preemptionRespDtoList.stream().anyMatch(o -> StringUtils.equals((CharSequence)itemLine.getCargoCode(), (CharSequence)o.getCargoCode()) && BigDecimalUtils.gtZero((BigDecimal)o.getLessNum()) != false && StringUtils.isNotBlank((CharSequence)o.getLendWarehouseCode()));
                if (CollectionUtil.isEmpty(transferExtRespDtos)) {
                    WmsIntransitInfoDto intransitInfoDto = new WmsIntransitInfoDto();
                    intransitInfoDto.setIntransitFlag(0);
                    itemIntransitInfo.add(intransitInfoDto);
                } else {
                    for (String transferNo : transferNos) {
                        WmsIntransitInfoDto intransitInfoDto = new WmsIntransitInfoDto();
                        intransitInfoDto.setIntransitFlag(intransitFlag ? 1 : 0);
                        intransitInfoDto.setPreTransferNo(transferNo);
                        ConsignmentOrderDeliveryInfoRespDto consignmentOrderDeliveryInfoRespDto = consignmentOrderDeliveryInfoRespDtos.stream().filter(o -> StringUtils.equals((CharSequence)o.getBusinessNo(), (CharSequence)transferNo)).findFirst().orElse(null);
                        if (null != consignmentOrderDeliveryInfoRespDto) {
                            intransitInfoDto.setCarNum(consignmentOrderDeliveryInfoRespDto.getCarLicenseNo());
                            intransitInfoDto.setDriverName(consignmentOrderDeliveryInfoRespDto.getDriverName());
                            intransitInfoDto.setDriverPhone(consignmentOrderDeliveryInfoRespDto.getDriverPhone());
                        }
                        itemIntransitInfo.add(intransitInfoDto);
                        if (mainIntransitFlag || !YesNoHelper.isYes((Integer)intransitInfoDto.getIntransitFlag())) continue;
                        mainIntransitFlag = Boolean.TRUE;
                    }
                }
                itemLine.setIntransitInfo((List)itemIntransitInfo);
            }
            if (CollectionUtil.size((Object)saleTransferExtRespDtoList) == 0) {
                WmsIntransitInfoDto intransitInfoDto = new WmsIntransitInfoDto();
                intransitInfoDto.setIntransitFlag(0);
                mainIntransitInfo.add(intransitInfoDto);
            } else {
                for (String transferNo : transferNoList) {
                    ConsignmentOrderDeliveryInfoRespDto consignmentOrderDeliveryInfoRespDto = consignmentOrderDeliveryInfoRespDtoList.stream().filter(o -> StringUtils.equals((CharSequence)o.getBusinessNo(), (CharSequence)transferNo)).findFirst().orElse(null);
                    WmsIntransitInfoDto intransitInfoDto = new WmsIntransitInfoDto();
                    intransitInfoDto.setIntransitFlag(mainIntransitFlag ? 1 : 0);
                    intransitInfoDto.setPreTransferNo(transferNo);
                    if (null != consignmentOrderDeliveryInfoRespDto) {
                        intransitInfoDto.setCarNum(consignmentOrderDeliveryInfoRespDto.getCarLicenseNo());
                        intransitInfoDto.setDriverName(consignmentOrderDeliveryInfoRespDto.getDriverName());
                        intransitInfoDto.setDriverPhone(consignmentOrderDeliveryInfoRespDto.getDriverPhone());
                    }
                    mainIntransitInfo.add(intransitInfoDto);
                }
            }
            wmsOrderBaseDto.setIntransitInfo((List)mainIntransitInfo);
        }
        catch (Exception e) {
            log.info("\u8865\u5145\u9500\u552e\u8ba2\u5355 \u9500\u552e\u9884\u5360\u4fe1\u606f\u5f02\u5e38");
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void saleAllotExtend(WmsOrderBaseDto wmsOrderBaseDto) {
        try {
            if (!CsPcpBusinessTypeEnum.ALLOT_SALE.getCode().equals(wmsOrderBaseDto.getBusinessType())) {
                return;
            }
            CsTransferOrderRespDto csTransferOrderRespDto = (CsTransferOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csTransferOrderQueryApi.queryByTransferOrderNo(wmsOrderBaseDto.getRelevanceNo()));
            AssertUtils.notNull((Object)csTransferOrderRespDto, (String)"\u8c03\u62e8\u5355\u67e5\u8be2\u4e0d\u5b58\u5728");
            BizSaleOrderRespDto bizSaleOrderRespDto = null;
            try {
                bizSaleOrderRespDto = (BizSaleOrderRespDto)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderNo(csTransferOrderRespDto.getSaleOrderNo()));
            }
            catch (Exception e) {
                log.info("saleAllotExtend \u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5f02\u5e38: {}, {}", (Object)csTransferOrderRespDto.getSaleOrderNo(), (Object)e.getMessage());
            }
            log.info("saleAllotExtend bizSaleOrderRespDto: {}", (Object)LogUtils.buildLogContent((Object)bizSaleOrderRespDto));
            Long orderId = bizSaleOrderRespDto.getId();
            if (null == orderId) {
                log.info("saleAllotExtend orderId \u4e3a\u7a7a...............");
                return;
            }
            SaleTransferExtReqDto saleTransferExtReqDto = new SaleTransferExtReqDto();
            saleTransferExtReqDto.setOrderId(orderId);
            List saleTransferExtRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.saleTransferExtApi.queryList(saleTransferExtReqDto));
            if (null == saleTransferExtRespDtoList) {
                saleTransferExtRespDtoList = Lists.newArrayList();
            }
            log.info("saleAllotExtend saleTransferExtRespDtoList:{}", (Object)LogUtils.buildLogContent((Collection)saleTransferExtRespDtoList));
            List consignmentOrderDeliveryInfoRespDtoList = Lists.newArrayList();
            List transferNoList = saleTransferExtRespDtoList.stream().map(SaleTransferExtRespDto::getTransferOrderNo).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(transferNoList)) {
                consignmentOrderDeliveryInfoRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.consignmentOrderQueryApi.queryDeliveryInfoByBusinessNoList(transferNoList));
            }
            log.info("saleAllotExtend consignmentOrderDeliveryInfoRespDtoList:{}", (Object)LogUtils.buildLogContent((Collection)consignmentOrderDeliveryInfoRespDtoList));
            CsInventoryPreemptionQueryDto queryDto = new CsInventoryPreemptionQueryDto();
            queryDto.setSourceNo(wmsOrderBaseDto.getRelevanceNo());
            List preemptionRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.csInventoryPreemptionApi.queryList(queryDto));
            if (CollectionUtils.isEmpty((Collection)preemptionRespDtoList)) {
                log.info("\u9884\u5360\u8bb0\u5f55\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a..................");
                return;
            }
            log.info("saleAllotExtend preemptionRespDtoList: {}", (Object)LogUtils.buildLogContent((Collection)preemptionRespDtoList));
            ArrayList mainIntransitInfo = Lists.newArrayList();
            boolean mainIntransitFlag = Boolean.FALSE;
            for (WmsItemLine itemLine : wmsOrderBaseDto.getItemLines()) {
                ArrayList itemIntransitInfo = Lists.newArrayList();
                List transferExtRespDtos = saleTransferExtRespDtoList.stream().filter(o -> StringUtils.equals((CharSequence)o.getSkuCode(), (CharSequence)itemLine.getCargoCode())).collect(Collectors.toList());
                if (CollectionUtil.isEmpty(transferExtRespDtos)) {
                    WmsIntransitInfoDto intransitInfoDto = new WmsIntransitInfoDto();
                    intransitInfoDto.setIntransitFlag(0);
                    itemIntransitInfo.add(intransitInfoDto);
                    itemLine.setIntransitInfo((List)itemIntransitInfo);
                    continue;
                }
                List transferNos = transferExtRespDtos.stream().map(SaleTransferExtRespDto::getTransferOrderNo).distinct().collect(Collectors.toList());
                List consignmentOrderDeliveryInfoRespDtos = consignmentOrderDeliveryInfoRespDtoList.stream().filter(o -> transferNos.contains(o.getBusinessNo())).collect(Collectors.toList());
                boolean intransitFlag = preemptionRespDtoList.stream().anyMatch(o -> StringUtils.equals((CharSequence)itemLine.getCargoCode(), (CharSequence)o.getCargoCode()) && BigDecimalUtils.gtZero((BigDecimal)o.getLessNum()) != false && StringUtils.isNotBlank((CharSequence)o.getLendWarehouseCode()));
                if (CollectionUtils.isEmpty(transferExtRespDtos)) {
                    WmsIntransitInfoDto intransitInfoDto = new WmsIntransitInfoDto();
                    intransitInfoDto.setIntransitFlag(0);
                    itemIntransitInfo.add(intransitInfoDto);
                } else {
                    for (String transferNo : transferNos) {
                        WmsIntransitInfoDto intransitInfoDto = new WmsIntransitInfoDto();
                        intransitInfoDto.setIntransitFlag(intransitFlag ? 1 : 0);
                        intransitInfoDto.setPreTransferNo(transferNo);
                        ConsignmentOrderDeliveryInfoRespDto consignmentOrderDeliveryInfoRespDto = consignmentOrderDeliveryInfoRespDtos.stream().filter(o -> StringUtils.equals((CharSequence)o.getBusinessNo(), (CharSequence)transferNo)).findFirst().orElse(null);
                        if (null != consignmentOrderDeliveryInfoRespDto) {
                            intransitInfoDto.setCarNum(consignmentOrderDeliveryInfoRespDto.getCarLicenseNo());
                            intransitInfoDto.setDriverName(consignmentOrderDeliveryInfoRespDto.getDriverName());
                            intransitInfoDto.setDriverPhone(consignmentOrderDeliveryInfoRespDto.getDriverPhone());
                        }
                        itemIntransitInfo.add(intransitInfoDto);
                        if (mainIntransitFlag || !YesNoHelper.isYes((Integer)intransitInfoDto.getIntransitFlag())) continue;
                        mainIntransitFlag = Boolean.TRUE;
                    }
                }
                itemLine.setIntransitInfo((List)itemIntransitInfo);
            }
            if (CollectionUtils.isEmpty((Collection)saleTransferExtRespDtoList)) {
                WmsIntransitInfoDto intransitInfoDto = new WmsIntransitInfoDto();
                intransitInfoDto.setIntransitFlag(0);
                mainIntransitInfo.add(intransitInfoDto);
            } else {
                for (String transferNo : transferNoList) {
                    ConsignmentOrderDeliveryInfoRespDto consignmentOrderDeliveryInfoRespDto = consignmentOrderDeliveryInfoRespDtoList.stream().filter(o -> StringUtils.equals((CharSequence)o.getBusinessNo(), (CharSequence)transferNo)).findFirst().orElse(null);
                    WmsIntransitInfoDto intransitInfoDto = new WmsIntransitInfoDto();
                    intransitInfoDto.setIntransitFlag(mainIntransitFlag ? 1 : 0);
                    intransitInfoDto.setPreTransferNo(transferNo);
                    if (null != consignmentOrderDeliveryInfoRespDto) {
                        intransitInfoDto.setCarNum(consignmentOrderDeliveryInfoRespDto.getCarLicenseNo());
                        intransitInfoDto.setDriverName(consignmentOrderDeliveryInfoRespDto.getDriverName());
                        intransitInfoDto.setDriverPhone(consignmentOrderDeliveryInfoRespDto.getDriverPhone());
                    }
                    mainIntransitInfo.add(intransitInfoDto);
                }
            }
            wmsOrderBaseDto.setIntransitInfo((List)mainIntransitInfo);
            log.info("after saleAllotExtend : {}", (Object)LogUtils.buildLogContent((Object)wmsOrderBaseDto));
        }
        catch (Exception e) {
            log.info("\u8865\u5145\u9500\u552e\u8c03\u62e8 \u4fe1\u606f\u5f02\u5e38.........");
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void orderLineHandler(WmsOrderBaseDto wmsOrderBaseDto) {
        List csTransferOrderDetailRespDtoList;
        if (!wmsOrderBaseDto.isEnableBatch() && CsPcpBusinessTypeEnum.INTERNAL_DEAL.equals((Object)CsPcpBusinessTypeEnum.getByCode((String)wmsOrderBaseDto.getBusinessType())) && CsPcpBusinessTypeEnum.ALLOT_SALE.equals((Object)CsPcpBusinessTypeEnum.getByCode((String)wmsOrderBaseDto.getBusinessType()))) {
            this.orderLineMarge(wmsOrderBaseDto);
        }
        this.orderLineBatchMarge(wmsOrderBaseDto);
        if ("in".equals(wmsOrderBaseDto.getOrderType())) {
            return;
        }
        String relevanceNo = wmsOrderBaseDto.getRelevanceNo();
        ArrayList pushBatchBusinessTypeList = Lists.newArrayList((Object[])new String[]{CsPcpBusinessTypeEnum.INTERNAL_DEAL_RETURN.getCode(), CsPcpBusinessTypeEnum.SALE_RETURN_INTERNAL_DEAL.getCode(), CsPcpBusinessTypeEnum.PURCHASE_REFUND.getCode(), CsPcpBusinessTypeEnum.PRODUCT_REPAIR.getCode(), CsPcpBusinessTypeEnum.ALLOT_OUT.getCode(), CsPcpBusinessTypeEnum.MAIYOU_ALLOT_OUT.getCode(), CsPcpBusinessTypeEnum.INSPECTION_QUALIFIED.getCode(), CsPcpBusinessTypeEnum.ALLOT_LOGIC_OUT.getCode(), CsPcpBusinessTypeEnum.ALLOT_LOSE_EFFICACY.getCode()});
        Boolean isPushBatch = pushBatchBusinessTypeList.contains(wmsOrderBaseDto.getBusinessType());
        Boolean isSaleOrder = StringUtils.contains((CharSequence)relevanceNo, (CharSequence)"DD");
        Boolean isOtherOutOrder = CsPcpBusinessTypeEnum.OTHER_OUT.getCode().equals(wmsOrderBaseDto.getBusinessType());
        Boolean isAllotOnlyOut = CsPcpBusinessTypeEnum.ALLOT_OUT_ONLY.getCode().equals(wmsOrderBaseDto.getBusinessType());
        List itemList = Lists.newArrayList();
        if (isSaleOrder.booleanValue()) {
            BizSaleOrderRespDto bizSaleOrderRespDto = (BizSaleOrderRespDto)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderNo(relevanceNo));
            if (null != bizSaleOrderRespDto) {
                itemList = bizSaleOrderRespDto.getItemList();
                log.info("orderLineMarge items: {}", (Object)LogUtils.buildLogContent((Collection)itemList));
            }
        } else if (isOtherOutOrder.booleanValue()) {
            CsOtherStorageOrderRespDto csOtherStorageOrderRespDto;
            CsOtherStorageOrderRespDto csOtherStorageOrderAndDetailRespDto;
            CsOtherStorageOrderReqDto csOtherStorageOrderReqDto = new CsOtherStorageOrderReqDto();
            csOtherStorageOrderReqDto.setStorageOrderNo(relevanceNo);
            List csOtherStorageOrderRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.csOtherStorageOrderQueryApi.queryByParams(csOtherStorageOrderReqDto));
            if (CollectionUtil.isNotEmpty((Collection)csOtherStorageOrderRespDtoList) && null != (csOtherStorageOrderAndDetailRespDto = (CsOtherStorageOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csOtherStorageOrderQueryApi.queryById((csOtherStorageOrderRespDto = (CsOtherStorageOrderRespDto)csOtherStorageOrderRespDtoList.get(0)).getId()))) && CollectionUtil.isNotEmpty((Collection)csOtherStorageOrderAndDetailRespDto.getDetailRespDtoList())) {
                isPushBatch = StringUtils.isNotBlank((CharSequence)((CsOtherStorageOrderDetailRespDto)csOtherStorageOrderAndDetailRespDto.getDetailRespDtoList().get(0)).getBatch());
            }
        } else if (isAllotOnlyOut.booleanValue() && CollectionUtil.isNotEmpty((Collection)(csTransferOrderDetailRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.csTransferOrderDetailApi.queryListByTransferOrderNo(relevanceNo))))) {
            CsTransferOrderDetailRespDto csTransferOrderDetailRespDto = (CsTransferOrderDetailRespDto)csTransferOrderDetailRespDtoList.get(0);
            isPushBatch = StringUtils.isNotBlank((CharSequence)csTransferOrderDetailRespDto.getBatch());
        }
        Map<String, List<SaleOrderItemExtRespDto>> saleOrderItemMap = itemList.stream().collect(Collectors.groupingBy(o -> o.getSkuCode()));
        log.info("isPushBatch: {}", (Object)isPushBatch);
        for (WmsItemLine itemLine : wmsOrderBaseDto.getItemLines()) {
            if (isSaleOrder.booleanValue()) {
                isPushBatch = true;
                List<SaleOrderItemExtRespDto> skuItems = saleOrderItemMap.get(itemLine.getCargoCode());
                if (!CollectionUtil.isNotEmpty(skuItems) || !StringUtils.isBlank((CharSequence)skuItems.get(0).getDeliveryItemBatchNo())) continue;
                itemLine.setBatch(null);
                isPushBatch = false;
                continue;
            }
            if (isPushBatch.booleanValue()) continue;
            itemLine.setBatch(null);
        }
        if (!isPushBatch.booleanValue()) {
            this.orderLineMarge(wmsOrderBaseDto);
        }
    }

    private void settingBatch(WmsOrderBaseDto wmsOrderBaseDto) {
        CsPcpBusinessTypeEnum type = CsPcpBusinessTypeEnum.getByCode((String)wmsOrderBaseDto.getBusinessType());
        boolean igBatch = false;
        switch (type) {
            case ALLOT_OUT: 
            case MAIYOU_ALLOT_OUT: 
            case ALLOT_OUT_ONLY: 
            case ALLOT_IN_ONLY: 
            case ORDER_SALES_OUT: 
            case PRESALE_ORDER: 
            case ORDER_SALES_REFUND: 
            case PURCHASE_REFUND: 
            case OUTSOURCE_REFUND: 
            case OTHER_IN: 
            case OTHER_OUT: 
            case ALLOT_BC_EFFICACY: 
            case INTERNAL_DEAL: 
            case AGENCY_ORDER: 
            case NUTRITION_INTEGRAL: 
            case INTEGRAL_ORDER: 
            case REPLENISHMENT_ORDER: 
            case ACTIVITY_ORDER: 
            case CUSTOMER_REFUNDING_ORDER: 
            case COMPENSATION_ORDER: 
            case QUALITY_REFUNDING_ORDER: 
            case REPLENISH_ORDER: 
            case COMMON_ORDER: 
            case CLAIM_POSTING: 
            case CLAIM_REISSUE: {
                igBatch = this.isIgBatch(wmsOrderBaseDto.getWarehouseCode(), wmsOrderBaseDto.isEnableBatch(), type);
                break;
            }
            case PURCHASE: 
            case OUTSOURCE: 
            case ALLOT_SALE: {
                igBatch = true;
                break;
            }
        }
        if (igBatch) {
            wmsOrderBaseDto.getItemLines().forEach(it -> it.setBatch(null));
        }
        wmsOrderBaseDto.setEnableBatch(!igBatch);
    }

    private void addressProcess(WmsOrderBaseDto wmsOrderBaseDto) {
        if (wmsOrderBaseDto instanceof WmsStockOutOrderReqDto) {
            WmsStockOutOrderReqDto stock = (WmsStockOutOrderReqDto)wmsOrderBaseDto;
            Optional.ofNullable(stock.getReceiverInfo()).ifPresent(re -> {
                if (!Optional.ofNullable(re.getDetailAddress()).orElse("").startsWith(Optional.ofNullable(re.getProvince()).orElse(""))) {
                    re.setDetailAddress(Optional.ofNullable(re.getProvince()).orElse("") + Optional.ofNullable(re.getCity()).orElse("") + Optional.ofNullable(re.getDistrict()).orElse("") + Optional.ofNullable(re.getDetailAddress()).orElse(""));
                }
            });
        }
    }

    private void settingCustomerCode(WmsOrderBaseDto wmsOrderBaseDto) {
        log.info("\u8bbe\u7f6e\u5ba2\u6237\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)wmsOrderBaseDto));
        switch (CsPcpBusinessTypeEnum.getByCode((String)wmsOrderBaseDto.getBusinessType())) {
            case INTERNAL_DEAL: {
                Optional.of((WmsStockOutOrderReqDto)wmsOrderBaseDto).map(WmsStockOutOrderReqDto::getReceiverInfo).ifPresent(r -> r.setCustomerCode(wmsOrderBaseDto.getCustomerCode()));
                break;
            }
            case ALLOT_OUT: 
            case MAIYOU_ALLOT_OUT: 
            case ALLOT_OUT_ONLY: 
            case ALLOT_IN_ONLY: 
            case PURCHASE: 
            case ALLOT_LOGIC_OUT: 
            case INSPECTION_QUALIFIED: 
            case ALLOT_LOSE_EFFICACY: 
            case ALLOT_SALE_BH: 
            case BC_ALLOT: 
            case MAIYOU_BC_ALLOT: 
            case CC_ALLOT: 
            case CB_ALLOT: {
                this.setCustomerCode(wmsOrderBaseDto, false);
                break;
            }
            case PURCHASE_REFUND: 
            case OUTSOURCE: 
            case PRODUCTION: 
            case PRODUCT_REPAIR: {
                this.setCustomerCode(wmsOrderBaseDto, true);
                break;
            }
        }
    }

    private void setCustomerCode(WmsOrderBaseDto w) {
        log.info("\u4ed3\u5e93\u7d22\u8d54\u8865\u53d1\uff0c\u8fc7\u8d26\u8bbe\u7f6e\u5ba2\u6237\uff1a{}", (Object)JSON.toJSONString((Object)w));
        w.setReceiveCustomerCode(w.getCode());
    }

    private void setCustomerCode(WmsOrderBaseDto w, boolean defaultFlag) {
        if (w instanceof WmsStockOutOrderReqDto) {
            Optional.of((WmsStockOutOrderReqDto)w).map(ware -> {
                ware.setReceiverInfo(Optional.ofNullable(ware.getReceiverInfo()).orElseGet(() -> {
                    CsWarehouseAddressRespDto csWarehouseAddressRespDto = this.loadAddress(w.getWarehouseCode());
                    return (WmsStockOutOrderReqDto.ReceiverInfo)BeanUtil.copyProperties((Object)csWarehouseAddressRespDto, WmsStockOutOrderReqDto.ReceiverInfo.class, (String[])new String[0]);
                }));
                return ware;
            }).ifPresent(r -> r.getReceiverInfo().setCustomerCode(defaultFlag ? Optional.ofNullable(w.getCustomerCode()).filter(StringUtils::isNotBlank).orElse(w.getWarehouseCode()) : w.getWarehouseCode()));
        } else {
            Optional.of((WmsStockEntryOrderReqDto)w).ifPresent(r -> r.setCustomerCode(defaultFlag ? Optional.ofNullable(w.getCustomerCode()).filter(StringUtils::isNotBlank).orElseGet(() -> ((WmsOrderBaseDto)w).getWarehouseCode()) : w.getWarehouseCode()));
        }
        w.setReceiveCustomerName(Optional.ofNullable(w.getReceiveCustomerName()).filter(StringUtils::isNotBlank).orElse(w.getWarehouseCode()));
    }

    private void appendingMasterNo(WmsOrderBaseDto wmsOrderBaseDto, String no) {
        switch (CsPcpBusinessTypeEnum.getByCode((String)wmsOrderBaseDto.getBusinessType())) {
            case NUTRITION_INTEGRAL: 
            case INTEGRAL_ORDER: 
            case REPLENISHMENT_ORDER: 
            case ACTIVITY_ORDER: {
                wmsOrderBaseDto.setSaleOrderNo(no);
                break;
            }
        }
    }

    private void transferOutNo(WmsOrderBaseDto wmsOrderBaseDto) {
        switch (CsPcpBusinessTypeEnum.getByCode((String)wmsOrderBaseDto.getBusinessType())) {
            case INTERNAL_DEAL: 
            case INTERNAL_DEAL_RETURN: {
                Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.csTransferOrderQueryApi.queryByTransferOrderNo(wmsOrderBaseDto.getRelevanceNo()))).ifPresent(transfer -> {
                    log.info("\u63a8\u9001wms\u83b7\u53d6\u8c03\u62e8\u5355\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)transfer));
                    wmsOrderBaseDto.setThirdOrderNo(transfer.getExternalPurchaseOrderNo());
                    wmsOrderBaseDto.setRelevanceNo(transfer.getExternalSaleOrderNo());
                });
                break;
            }
            case ALLOT_OUT: 
            case ALLOT_OUT_ONLY: 
            case ALLOT_IN_ONLY: 
            case ALLOT_LOGIC_OUT: 
            case ALLOT_SALE_BH: 
            case BC_ALLOT: 
            case MAIYOU_BC_ALLOT: 
            case CC_ALLOT: 
            case CB_ALLOT: {
                wmsOrderBaseDto.setThirdOrderNo(Optional.ofNullable(wmsOrderBaseDto.getThirdOrderNo()).filter(StringUtils::isNotEmpty).orElse(wmsOrderBaseDto.getRelevanceNo()));
                wmsOrderBaseDto.setRelevanceNo(null);
                break;
            }
            case ALLOT_SALE: {
                ((WmsStockOutOrderReqDto)wmsOrderBaseDto).setRemark(wmsOrderBaseDto.getRelevanceNo() + ";" + ((WmsStockOutOrderReqDto)wmsOrderBaseDto).getReceiverInfo().getWarehouseName() + ";" + Optional.ofNullable(((WmsStockOutOrderReqDto)wmsOrderBaseDto).getRemark()).orElse(""));
                break;
            }
            case OTHER_OUT_STOCK: {
                wmsOrderBaseDto.setBusinessType(CsPcpBusinessTypeEnum.OTHER_OUT.getCode());
                String thirdOrderNo = wmsOrderBaseDto.getThirdOrderNo();
                wmsOrderBaseDto.setThirdOrderNo(wmsOrderBaseDto.getRelevanceNo());
                wmsOrderBaseDto.setRelevanceNo(thirdOrderNo);
                break;
            }
            case OTHER_IN: 
            case OTHER_OUT: 
            case REPLENISH_ORDER: 
            case INSPECTION_QUALIFIED: {
                wmsOrderBaseDto.setThirdOrderNo(wmsOrderBaseDto.getRelevanceNo());
                wmsOrderBaseDto.setRelevanceNo(null);
                this.otherOutHandler(wmsOrderBaseDto);
                break;
            }
            case ALLOT_LOSE_EFFICACY: {
                wmsOrderBaseDto.setThirdOrderNo(wmsOrderBaseDto.getDocumentNo());
                wmsOrderBaseDto.setRelevanceNo(null);
                break;
            }
        }
    }

    private void setLogicalAllot(WmsStockOutOrderReqDto wmsOrderBaseDto) {
        switch (CsPcpBusinessTypeEnum.getByCode((String)wmsOrderBaseDto.getBusinessType())) {
            case INTERNAL_DEAL: 
            case INSPECTION_QUALIFIED: 
            case ALLOT_LOSE_EFFICACY: 
            case INTERNAL_DEAL_RETURN: 
            case SALE_RETURN_INTERNAL_DEAL: {
                wmsOrderBaseDto.setIdLogicalAllot("1");
                break;
            }
            case ALLOT_OUT: 
            case MAIYOU_ALLOT_OUT: 
            case ALLOT_OUT_ONLY: 
            case ALLOT_LOGIC_OUT: {
                wmsOrderBaseDto.setIdLogicalAllot(Optional.ofNullable(wmsOrderBaseDto.getReceiverInfo()).filter(re -> StringUtils.isNotBlank((CharSequence)re.getWarehouseCode())).map(re -> Objects.equals(re.getWarehouseCode(), wmsOrderBaseDto.getWarehouseCode())).orElse(false) != false ? "1" : "0");
                break;
            }
            default: {
                wmsOrderBaseDto.setIdLogicalAllot("0");
            }
        }
    }

    private void ignoreOrderBatch(WmsOrderBaseDto wmsOrderBaseDto) {
        switch (CsPcpBusinessTypeEnum.getByCode((String)wmsOrderBaseDto.getBusinessType())) {
            case ORDER_SALES_OUT: 
            case ORDER_SALES_REFUND: 
            case CUSTOMER_REFUNDING_ORDER: {
                wmsOrderBaseDto.getItemLines().forEach(order -> {
                    order.setBatch(null);
                    order.setProductDate(null);
                    order.setArrivalDate(null);
                });
                break;
            }
        }
    }

    private void settingOrderPrice(WmsOrderBaseDto wmsOrderBaseDto) {
        log.info("\u8bbe\u7f6e\u4ea4\u6613\u76f8\u5173\u91d1\u989dsettingOrderPrice\uff1a{}", (Object)JSON.toJSONString((Object)wmsOrderBaseDto));
        if (StringUtils.isNotBlank((CharSequence)wmsOrderBaseDto.getRelevanceNo())) {
            CsPcpBusinessTypeEnum byCode = CsPcpBusinessTypeEnum.getByCode((String)wmsOrderBaseDto.getBusinessType());
            switch (byCode) {
                case ORDER_SALES_OUT: 
                case PRESALE_ORDER: 
                case AGENCY_ORDER: 
                case NUTRITION_INTEGRAL: 
                case INTEGRAL_ORDER: 
                case REPLENISHMENT_ORDER: 
                case ACTIVITY_ORDER: 
                case CUSTOMER_REFUNDING_ORDER: 
                case COMPENSATION_ORDER: 
                case QUALITY_REFUNDING_ORDER: 
                case COMMON_ORDER: 
                case CLAIM_POSTING: 
                case CLAIM_REISSUE: 
                case SHOPPE_ORDER: 
                case INTERNAL_DISTRIBUTION: 
                case SECONDARY_DISTRIBUTION: 
                case BAIJIAN_DIRECT_SALES: 
                case SPECIAL_CHANNEL_ORDER: {
                    this.tradeTypeDataEdit(wmsOrderBaseDto);
                    break;
                }
                case ALLOT_SALE: {
                    this.syncLogistics(wmsOrderBaseDto);
                    this.settingOrder(wmsOrderBaseDto, wmsOrderBaseDto.getCrmOrderNo());
                    break;
                }
                case ORDER_SALES_REFUND: {
                    this.refundProcess(wmsOrderBaseDto);
                    break;
                }
            }
        }
    }

    private void refundProcess(WmsOrderBaseDto wmsOrderBaseDto) {
        Optional.ofNullable(this.saleRefundQueryApi.queryByRefundNo(wmsOrderBaseDto.getRelevanceNo()).getData()).ifPresent(order -> {
            Optional.ofNullable(order.getPlatformRefundNo()).filter(o -> StringUtils.isBlank((CharSequence)wmsOrderBaseDto.getCrmOrderNo()) && StringUtils.isNotBlank((CharSequence)order.getPlatformRefundNo())).ifPresent(arg_0 -> ((WmsOrderBaseDto)wmsOrderBaseDto).setCrmOrderNo(arg_0));
            wmsOrderBaseDto.setThirdOrderNo(order.getRefundNo());
            Optional.ofNullable(order.getEasCode()).filter(StringUtils::isNotEmpty).ifPresent(arg_0 -> ((WmsOrderBaseDto)wmsOrderBaseDto).setCustomerCode(arg_0));
            Map itemMap = order.getGoodsList().stream().filter(f -> YesOrNoEnum.isYes((Integer)f.getGift()) == false).collect(Collectors.toMap(o -> o.getSkuCode() + Optional.ofNullable(o.getBatchNo()).map(b -> ":" + b).orElse(""), Function.identity(), (o, o1) -> o));
            wmsOrderBaseDto.setEnableBatch(StringUtils.isNotBlank((CharSequence)((WmsItemLine)wmsOrderBaseDto.getItemLines().get(0)).getBatch()));
            wmsOrderBaseDto.getItemLines().forEach(line -> Optional.ofNullable(Optional.ofNullable(itemMap.get(line.getCargoCode() + ":" + line.getBatch())).orElseGet(() -> (SaleRefundItemRespDto)itemMap.get(line.getCargoCode()))).ifPresent(tradeItem -> {
                line.setAmount(Optional.ofNullable(tradeItem.getPrice()).orElse(BigDecimal.ZERO).multiply(tradeItem.getItemNum()));
                line.setSkuPrice(tradeItem.getPrice());
            }));
        });
    }

    private boolean isIgBatch(String stock, boolean enableBatch, CsPcpBusinessTypeEnum businessTypeEnum) {
        if (businessTypeEnum == CsPcpBusinessTypeEnum.INTERNAL_DEAL) {
            return !enableBatch && this.zhWhs.contains(stock);
        }
        if (businessTypeEnum.equals((Object)CsPcpBusinessTypeEnum.AFTER_SALE)) {
            return this.zhWhs.contains(stock);
        }
        return !enableBatch;
    }

    private void tradeTypeDataEdit(WmsOrderBaseDto wmsOrderBaseDto) {
        log.info("tradeTypeDataEdit\uff1a{}", (Object)JSON.toJSONString((Object)wmsOrderBaseDto));
        this.syncLogistics(wmsOrderBaseDto);
        this.settingOrder(wmsOrderBaseDto, wmsOrderBaseDto.getRelevanceNo());
    }

    private void settingOrder(WmsOrderBaseDto wmsOrderBaseDto, String orderNo) {
        log.info("settingOrder\uff1a{}", (Object)JSON.toJSONString((Object)wmsOrderBaseDto));
        if (StringUtils.isBlank((CharSequence)orderNo)) {
            return;
        }
        Optional.ofNullable(this.saleOrderQueryApi.queryByOrderNo(orderNo).getData()).ifPresent(order -> {
            log.info("\u63a8\u9001wms\u62c9\u53d6\u5230\u8ba2\u5355\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)order));
            wmsOrderBaseDto.setThirdOrigOrderNo(order.getEasOrderNo());
            this.kmhHandler(wmsOrderBaseDto, (BizSaleOrderRespDto)order);
            wmsOrderBaseDto.setSapCkdm(order.getOrganizationCode());
            this.buildSettlementOrg(wmsOrderBaseDto);
            this.appendingMasterNo(wmsOrderBaseDto, order.getPlatformParentOrderNo());
            this.tradeRemark(wmsOrderBaseDto, (BizSaleOrderRespDto)order);
            wmsOrderBaseDto.setThirdOrderNo(this.getThirdOrderNo((BizSaleOrderRespDto)order));
            Optional.ofNullable(order.getEasCode()).filter(StringUtils::isNotEmpty).ifPresent(w -> {
                if (wmsOrderBaseDto instanceof WmsStockOutOrderReqDto) {
                    Optional.ofNullable(((WmsStockOutOrderReqDto)wmsOrderBaseDto).getReceiverInfo()).ifPresent(r -> r.setCustomerCode(w));
                }
            });
            Optional.ofNullable(order.getPlatformOrderNo()).filter(StringUtils::isNotBlank).ifPresent(arg_0 -> ((WmsOrderBaseDto)wmsOrderBaseDto).setCrmOrderNo(arg_0));
            wmsOrderBaseDto.setReceiveCustomerName(Optional.ofNullable(wmsOrderBaseDto.getReceiveCustomerName()).filter(StringUtils::isNotBlank).orElseGet(() -> Optional.ofNullable(order.getCustomerName()).filter(StringUtils::isNotBlank).orElse("QTKH")));
            switch (CsPcpBusinessTypeEnum.getByCode((String)wmsOrderBaseDto.getBusinessType())) {
                case CLAIM_POSTING: 
                case CLAIM_REISSUE: {
                    wmsOrderBaseDto.setClaimCustomerCode(order.getEasCode());
                    wmsOrderBaseDto.setReceiveCustomerCode(order.getEasCode());
                    wmsOrderBaseDto.setCustomerCode(order.getActualCustomerCode());
                    if (wmsOrderBaseDto instanceof WmsStockOutOrderReqDto) {
                        Optional.of((WmsStockOutOrderReqDto)wmsOrderBaseDto).map(WmsStockOutOrderReqDto::getReceiverInfo).ifPresent(r -> r.setCustomerCode(order.getActualCustomerCode()));
                    }
                    log.info("\u4ed3\u5e93\u7d22\u8d54\u8865\u53d1\uff0c\u8fc7\u8d26\u5ba2\u6237\u8bbe\u7f6e\uff1a{}", (Object)JSON.toJSONString((Object)wmsOrderBaseDto));
                    break;
                }
                case ALLOT_SALE: {
                    Optional.of((WmsStockOutOrderReqDto)wmsOrderBaseDto).map(WmsStockOutOrderReqDto::getReceiverInfo).ifPresent(r -> Optional.ofNullable(order.getOrderAddrRespDto()).ifPresent(address -> {
                        r.setDetailAddress(address.getReceiveAddress());
                        r.setPhone(address.getReceivePhone());
                        r.setCity(address.getCity());
                        r.setDistrict("");
                        r.setAreaCode("");
                        r.setProvince(address.getProvince());
                        r.setKey(address.getReceiveName());
                        r.setContacts(address.getReceiveName());
                    }));
                    break;
                }
            }
            wmsOrderBaseDto.setEnableBatch(order.getItemList().stream().anyMatch(o -> StringUtils.isNotBlank((CharSequence)o.getDeliveryItemBatchNo())));
            Map itemMap = order.getItemList().stream().filter(f -> YesOrNoEnum.isYes((Integer)f.getGift()) == false).collect(Collectors.toMap(o -> o.getSkuCode() + Optional.ofNullable(o.getBatchNo()).map(b -> ":" + b).orElse(""), Function.identity(), (o, o1) -> o));
            wmsOrderBaseDto.getItemLines().forEach(line -> Optional.ofNullable(Optional.ofNullable(itemMap.get(line.getCargoCode() + ":" + line.getBatch())).orElseGet(() -> (SaleOrderItemExtRespDto)itemMap.get(line.getCargoCode()))).ifPresent(tradeItem -> {
                line.setAmount(tradeItem.getLineAmount());
                line.setSkuPrice(tradeItem.getSalePrice());
                line.setIntegral(YesOrNoEnum.isYes((Integer)tradeItem.getIntegral()));
            }));
        });
    }

    private void tradeRemark(WmsOrderBaseDto wmsOrderBaseDto, BizSaleOrderRespDto order) {
        if (wmsOrderBaseDto instanceof WmsStockOutOrderReqDto) {
            ((WmsStockOutOrderReqDto)wmsOrderBaseDto).setRemark(order.getSellerRemark());
            if (CsPcpBusinessTypeEnum.CUSTOMER_REFUNDING_ORDER.getCode().equals(wmsOrderBaseDto.getBusinessType())) {
                ((WmsStockOutOrderReqDto)wmsOrderBaseDto).setRemark(order.getPlatformOrderNo() + order.getCustomerName() + "\u8d39\u7528\uff1a\u73b0\u91d1-\u9000\u6362\u8d27" + Optional.ofNullable(order.getSellerRemark()).orElse(""));
            }
        }
    }

    private void otherOutHandler(WmsOrderBaseDto wmsOrderBaseDto) {
        log.info("\u5176\u4ed6\u51fa\u5e93\u5355\u4f20\u5408\u5355\u53f7\u81f3WMS\uff1a{}", (Object)JSON.toJSONString((Object)wmsOrderBaseDto));
        try {
            if (wmsOrderBaseDto.getBusinessType().equals(CsPcpBusinessTypeEnum.OTHER_OUT.getCode())) {
                CsOtherStorageOrderRespDto otherStorageOrder = (CsOtherStorageOrderRespDto)RestResponseHelper.extractData((RestResponse)this.csOtherStorageOrderQueryApi.queryByOtherStorageNo(wmsOrderBaseDto.getThirdOrderNo()));
                if (ObjectUtil.isNotEmpty((Object)otherStorageOrder)) {
                    wmsOrderBaseDto.setKmhMasterOrderCode(otherStorageOrder.getMergeOrderNo());
                }
                this.buildSettlementOrg(wmsOrderBaseDto);
            }
        }
        catch (Exception e) {
            log.error("\u5176\u4ed6\u51fa\u5e93\u5355\u4f20\u5408\u5355\u53f7\u81f3WMS\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void kmhHandler(WmsOrderBaseDto wmsOrderBaseDto, BizSaleOrderRespDto order) {
        if (wmsOrderBaseDto instanceof WmsStockOutOrderReqDto) {
            List tagCodeList = order.getTagList().stream().map(OrderTagBaseRespDto::getTagCode).collect(Collectors.toList());
            ((WmsStockOutOrderReqDto)wmsOrderBaseDto).setOrderTagList(tagCodeList);
            if (!tagCodeList.contains("GS001")) {
                log.info("\u9500\u552e\u8ba2\u5355\u672a\u6253\u5f00\u95e8\u7ea2\u6807\u7b7e,\u4e0d\u9700\u63a8\u9001\u5408\u5355\u6307\u4ee4");
                return;
            }
        }
        String s = order.getPlatformOrderNo();
        Integer type = SaleOrderLevelEnum.ORIGINAL.getType();
        if (Objects.equals(type, order.getOrderLevel()) || Objects.equals(SaleOrderLevelEnum.MAIN.getType(), order.getOrderLevel())) {
            log.info("\u539f\u5355\u6216\u8005\u4e3b\u5355\uff0c\u4e0d\u9700\u8981\u63a8\u9001\u5408\u5355\u6307\u4ee4");
            return;
        }
        CountRelateNoticeOrderReqDto countRelateNoticeOrderReqDto = new CountRelateNoticeOrderReqDto();
        countRelateNoticeOrderReqDto.setMasterOrderNo(s);
        countRelateNoticeOrderReqDto.setType(Integer.valueOf(3));
        CountRelateNoticeOrderRespDto countRelateNoticeOrderRespDto = (CountRelateNoticeOrderRespDto)RestResponseHelper.extractData((RestResponse)this.outNoticeOrderQueryApi.countRelateNoticeOrder(countRelateNoticeOrderReqDto));
        log.info("\u8981\u5408\u5355\u7684\u4fe1\u606f:{},\u6e20\u9053\u5355\u53f7\u4e3a:{}", (Object)JSONObject.toJSONString((Object)countRelateNoticeOrderRespDto), (Object)s);
        Optional.ofNullable(countRelateNoticeOrderRespDto).ifPresent(r -> {
            if (!r.isAllSplit() || countRelateNoticeOrderReqDto.getType() != 3) {
                wmsOrderBaseDto.setKmhMasterOrderCode(s);
                wmsOrderBaseDto.setOrderSplitNum(Integer.valueOf(0));
            } else if (countRelateNoticeOrderReqDto.getType() == 3 && r.isAllSplit() && r.getDetailMap().getOrDefault(wmsOrderBaseDto.getWarehouseCode(), 0L) >= 1L) {
                wmsOrderBaseDto.setKmhMasterOrderCode(s);
                wmsOrderBaseDto.setOrderSplitNum(Integer.valueOf(0));
            }
        });
        if (!Objects.isNull(countRelateNoticeOrderRespDto) && countRelateNoticeOrderRespDto.isAllSplit()) {
            Mutex mutex = this.lockService.lock(MERGE_LOCK, order.getPlatformOrderNo(), 10);
            try {
                this.saleAllotMqHelper.sendOrderMergeMq(wmsOrderBaseDto, order);
            }
            catch (Exception e) {
                log.info("\u53d1\u9001\u5408\u5355\u6307\u4ee4\u51fa\u9519", (Throwable)e);
            }
            finally {
                this.lockService.unlock(mutex);
            }
        }
    }

    private String getThirdOrderNo(BizSaleOrderRespDto order) {
        return Optional.ofNullable(order.getSplitPlatformNo()).filter(r -> StringUtils.isNotBlank((CharSequence)r) && StringUtils.isNotBlank((CharSequence)order.getEasOrderNo())).orElseGet(() -> Optional.ofNullable(order.getEasOrderNo()).filter(StringUtils::isNotBlank).orElseGet(() -> ((BizSaleOrderRespDto)order).getSaleOrderNo()));
    }

    private void orderLineMarge(WmsOrderBaseDto wmsOrderBaseDto) {
        if (wmsOrderBaseDto instanceof WmsStockOutOrderReqDto) {
            wmsOrderBaseDto.setItemLines(new ArrayList(wmsOrderBaseDto.getItemLines().stream().collect(Collectors.toMap(WmsItemLine::getCargoCode, Function.identity(), (o, o1) -> {
                o.setPlanQuantity(o.getPlanQuantity().add(o1.getPlanQuantity()));
                return o;
            })).values()));
        }
    }

    private void orderLineBatchMarge(WmsOrderBaseDto wmsOrderBaseDto) {
        if (wmsOrderBaseDto instanceof WmsStockOutOrderReqDto) {
            HashMap itemMap = Maps.newHashMap();
            for (WmsItemLine itemLine : wmsOrderBaseDto.getItemLines()) {
                String key = itemLine.getCargoCode() + "_" + itemLine.getBatch();
                WmsItemLine item = itemMap.getOrDefault(key, null);
                if (null == item) {
                    item = itemLine;
                } else {
                    item.setPlanQuantity(BigDecimalUtils.add((BigDecimal)item.getPlanQuantity(), (BigDecimal)itemLine.getPlanQuantity()));
                }
                itemMap.put(key, item);
            }
            wmsOrderBaseDto.setItemLines((List)Lists.newArrayList(itemMap.values()));
        }
    }

    private void syncLogistics(WmsOrderBaseDto wmsOrderBaseDto) {
        try {
            CsLogisticsInfoReqDto dataInfo = new CsLogisticsInfoReqDto();
            dataInfo.setType(Integer.valueOf(1));
            dataInfo.setCspNo(wmsOrderBaseDto.getThirdOrderNo());
            dataInfo.setStatus("1");
            dataInfo.setShipTime(new Date());
            dataInfo.setDeliveStartTime(new Date());
            this.csLogisticsInfoApi.addCsLogisticsInfo(dataInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void businessTypeTransfer(WmsOrderBaseDto wmsOrderBaseDto) {
        switch (CsPcpBusinessTypeEnum.getByCode((String)wmsOrderBaseDto.getBusinessType())) {
            case ALLOT_OUT: 
            case MAIYOU_ALLOT_OUT: 
            case ALLOT_BC_EFFICACY: 
            case ALLOT_LOSE_EFFICACY: {
                wmsOrderBaseDto.setBusinessType(Objects.equals(wmsOrderBaseDto.getOrderType(), "in") ? CsPcpBusinessTypeEnum.ALLOT_IN_ONLY.getCode() : (this.isAcross((WmsStockOutOrderReqDto)wmsOrderBaseDto) ? wmsOrderBaseDto.getBusinessType() : CsPcpBusinessTypeEnum.ALLOT_OUT_ONLY.getCode()));
                break;
            }
            case ALLOT_OUT_ONLY: 
            case ALLOT_IN_ONLY: 
            case ORDER_SALES_OUT: 
            case PRESALE_ORDER: 
            case ORDER_SALES_REFUND: 
            case PURCHASE_REFUND: 
            case OUTSOURCE_REFUND: 
            case OTHER_IN: 
            case OTHER_OUT: 
            case INTERNAL_DEAL: 
            case AGENCY_ORDER: 
            case INTEGRAL_ORDER: 
            case REPLENISHMENT_ORDER: 
            case ACTIVITY_ORDER: 
            case CUSTOMER_REFUNDING_ORDER: 
            case COMPENSATION_ORDER: 
            case QUALITY_REFUNDING_ORDER: 
            case REPLENISH_ORDER: 
            case COMMON_ORDER: 
            case PURCHASE: 
            case OUTSOURCE: 
            case ALLOT_SALE: 
            case ALLOT_LOGIC_OUT: 
            case INSPECTION_QUALIFIED: 
            case ALLOT_SALE_BH: 
            case BC_ALLOT: 
            case MAIYOU_BC_ALLOT: 
            case CC_ALLOT: 
            case CB_ALLOT: 
            case PRODUCTION: 
            case PRODUCT_REPAIR: 
            case INTERNAL_DEAL_RETURN: 
            case OTHER_OUT_STOCK: 
            case SHOPPE_ORDER: 
            case SPECIAL_CHANNEL_ORDER: 
            case ALLOT_ONLY_RECORD: 
            case BATCH_ADJUST: 
            case INVENTORY_ADJUST: 
            case CHECK_STOCK: 
            case LOCK_ORDER: 
            case SHARE_GOODS_ORDER: 
            case DICT_ALLOT_WAREHOUSE: 
            case DICT_ALLOT_CONSIGNMENT_SALE: 
            case DICT_ALLOT_STORE_ENQUIRY: 
            case DICT_ALLOT_WAREHOUSE_DELIVERY: 
            case DICT_ALLOT_STORE_ENQUIRY_REFUND: 
            case DICT_ALLOT_STORE_RAISED: 
            case DICT_ALLOT_STAFF_BORROW: 
            case DICT_ALLOT_STAFF_RETURN: 
            case DICT_ALLOT_PRODUCTION_BORROW: 
            case DICT_ALLOT_PRODUCTION_RETURN: 
            case AFTER_SALE: 
            case IN_TRANSIT_TRANSFER: 
            case IN_TRANSIT_ADJUSTMENT: {
                break;
            }
            case NUTRITION_INTEGRAL: {
                wmsOrderBaseDto.setBusinessType(CsPcpBusinessTypeEnum.INTEGRAL_ORDER.getCode());
                break;
            }
            case SALE_RETURN_INTERNAL_DEAL: 
            case SALE_RETURN_INTERNAL_DEAL_BA: 
            case INTERNAL_DEAL_RETURN_BA: {
                wmsOrderBaseDto.setBusinessType(CsPcpBusinessTypeEnum.INTERNAL_DEAL_RETURN.getCode());
                break;
            }
            case INTERNAL_DEAL_BA: {
                wmsOrderBaseDto.setBusinessType(CsPcpBusinessTypeEnum.INTERNAL_DEAL.getCode());
                break;
            }
            default: {
                wmsOrderBaseDto.setBusinessType(CsPcpBusinessTypeEnum.ORDER_SALES_OUT.getCode());
            }
        }
    }

    private boolean isAcross(WmsStockOutOrderReqDto wmsOrderBaseDto) {
        return Optional.ofNullable(wmsOrderBaseDto.getReceiverInfo()).filter(re -> StringUtils.isNotBlank((CharSequence)re.getWarehouseCode())).map(re -> Objects.equals(re.getWarehouseCode(), wmsOrderBaseDto.getWarehouseCode())).orElse(false) == false;
    }

    private WmsStockEntryOrderReqDto transferWmsStockEntryOrderReqDto(MessageVo message) {
        WmsStockEntryOrderReqDto wmsStockEntryOrderReqDto = (WmsStockEntryOrderReqDto)JSONObject.parseObject((String)((String)message.getData()), WmsStockEntryOrderReqDto.class);
        this.editData((WmsOrderBaseDto)wmsStockEntryOrderReqDto);
        return wmsStockEntryOrderReqDto;
    }

    private WmsStockOutOrderReqDto transferWmsStockOutOrderReqDto(MessageVo message) {
        WmsStockOutOrderReqDto wmsStockOutOrderReqDto = (WmsStockOutOrderReqDto)JSONObject.parseObject((String)((String)message.getData()), WmsStockOutOrderReqDto.class);
        String businessType = wmsStockOutOrderReqDto.getBusinessType();
        Boolean compensationFlag = false;
        switch (CsPcpBusinessTypeEnum.getByCode((String)businessType)) {
            case CLAIM_POSTING: 
            case CLAIM_REISSUE: {
                compensationFlag = true;
                break;
            }
        }
        this.editData((WmsOrderBaseDto)wmsStockOutOrderReqDto);
        this.setLogicalAllot(wmsStockOutOrderReqDto);
        this.setOrderSrc(wmsStockOutOrderReqDto);
        if (!compensationFlag.booleanValue()) {
            Optional.ofNullable(wmsStockOutOrderReqDto.getReceiverInfo()).ifPresent(r -> r.setCustomerCode(Optional.ofNullable(r.getCustomerCode()).filter(StringUtils::isNotEmpty).orElse("QTKH")));
            if (null != wmsStockOutOrderReqDto.getReceiverInfo() && StringUtils.equals((CharSequence)wmsStockOutOrderReqDto.getReceiverInfo().getCustomerCode(), (CharSequence)"QTKH") && StringUtils.isBlank((CharSequence)wmsStockOutOrderReqDto.getReceiveCustomerCode())) {
                wmsStockOutOrderReqDto.setReceiveCustomerCode("QTKH");
            }
            if (StringUtils.equals((CharSequence)wmsStockOutOrderReqDto.getReceiveCustomerCode(), (CharSequence)"QTKH")) {
                wmsStockOutOrderReqDto.setReceiveCustomerName("\u5176\u4ed6\u5ba2\u6237");
            }
        } else {
            Optional.ofNullable(wmsStockOutOrderReqDto.getReceiverInfo()).ifPresent(r -> r.setCustomerCode(wmsStockOutOrderReqDto.getClaimCustomerCode()));
        }
        log.info("transferWmsStockOutOrderReqDto: {}", (Object)LogUtils.buildLogContent((Object)wmsStockOutOrderReqDto));
        return wmsStockOutOrderReqDto;
    }

    private void setOrderSrc(WmsStockOutOrderReqDto wmsStockOutOrderReqDto) {
        switch (CsPcpBusinessTypeEnum.getByCode((String)wmsStockOutOrderReqDto.getBusinessType())) {
            case ALLOT_OUT: 
            case MAIYOU_ALLOT_OUT: 
            case ALLOT_OUT_ONLY: 
            case ALLOT_IN_ONLY: 
            case ALLOT_BC_EFFICACY: 
            case INTERNAL_DEAL: 
            case ALLOT_SALE: 
            case ALLOT_LOGIC_OUT: 
            case INSPECTION_QUALIFIED: 
            case ALLOT_LOSE_EFFICACY: 
            case ALLOT_SALE_BH: 
            case BC_ALLOT: 
            case MAIYOU_BC_ALLOT: 
            case CC_ALLOT: 
            case CB_ALLOT: 
            case ALLOT_ONLY_RECORD: 
            case DICT_ALLOT_WAREHOUSE: 
            case DICT_ALLOT_CONSIGNMENT_SALE: 
            case IN_TRANSIT_TRANSFER: {
                wmsStockOutOrderReqDto.setOrderSrc("DB");
                break;
            }
        }
    }

    private void loadCustomerData(WmsOrderBaseDto wmsOrderBaseDto) {
        try {
            String businessType = wmsOrderBaseDto.getBusinessType();
            switch (CsPcpBusinessTypeEnum.getByCode((String)businessType)) {
                case ORDER_SALES_OUT: 
                case PRESALE_ORDER: 
                case ORDER_SALES_REFUND: 
                case AGENCY_ORDER: 
                case NUTRITION_INTEGRAL: 
                case INTEGRAL_ORDER: 
                case REPLENISHMENT_ORDER: 
                case ACTIVITY_ORDER: 
                case CUSTOMER_REFUNDING_ORDER: 
                case COMPENSATION_ORDER: 
                case QUALITY_REFUNDING_ORDER: 
                case OTHER_OUT_STOCK: 
                case SHOPPE_ORDER: 
                case INTERNAL_DISTRIBUTION: 
                case SECONDARY_DISTRIBUTION: {
                    this.doSettingCustomer(wmsOrderBaseDto);
                    break;
                }
                case ALLOT_SALE: {
                    if (wmsOrderBaseDto instanceof WmsStockOutOrderReqDto) {
                        Optional.ofNullable(this.saleOrderReportQueryApi.getTransferSaleOrder(wmsOrderBaseDto.getRelevanceNo()).getData()).ifPresent(order -> {
                            wmsOrderBaseDto.setCrmOrderNo(order.getSaleOrderNo());
                            wmsOrderBaseDto.setDbCrmOrderNo(order.getPlatformOrderNo());
                            Optional.ofNullable(RestUtil.checkResponse(this.customerQueryApi.queryByCode(order.getCustomerCode()))).ifPresent(customer -> {
                                log.info("\u63a8\u9001wms\u62c9\u53d6\u7684\u5ba2\u6237\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)customer));
                                wmsOrderBaseDto.setFinancialPrint(customer.getFinancialPrint());
                                wmsOrderBaseDto.setReportsPrint(customer.getReportsPrint());
                                wmsOrderBaseDto.setInformationRemarks(customer.getInformationRemarks());
                                wmsOrderBaseDto.setExtraMaterial(customer.getExtraMaterial());
                                ((WmsStockOutOrderReqDto)wmsOrderBaseDto).getReceiverInfo().setCustomerCode(customer.getEasCode());
                                wmsOrderBaseDto.setReceiveCustomerName(customer.getName());
                            });
                        });
                    }
                    break;
                }
                case OTHER_IN: {
                    wmsOrderBaseDto.setCustomerCode("QTKH");
                    wmsOrderBaseDto.setReceiveCustomerName("\u5176\u4ed6\u5ba2\u6237");
                    break;
                }
                case OTHER_OUT: {
                    WmsStockOutOrderReqDto wmsStockOutOrder = (WmsStockOutOrderReqDto)wmsOrderBaseDto;
                    Optional.ofNullable(wmsStockOutOrder.getReceiverInfo()).ifPresent(re -> re.setCustomerCode(Optional.ofNullable(re.getCustomerCode()).filter(StringUtils::isNotBlank).orElse("QTKH")));
                    wmsOrderBaseDto.setReceiveCustomerName("\u5176\u4ed6\u5ba2\u6237");
                    break;
                }
                default: {
                    this.doSettingCustomer(wmsOrderBaseDto);
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u63a8\u9001wms\u9500\u552e\u5355\u8bfb\u53d6\u5ba2\u6237\u5f02\u5e38:{}", (Object)e.getMessage());
        }
    }

    private void doSettingCustomer(WmsOrderBaseDto wmsOrderBaseDto) {
        log.info("doSettingCustomer\uff1a{}", (Object)JSON.toJSONString((Object)wmsOrderBaseDto));
        if (wmsOrderBaseDto instanceof WmsStockOutOrderReqDto) {
            WmsStockOutOrderReqDto wmsStockOutOrderReqDto = (WmsStockOutOrderReqDto)wmsOrderBaseDto;
            Optional.ofNullable(wmsStockOutOrderReqDto.getReceiverInfo()).map(WmsStockOutOrderReqDto.ReceiverInfo::getCustomerCode).filter(StringUtils::isNotEmpty).flatMap(customerCode -> Optional.ofNullable(RestUtil.checkResponse(this.customerQueryApi.queryByCode(customerCode)))).ifPresent(customer -> {
                log.info("\u63a8\u9001wms\u62c9\u53d6\u7684\u5ba2\u6237\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)customer));
                wmsStockOutOrderReqDto.setFinancialPrint(customer.getFinancialPrint());
                wmsStockOutOrderReqDto.setReportsPrint(customer.getReportsPrint());
                wmsStockOutOrderReqDto.setExtraMaterial(customer.getExtraMaterial());
                wmsStockOutOrderReqDto.setInformationRemarks(customer.getInformationRemarks());
                wmsStockOutOrderReqDto.getReceiverInfo().setCustomerCode(customer.getEasCode());
                wmsStockOutOrderReqDto.setReceiveCustomerName(customer.getName());
                switch (CsPcpBusinessTypeEnum.getByCode((String)wmsOrderBaseDto.getBusinessType())) {
                    case CLAIM_POSTING: 
                    case CLAIM_REISSUE: {
                        wmsStockOutOrderReqDto.setReceiveCustomerCode(customer.getCode());
                    }
                }
            });
        }
    }

    private CsWarehouseAddressRespDto loadAddress(String warehouseCode) {
        CsWarehouseAddressParamQueryDto req = new CsWarehouseAddressParamQueryDto();
        req.setPageNum(Integer.valueOf(1));
        req.setPageSize(Integer.valueOf(1));
        req.setWarehouseCode(warehouseCode);
        PageInfo dtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csWarehouseAddressQueryApi.queryPageInfo(req));
        return Optional.ofNullable(dtoPageInfo.getList()).filter(CollectionUtils::isNotEmpty).map(list -> (CsWarehouseAddressRespDto)list.get(0)).orElse(new CsWarehouseAddressRespDto());
    }

    private void saleOrderEASVerify(WmsOrderBaseDto wmsOrderBaseDto) {
        try {
            BizSaleOrderRespDto saleOrder;
            log.info("\u9500\u552e\u51fa\u83b7\u53d6EAS\u5ba1\u6838\u65f6\u95f4\uff1a{}", (Object)JSON.toJSONString((Object)wmsOrderBaseDto));
            if (ObjectUtil.isNotEmpty((Object)wmsOrderBaseDto) && StringUtils.isNotBlank((CharSequence)wmsOrderBaseDto.getRelevanceNo()) && ObjectUtil.isNotEmpty((Object)(saleOrder = (BizSaleOrderRespDto)RestResponseHelper.extractData((RestResponse)this.saleOrderQueryApi.queryByOrderNo(wmsOrderBaseDto.getRelevanceNo())))) && ObjectUtil.isNotEmpty((Object)saleOrder.getEasVerifyTime())) {
                log.info("\u9500\u552e\u5355\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)saleOrder));
                wmsOrderBaseDto.setFinanceAuditTime(DateUtil.format((Date)saleOrder.getEasVerifyTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
        }
        catch (Exception e) {
            log.info("\u9500\u552e\u51fa\u83b7\u53d6EAS\u5ba1\u6838\u65f6\u95f4\u5f02\u5e38");
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void buildSettlementOrg(WmsOrderBaseDto wmsOrderBaseDto) {
        CsLogicWarehouseRespDto warehouseRespDto;
        log.info("\u5b58\u653e\u8ba1\u8d39\u7ec4\u7ec7\uff1a{}", (Object)JSON.toJSONString((Object)wmsOrderBaseDto));
        if (StringUtils.isNotBlank((CharSequence)wmsOrderBaseDto.getLogicWarehouseCode()) && ObjectUtil.isNotEmpty((Object)(warehouseRespDto = (CsLogicWarehouseRespDto)RestResponseHelper.extractData((RestResponse)this.csLogicWarehouseExposedQueryApi.queryWarehouseTypeByCode(wmsOrderBaseDto.getLogicWarehouseCode()))))) {
            wmsOrderBaseDto.setSapCkdm(StringUtils.isNotBlank((CharSequence)warehouseRespDto.getCostOrg()) ? warehouseRespDto.getCostOrg() : warehouseRespDto.getCargoEscheatageId());
            if (StringUtils.isBlank((CharSequence)wmsOrderBaseDto.getSettlementOrgName())) {
                wmsOrderBaseDto.setSettlementOrgName(warehouseRespDto.getCargoEscheatageName());
            }
        }
        log.info("\u5b58\u653e\u8ba1\u8d39\u7ec4\u7ec7\u503c\uff1a{}\uff0c{}", (Object)wmsOrderBaseDto.getSapCkdm(), (Object)wmsOrderBaseDto.getSettlementOrgName());
    }
}

