/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.search.biz.apiimpl.query.impl.delivery;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.search.api.dto.request.EsOutResultOrderListPageParams;
import com.dtyunxi.cis.search.api.dto.response.EsOutResultOrderVO;
import com.dtyunxi.cis.search.api.query.delivery.EsOutResultOrderQueryApi;
import com.dtyunxi.cis.search.api.util.RptUtil;
import com.dtyunxi.cis.search.biz.base.BaseEsService;
import com.dtyunxi.cis.search.biz.util.OutResultOrderRowMapper;
import com.dtyunxi.huieryun.opensearch.api.RowMapper;
import com.dtyunxi.huieryun.opensearch.enums.LogicalSymbol;
import com.dtyunxi.huieryun.opensearch.enums.SortOrder;
import com.dtyunxi.huieryun.opensearch.vo.FilterFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ESOutResultOrderQueryServiceImpl
extends BaseEsService
implements EsOutResultOrderQueryApi {
    String indexName = "cs_out_result_order";
    private static final Logger logger = LoggerFactory.getLogger(ESOutResultOrderQueryServiceImpl.class);
    private static final String[] ORDER_NOS = new String[]{"documentNo", "relevanceNo", "externalOrderNo", "wmsOrderNo", "noticeNo"};
    private static final String[] IN_WAREHOUSES = new String[]{"inLogicWarehouseCode", "inLogicWarehouseName"};
    private static final String[] OUT_WAREHOUSES = new String[]{"outLogicWarehouseCode", "outLogicWarehouseName"};

    @PostConstruct
    private void init() {
        this.indexName = this.searchConfigVo.getIndexNamePreFix() + "-" + this.indexName;
    }

    private OSSearchVo initSearchVo(EsOutResultOrderListPageParams reqDto) {
        OSSearchVo queryVo = new OSSearchVo();
        queryVo.setPage(reqDto.getPageNum().intValue());
        queryVo.setPageSize(reqDto.getPageSize().intValue());
        queryVo.addEqualFilter("dr", "0");
        if (StringUtils.isNotBlank((CharSequence)reqDto.getDocumentNo())) {
            String[] orderNos = RptUtil.regExSplit((String)reqDto.getDocumentNo());
            FilterFieldVo filter = queryVo.createCompoundFilter(LogicalSymbol.AND);
            for (String orderNo : orderNos) {
                this.addWildcardFilter(filter, ORDER_NOS, this.wildcard(orderNo));
            }
            queryVo.addFilters(new FilterFieldVo[]{filter});
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getBusinessType())) {
            queryVo.addWildcardFilter("businessType", "*" + reqDto.getBusinessType() + "*");
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getDocumentStatus())) {
            queryVo.addWildcardFilter("orderStatus", "*" + reqDto.getDocumentStatus() + "*");
        }
        if (CollectionUtil.isNotEmpty((Collection)reqDto.getBusinessTypeList())) {
            queryVo.addInFilter("businessType", reqDto.getBusinessTypeList().toArray(new String[0]));
        }
        if (CollectionUtil.isNotEmpty((Collection)reqDto.getNotBusinessTypeList())) {
            queryVo.addNonInFilter("businessType", reqDto.getNotBusinessTypeList().toArray(new String[0]));
        }
        String startTime = reqDto.getStartTime();
        String endTime = reqDto.getEndTime();
        if (StringUtils.isNotBlank((CharSequence)endTime) && StringUtils.isNotBlank((CharSequence)startTime)) {
            queryVo.addRangeFilter("createTime", this.beginTimeLong(startTime), this.endTimeLong(endTime));
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getOutLogicWarehouseName())) {
            queryVo.addWildcardFilter(OUT_WAREHOUSES, this.wildcard(reqDto.getOutLogicWarehouseName()), LogicalSymbol.OR);
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getInLogicWarehouseName())) {
            queryVo.addWildcardFilter(IN_WAREHOUSES, this.wildcard(reqDto.getInLogicWarehouseName()), LogicalSymbol.OR);
        }
        queryVo.addEqualFilter("orderType", "out");
        queryVo.addSort("createTime", SortOrder.DESC);
        logger.info("\u51fa\u5e93\u7ed3\u679c\u5355ES[\u67e5\u8be2\u62fc\u63a5\u53c2\u6570]:{}", (Object)JSON.toJSONString((Object)queryVo.getFilterFields()));
        return queryVo;
    }

    public RestResponse<PageInfo<EsOutResultOrderVO>> queryOutResultOrderPage(EsOutResultOrderListPageParams dto) {
        OSSearchVo queryVo = this.initSearchVo(dto);
        queryVo.setPage(dto.getPageNum().intValue());
        queryVo.setPageSize(dto.getPageSize().intValue());
        SearchResultVo searchResultVo = this.searchData(this.indexName, queryVo);
        if (null == searchResultVo || searchResultVo.getTotalSize() == 0L) {
            return new RestResponse((Object)new PageInfo());
        }
        PageInfo pageInfo = new PageInfo();
        pageInfo.setTotal(searchResultVo.getTotalSize());
        pageInfo.setPageSize(searchResultVo.getPageSize());
        pageInfo.setPageNum(searchResultVo.getCurrentPage());
        pageInfo.setPages(searchResultVo.getTotalPageNum().intValue());
        List dtoList = searchResultVo.getDocValues((RowMapper)new OutResultOrderRowMapper());
        List maps = searchResultVo.getDocValues();
        if (CollectionUtil.isEmpty((Collection)maps)) {
            return new RestResponse((Object)pageInfo);
        }
        int index = 0;
        for (EsOutResultOrderVO o : dtoList) {
            Map map;
            if (ObjectUtils.isNotEmpty((map = (Map)maps.get(index++)).get("totalCartons"))) {
                o.setTotalBoxesNum(BigDecimalUtils.parse((String)String.valueOf(map.get("totalCartons"))));
            } else {
                o.setTotalBoxesNum(new BigDecimal("0"));
            }
            if (ObjectUtils.isNotEmpty(map.get("mergeQuantity"))) {
                o.setMixBoxesNum(BigDecimalUtils.parse((String)String.valueOf(map.get("mergeQuantity"))));
                continue;
            }
            o.setMixBoxesNum(new BigDecimal("0"));
        }
        pageInfo.setList(dtoList);
        logger.info("ESOutResultOrderQueryServiceImpl.queryOutResultOrderPage:{}", (Object)JSON.toJSONString((Object)pageInfo.getList()));
        return new RestResponse((Object)pageInfo);
    }
}

