/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cis.search.biz.apiimpl.query.impl.inventory;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cis.search.api.dto.request.EsLogicInventoryListPageParams;
import com.dtyunxi.cis.search.api.dto.response.EsLogicInventoryCountVO;
import com.dtyunxi.cis.search.api.dto.response.EsLogicInventoryVO;
import com.dtyunxi.cis.search.api.query.inventory.EsLogicInventoryQueryApi;
import com.dtyunxi.cis.search.biz.anno.ExecutorHandler;
import com.dtyunxi.cis.search.biz.base.BaseEsService;
import com.dtyunxi.cis.search.biz.constant.ExecutorEnum;
import com.dtyunxi.cis.search.biz.util.EsParamUtils;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.enums.DatePattern;
import com.dtyunxi.huieryun.opensearch.enums.SortOrder;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.dtyunxi.huieryun.opensearch.vo.SortFieldVo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.DateUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@ExecutorHandler(executorName={ExecutorEnum.CS_LOGIC_INVENTORY})
public class EsLogicInventoryQueryServiceImpl
extends BaseEsService
implements EsLogicInventoryQueryApi {
    private static final Logger log = LoggerFactory.getLogger(EsLogicInventoryQueryServiceImpl.class);

    private OSSearchVo initSearchVo(EsLogicInventoryListPageParams reqDto) throws Exception {
        OSSearchVo queryVo = EsParamUtils.newInstance().getSearchVo(reqDto);
        if (Objects.nonNull(reqDto.getPositiveBalance())) {
            if (reqDto.getPositiveBalance() == 1) {
                queryVo.addRangeFilter("balance", "1", String.valueOf(Integer.MAX_VALUE));
            } else if (reqDto.getPositiveBalance() == 0) {
                queryVo.addRangeFilter("balance", String.valueOf(Integer.MIN_VALUE), "0");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getExpireBeginTime()) && StringUtils.isNotEmpty((CharSequence)reqDto.getExpireBeginTime())) {
            queryVo.addRangeFilter("expireTime", this.beginTimeLong(reqDto.getExpireBeginTime()), this.beginTimeLong(reqDto.getExpireEndTime()));
        }
        if (Objects.nonNull(reqDto.getExpired())) {
            if (reqDto.getExpired() == 1) {
                queryVo.addRangeFilter("expireTime", DateUtil.format((Date)this.beginTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()), DateUtil.getCurrentTime());
            } else if (reqDto.getExpired() == 0) {
                queryVo.addRangeFilter("expireTime", DateUtil.getCurrentTime(), DateUtil.format((Date)this.endTime(), (String)DatePattern.DATETIME_PATTERN.getPattern()));
            }
        }
        log.info("{}ES[\u67e5\u8be2\u62fc\u63a5\u53c2\u6570]:{}", (Object)this.mainExecutor.getDesc(), (Object)JSON.toJSONString((Object)queryVo.getFilterFields()));
        return queryVo;
    }

    public RestResponse<PageInfo<EsLogicInventoryVO>> queryLogicInventoryListPage(EsLogicInventoryListPageParams dto) {
        PageInfo pageInfo = new PageInfo();
        try {
            OSSearchVo queryVo = this.initSearchVo(dto);
            queryVo.setPage(dto.getPageNum().intValue());
            queryVo.setPageSize(dto.getPageSize().intValue());
            ArrayList sortFields = Lists.newArrayList();
            sortFields.add(SortFieldVo.build((String)"updateTime", (SortOrder)SortOrder.DESC));
            sortFields.add(SortFieldVo.build((String)"id", (SortOrder)SortOrder.DESC));
            queryVo.setSortFields((List)sortFields);
            SearchResultVo searchResultVo = this.searchData(this.indexName, queryVo);
            if (null == searchResultVo || searchResultVo.getTotalSize() == 0L) {
                return new RestResponse((Object)new PageInfo());
            }
            pageInfo = this.searchResultPage(searchResultVo);
            pageInfo.setList(this.baseRowMapper(searchResultVo, EsLogicInventoryVO.class));
        }
        catch (Exception e) {
            log.error("{}ES\u67e5\u8be2\u5f02\u5e38\uff1a{}", new Object[]{this.mainExecutor.getDesc(), e.getMessage(), e});
            throw new BizException(this.mainExecutor.getDesc() + "ES\u67e5\u8be2\u5f02\u5e38");
        }
        return new RestResponse((Object)pageInfo);
    }

    public RestResponse<EsLogicInventoryCountVO> queryLogicInventoryByCount(EsLogicInventoryListPageParams dto) {
        EsLogicInventoryCountVO esLogicInventoryCountVO = new EsLogicInventoryCountVO();
        try {
            OSSearchVo queryVo = this.initSearchVo(dto);
            SearchResultVo searchResultVo = this.searchData(this.indexName, queryVo);
            if (null == searchResultVo || searchResultVo.getTotalSize() == 0L) {
                return new RestResponse((Object)esLogicInventoryCountVO);
            }
            List<EsLogicInventoryVO> dtoList = this.baseRowMapper(searchResultVo, EsLogicInventoryVO.class);
            BigDecimal countBalance = dtoList.stream().map(EsLogicInventoryVO::getBalance).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal countPreempt = dtoList.stream().map(EsLogicInventoryVO::getPreempt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal countAvailable = dtoList.stream().map(EsLogicInventoryVO::getAvailable).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal countIntransit = dtoList.stream().map(EsLogicInventoryVO::getIntransit).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal countFutureIn = dtoList.stream().map(EsLogicInventoryVO::getFutureIn).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalCount = countBalance.add(countPreempt).add(countAvailable).add(countIntransit).add(countFutureIn);
            esLogicInventoryCountVO.setCountBalance(countBalance);
            esLogicInventoryCountVO.setCountPreempt(countPreempt);
            esLogicInventoryCountVO.setCountAvailable(countAvailable);
            esLogicInventoryCountVO.setCountIntransit(countIntransit);
            esLogicInventoryCountVO.setCountFutureIn(countFutureIn);
            esLogicInventoryCountVO.setTotalCount(totalCount);
        }
        catch (Exception e) {
            log.error("\u903b\u8f91\u4ed3\u5217\u8868\u7edf\u8ba1\u6570\u636eES\u67e5\u8be2\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
            throw new BizException("\u903b\u8f91\u4ed3\u5217\u8868\u7edf\u8ba1\u6570\u636eES\u67e5\u8be2\u5f02\u5e38");
        }
        return new RestResponse((Object)esLogicInventoryCountVO);
    }
}

