/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.api.auth;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.starter.api.auth.ApiValidateDto;
import com.dtyunxi.cube.starter.api.auth.IApiValidateApi;
import com.dtyunxi.util.SpringBeanUtil;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;

public class ApiAuthInterceptor
implements HandlerInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(ApiAuthInterceptor.class);
    private Boolean isAuth = false;
    private final String module;
    private IApiValidateApi apiQueryApi;
    private static final String MSG_USER_UNAUTHORIZED = "{\"resultCode\":401,\"resultMsg\":\"user unauthorized\"}";
    private static final String MSG_API_NOT_ALLOWED = "{\"resultCode\":403,\"resultMsg\":\"api not allowed\"}";

    public ApiAuthInterceptor(boolean isAuth, String module) {
        this.isAuth = isAuth;
        this.module = module;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!this.isAuth.booleanValue()) {
            logger.debug("\u5173\u95ed\u63a5\u53e3\u9274\u6743");
            return true;
        }
        String path = request.getRequestURI().replace(request.getContextPath(), "");
        String method = request.getMethod();
        if ("OPTIONS".equals(method)) {
            return true;
        }
        ApiValidateDto validateDto = new ApiValidateDto();
        validateDto.setUserId(ServiceContext.getContext().getRequestUserId());
        validateDto.setModule(this.module);
        validateDto.setPath(path);
        validateDto.setMethod(method);
        logger.debug("-----> \u63a5\u53e3\u9274\u6743\uff1acontext={}, path={}, method={}", new Object[]{this.module, path, method});
        if (this.apiQueryApi == null) {
            this.apiQueryApi = (IApiValidateApi)SpringBeanUtil.getBean(IApiValidateApi.class);
        }
        Boolean result = (Boolean)this.apiQueryApi.validate(validateDto).getData();
        logger.debug("-----> \u63a5\u53e3\u9274\u6743\uff1aresult={}", (Object)result);
        if (!result.booleanValue()) {
            response.setStatus(validateDto.getUserId() == null ? 401 : 403);
            PrintWriter out = response.getWriter();
            out.append(validateDto.getUserId() == null ? MSG_USER_UNAUTHORIZED : MSG_API_NOT_ALLOWED);
            out.close();
            return false;
        }
        return true;
    }
}

