/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.plugin.mq.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.plugin.mq.TopicRegistryVo;
import com.dtyunxi.cube.plugin.mq.impl.CommonsMqHelper;
import com.dtyunxi.huieryun.mq.api.IConsumer;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.api.IProducer;
import com.dtyunxi.huieryun.mq.constant.MessageType;
import com.dtyunxi.huieryun.mq.vo.MessageRegistryVo;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.util.CollectionUtils;

public class CommonsMqServiceImpl
implements ICommonsMqService {
    private static Logger logger = LoggerFactory.getLogger(CommonsMqServiceImpl.class);
    private IProducer commonsProducer;
    private IConsumer commonsConsumer;
    private MessageRegistryVo messageRegistryVo;
    private String profile;
    private TopicRegistryVo topicRegistryVo;

    public CommonsMqServiceImpl(IProducer commonsProducer, IConsumer commonsConsumer, MessageRegistryVo registryVo, String profile, TopicRegistryVo topicRegistryVo) {
        this.commonsProducer = commonsProducer;
        this.commonsConsumer = commonsConsumer;
        this.messageRegistryVo = registryVo;
        this.profile = profile;
        this.topicRegistryVo = topicRegistryVo;
    }

    @Override
    public MessageResponse sendDelaySingleMessage(String tag, Object msg, Long delayTime) {
        try {
            return this.sendDelaySingleMessageWithThrownException(tag, msg, delayTime);
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u70b9\u5bf9\u70b9\u5ef6\u8fdfMQ\u6d88\u606f\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return MessageResponse.ERROR;
        }
    }

    @Override
    public MessageResponse sendSingleMessage(String tag, Object msg) {
        try {
            return this.sendSingleMessageWithThrownException(tag, msg);
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001MQ\u6d88\u606f\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return MessageResponse.ERROR;
        }
    }

    @Override
    public MessageResponse sendDelaySingleMessageWithThrownException(String tag, Object msg, Long delayTime) {
        return this.sendDelaySingleMessageWithThrownException(this.topicRegistryVo.getSingleTopic(), tag, msg, delayTime);
    }

    @Override
    public MessageResponse sendSingleMessageWithThrownException(String tag, Object msg) {
        return this.sendSingleMessageWithThrownException(this.topicRegistryVo.getSingleTopic(), tag, msg);
    }

    @Override
    @Async
    public MessageResponse sendSingleMessageAsync(String tag, Object msg) {
        return this.sendSingleMessage(tag, msg);
    }

    @Override
    @Async
    public MessageResponse sendDelaySingleMessageAsync(String tag, Object msg, Long delayTime) {
        return this.sendDelaySingleMessage(tag, msg, delayTime);
    }

    @Override
    @Async
    public MessageResponse sendSingleMessageAsyncWithThrownException(String tag, Object msg) {
        return this.sendSingleMessageWithThrownException(tag, msg);
    }

    @Override
    @Async
    public MessageResponse sendDelaySingleMessageAsyncWithThrownException(String tag, Object msg, Long delayTime) {
        return this.sendDelaySingleMessageWithThrownException(tag, msg, delayTime);
    }

    @Override
    public MessageResponse sendDelaySingleMessage(String topic, String tag, Object msg, Long delayTime) {
        return this.sendDelaySingleMessageWithThrownException(topic, tag, msg, delayTime);
    }

    @Override
    public MessageResponse sendSingleMessage(String topic, String tag, Object msg) {
        return this.sendSingleMessageWithThrownException(topic, tag, msg);
    }

    @Override
    public MessageResponse sendDelaySingleMessageWithThrownException(String topic, String tag, Object msg, Long delayTime) {
        topic = this.parseTopicWithProfile(topic);
        tag = this.parseTag(tag, topic);
        logger.info("\u5f00\u59cb\u53d1\u9001\u70b9\u5bf9\u70b9MQ\u6d88\u606f\uff0ctopic:{}, tag\uff1a{}\uff0c delayTime\uff1a{}", new Object[]{topic, tag, delayTime});
        return this.commonsProducer.sendSingleMessage(topic, tag, msg, delayTime.longValue());
    }

    @Override
    public MessageResponse sendSingleMessageWithThrownException(String topic, String tag, Object msg) {
        topic = this.parseTopicWithProfile(topic);
        tag = this.parseTag(tag, topic);
        logger.info("\u5f00\u59cb\u53d1\u9001\u70b9\u5bf9\u70b9MQ\u6d88\u606f\uff0ctopic :{}, tag\uff1a{}", (Object)topic, (Object)tag);
        return this.commonsProducer.sendSingleMessage(topic, tag, msg);
    }

    @Override
    @Async
    public MessageResponse sendSingleMessageAsync(String topic, String tag, Object msg) {
        return this.sendSingleMessage(topic, tag, msg);
    }

    @Override
    @Async
    public MessageResponse sendDelaySingleMessageAsync(String topic, String tag, Object msg, Long delayTime) {
        return this.sendDelaySingleMessage(topic, tag, msg, delayTime);
    }

    @Override
    @Async
    public MessageResponse sendSingleMessageAsyncWithThrownException(String topic, String tag, Object msg) {
        return this.sendSingleMessageWithThrownException(topic, tag, msg);
    }

    @Override
    @Async
    public MessageResponse sendDelaySingleMessageAsyncWithThrownException(String topic, String tag, Object msg, Long delayTime) {
        return this.sendDelaySingleMessageWithThrownException(topic, tag, msg, delayTime);
    }

    @Override
    public MessageResponse publishMessage(String tag, Object msg) {
        return this.publishMessage(this.topicRegistryVo.getPublishTopic(), tag, msg);
    }

    @Override
    public MessageResponse publishDelayMessage(String tag, Object msg, Long delayTime) {
        return this.publishDelayMessage(this.topicRegistryVo.getPublishTopic(), tag, msg, delayTime);
    }

    @Override
    public MessageResponse publishMessageWithThrownException(String tag, Object msg) {
        return this.publishMessageWithThrownException(this.topicRegistryVo.getPublishTopic(), tag, msg);
    }

    @Override
    public MessageResponse publishDelayMessageWithThrownException(String tag, Object msg, Long delayTime) {
        return this.publishDelayMessageWithThrownException(this.topicRegistryVo.getPublishTopic(), tag, msg, delayTime);
    }

    @Override
    public MessageResponse publishMessage(String topic, String tag, Object msg) {
        try {
            return this.publishMessageWithThrownException(topic, tag, msg);
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u8ba2\u9605\u5ef6\u8fdfMQ\u6d88\u606f\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return MessageResponse.ERROR;
        }
    }

    @Override
    public MessageResponse publishDelayMessage(String topic, String tag, Object msg, Long delayTime) {
        try {
            this.publishDelayMessageWithThrownException(topic, tag, msg, delayTime);
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u8ba2\u9605\u5ef6\u8fdfMQ\u6d88\u606f\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        return MessageResponse.ERROR;
    }

    @Override
    public MessageResponse publishMessageWithThrownException(String topic, String tag, Object msg) {
        topic = this.parseTopicWithProfile(topic);
        tag = this.parseTag(tag, topic);
        logger.info("\u5f00\u59cb\u53d1\u9001\u8ba2\u9605MQ\u6d88\u606f\uff0c topic:{}, tag\uff1a{}", (Object)topic, (Object)tag);
        return this.commonsProducer.sendMessage(topic, tag, msg);
    }

    @Override
    public MessageResponse publishDelayMessageWithThrownException(String topic, String tag, Object msg, Long delayTime) {
        topic = this.parseTopicWithProfile(topic);
        tag = this.parseTag(tag, topic);
        logger.info("\u5f00\u59cb\u53d1\u9001\u8ba2\u9605MQ\u6d88\u606f\uff0ctopic:{}, tag\uff1a{}\uff0c delayTime:{}", new Object[]{topic, tag, delayTime});
        return this.commonsProducer.sendMessage(topic, tag, msg, delayTime.longValue());
    }

    @Override
    @Async
    public MessageResponse publishMessageAsync(String tag, Object msg) {
        return this.publishMessage(tag, msg);
    }

    @Override
    @Async
    public MessageResponse publishDelayMessageAsync(String tag, Object msg, Long delayTime) {
        return this.publishDelayMessage(tag, msg, delayTime);
    }

    @Override
    @Async
    public MessageResponse publishMessageAsync(String topic, String tag, Object msg) {
        return this.publishMessage(topic, tag, msg);
    }

    @Override
    @Async
    public MessageResponse publishDelayMessageAsync(String topic, String tag, Object msg, Long delayTime) {
        return this.publishDelayMessage(topic, tag, msg, delayTime);
    }

    @Override
    @Async
    public MessageResponse publishMessageAsyncWithThrownException(String tag, Object msg) {
        return this.publishMessageWithThrownException(tag, msg);
    }

    @Override
    @Async
    public MessageResponse publishDelayMessageAsyncWithThrownException(String tag, Object msg, Long delayTime) {
        return this.publishDelayMessageWithThrownException(tag, msg, delayTime);
    }

    @Override
    @Async
    public MessageResponse publishMessageAsyncWithThrownException(String topic, String tag, Object msg) {
        return this.publishMessageWithThrownException(topic, tag, msg);
    }

    @Override
    @Async
    public MessageResponse publishDelayMessageAsyncWithThrownException(String topic, String tag, Object msg, Long delayTime) {
        return this.publishDelayMessageWithThrownException(topic, tag, msg, delayTime);
    }

    @Override
    @Deprecated
    public void receiveSingleMessage(Map<String, IMessageProcessor> processorMap) {
    }

    @Override
    @Deprecated
    public void receiveSingleMessage(String topic, String consumer, Map<String, IMessageProcessor> processorMap) {
    }

    private void receiveSingleMessage(String consumer, Map<String, Map<String, IMessageProcessor>> processorMap) {
        processorMap = this.parseTopicMap(processorMap);
        String tmpConsumer = new String(consumer);
        for (String topic : processorMap.keySet()) {
            tmpConsumer = this.parseConsumerWithProfile(consumer, topic);
            processorMap.put(topic, this.parseTagMap(processorMap.get(topic), topic));
        }
        logger.info("\u76d1\u542c consumer:{} processor:{}", (Object)tmpConsumer, (Object)JSON.toJSONString(processorMap));
        this.commonsConsumer.receiveMessage(tmpConsumer, processorMap);
    }

    @Override
    @Deprecated
    public void subscribeMessage(Map<String, IMessageProcessor> processorMap) {
    }

    @Override
    @Deprecated
    public void subscribeMessage(String topic, String consumer, Map<String, IMessageProcessor> processorMap) {
    }

    private void subscribeMessage(String consumer, Map<String, Map<String, IMessageProcessor>> processorMap) {
        processorMap = this.parseTopicMap(processorMap);
        String tmpConsumer = new String(consumer);
        for (String topic : processorMap.keySet()) {
            tmpConsumer = this.parseConsumerWithProfile(consumer, topic);
            processorMap.put(topic, this.parseTagMap(processorMap.get(topic), topic));
        }
        logger.info("\u76d1\u542c consumer:{} processor:{}", (Object)tmpConsumer, (Object)JSON.toJSONString(processorMap));
        this.commonsConsumer.subscribe(tmpConsumer, processorMap);
    }

    private String parseTag(String tag, String topic) {
        if (MessageType.RABBIT.getName().equalsIgnoreCase(this.messageRegistryVo.getType())) {
            tag = this.parseTagWithProfile(tag, topic);
        }
        return tag;
    }

    private Map<String, IMessageProcessor> parseTagMap(Map<String, IMessageProcessor> tagMap, String topic) {
        if (MessageType.RABBIT.getName().equalsIgnoreCase(this.messageRegistryVo.getType())) {
            HashMap<String, IMessageProcessor> map = new HashMap<String, IMessageProcessor>();
            for (String tag : tagMap.keySet()) {
                map.put(this.parseTag(tag, topic), tagMap.get(tag));
            }
            tagMap = map;
        }
        return tagMap;
    }

    private Map<String, Map<String, IMessageProcessor>> parseTopicMap(Map<String, Map<String, IMessageProcessor>> topicMap) {
        HashMap<String, Map<String, IMessageProcessor>> map = new HashMap<String, Map<String, IMessageProcessor>>();
        for (String topic : topicMap.keySet()) {
            map.put(this.parseTopicWithProfile(topic), topicMap.get(topic));
        }
        return map;
    }

    @Override
    @Deprecated
    public void subscribeMessage() {
    }

    @Override
    @Deprecated
    public void subscribeMessage(String topic, String consumer) {
    }

    @Override
    public void start(String consumer) {
        if (MessageType.RABBIT.getName().equalsIgnoreCase(this.messageRegistryVo.getType())) {
            Map<String, Map<String, IMessageProcessor>> publishProcessors;
            Map<String, Map<String, IMessageProcessor>> singleProcessors = CommonsMqHelper.getSingleProcessors(consumer);
            if (null != singleProcessors && singleProcessors.size() > 0) {
                this.receiveSingleMessage(consumer, singleProcessors);
            }
            if (null != (publishProcessors = CommonsMqHelper.getPublishProcessors(consumer)) && publishProcessors.size() > 0) {
                publishProcessors.forEach((topic, processorsMap) -> {
                    String finalTopic = this.parseTopicWithProfile((String)topic);
                    processorsMap.forEach((tag, processor) -> {
                        String finalTag = this.parseTag((String)tag, (String)topic);
                        this.commonsConsumer.subscribe(finalTopic, consumer, finalTag, processor);
                    });
                });
            }
        } else if (MessageType.ALIYUN.getName().equalsIgnoreCase(this.messageRegistryVo.getType()) || MessageType.ROCKET.getName().equalsIgnoreCase(this.messageRegistryVo.getType())) {
            Map<String, Map<String, IMessageProcessor>> processors = CommonsMqHelper.getAllProcessors(consumer);
            if (null != processors && processors.size() > 0) {
                this.subscribeMessage(consumer, processors);
            } else {
                logger.info("\u4e0d\u9700\u8981\u76d1\u542c\u6d88\u606f");
            }
        } else {
            logger.info("\u6d88\u606f\u7c7b\u578b\u6682\u4e0d\u652f\u6301, \u8bf7\u8054\u7cfb\u4e2d\u53f0\u540c\u5b66\u652f\u6301");
        }
    }

    @Override
    public String parseTopicWithProfile(String topic) {
        return this.parseStringWithProfile(topic, topic);
    }

    @Override
    public String parseTagWithProfile(String tag, String topic) {
        return this.parseStringWithProfile(tag, topic);
    }

    @Override
    public String parseConsumerWithProfile(String consumer, String topic) {
        return this.parseStringWithProfile(consumer, topic);
    }

    protected String parseStringWithProfile(String str, String topic) {
        Set<String> topics = this.topicRegistryVo.getIgnoreGlobalProfileTopics();
        return !CollectionUtils.isEmpty(topics) && topics.contains(topic) ? str : (str + "_" + this.profile).replace("-", "_").toUpperCase();
    }
}

