/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.shipping.kidiniao;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.channel.IChannelConfig;
import com.dtyunxi.cube.commons.channel.shipping.beans.ShippingInfo;
import com.dtyunxi.cube.commons.channel.shipping.beans.Trace;
import com.dtyunxi.cube.commons.channel.shipping.impl.AbstractShippingChannelImpl;
import com.dtyunxi.cube.starter.shipping.kidiniao.KdNiaoChannelConfig;
import com.dtyunxi.cube.starter.shipping.kidiniao.bean.KuaiDiNiaoShippingInfo;
import com.dtyunxi.cube.utils.codec.Coder;
import com.dtyunxi.cube.utils.net.HttpUtil;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class KidiNiaoShippingChannelImpl
extends AbstractShippingChannelImpl {
    private KdNiaoChannelConfig kdNiaoChannelConfig;

    public KidiNiaoShippingChannelImpl(KdNiaoChannelConfig kdNiaoChannelConfig) {
        this.kdNiaoChannelConfig = kdNiaoChannelConfig;
        this.config(kdNiaoChannelConfig);
    }

    public void config(IChannelConfig config) {
        this.kdNiaoChannelConfig = (KdNiaoChannelConfig)config;
    }

    public ShippingInfo queryShipping(String shippingNo, String shippingCode) throws Exception {
        String result = KidiNiaoShippingChannelImpl.getOrderTracesByJson(this.kdNiaoChannelConfig, shippingCode, shippingNo);
        JSONObject kuaiDiNiaoJson = JSON.parseObject((String)String.valueOf(result));
        KuaiDiNiaoShippingInfo kuaiDiNiaoShippingInfo = (KuaiDiNiaoShippingInfo)JSONObject.toJavaObject((JSON)kuaiDiNiaoJson, KuaiDiNiaoShippingInfo.class);
        ShippingInfo shippingInfo = new ShippingInfo();
        shippingInfo.setShippingCode(shippingCode);
        shippingInfo.setShippingNo(shippingNo);
        shippingInfo.setState(kuaiDiNiaoShippingInfo.getState());
        List traceList = kuaiDiNiaoShippingInfo.getTraces().stream().map(traceRespDto -> {
            Trace trace = new Trace();
            trace.setDetail(traceRespDto.getAcceptStation());
            trace.setTime(traceRespDto.getAcceptTime());
            trace.setRemark(traceRespDto.getRemark());
            return trace;
        }).collect(Collectors.toList());
        shippingInfo.setTraces(traceList);
        return shippingInfo;
    }

    private static String getOrderTracesByJson(KdNiaoChannelConfig kdniaoConfig, String expCode, String expNo) throws Exception {
        String requestData = "{'OrderCode':'','ShipperCode':'" + expCode + "','LogisticCode':'" + expNo + "'}";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("RequestData", URLEncoder.encode(requestData, "UTF-8"));
        params.put("EBusinessID", kdniaoConfig.geteBusinessID());
        params.put("RequestType", "1002");
        String dataSign = Coder.base64Encode((String)Coder.md5Hex((String)(requestData + kdniaoConfig.getAppKey())));
        params.put("DataSign", URLEncoder.encode(dataSign, "UTF-8"));
        params.put("DataType", "2");
        return HttpUtil.postForm((String)kdniaoConfig.getReqURL(), params);
    }

    public String name() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

