/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.enhance.param;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target(value={ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface CubeParam {
    public String capabilityCode();

    public String name();

    public String descr();

    public OptionSourceType optionSourceType() default OptionSourceType.STATIC;

    public Option[] options() default {};

    public Tabular tabular() default @Tabular(headers={});

    public static @interface Tabular {
        public Header[] headers();

        public Row[] rows() default {};

        public static @interface ColumnValue {
            public String key();

            public String value();
        }

        public static @interface Row {
            public ColumnValue[] columnValues();
        }

        public static @interface Header {
            public String code();

            public String name();

            public String remark() default "";
        }
    }

    public static enum SettingEditType {
        INPUT(1),
        SELECT(2);

        private int value;

        private SettingEditType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public boolean equals(Integer value) {
            return value != null && value.equals(this.value);
        }
    }

    public static enum OptionSourceType {
        STATIC(1),
        DYNAMIC_FROM_DICT(2),
        DYNAMIC_FROM_BUNDLE(3);

        private Integer value;

        private OptionSourceType(int value) {
            this.value = value;
        }

        public Integer getValue() {
            return this.value;
        }

        public boolean equals(Integer value) {
            return this.value.equals(value);
        }
    }

    public static @interface Option {
        public String code();

        public String name();

        public String value();

        public String descr() default "";

        public boolean isDefault() default false;
    }
}

