/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.maven.plugin;

import com.dtyunxi.cube.maven.plugin.scan.util.ConfigUtils;
import java.io.File;
import java.io.IOException;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.springframework.util.ClassUtils;

public abstract class AbstractCubeMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.compileClasspathElements}", readonly=true, required=true)
    protected List<String> compileClasspathElements;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject mvnProject;
    protected URLClassLoader classLoader;
    protected Charset CHARSET_DEF = StandardCharsets.UTF_8;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.classLoader = Objects.requireNonNull((URLClassLoader)ClassUtils.getDefaultClassLoader(), "\u7c7b\u52a0\u8f7d\u5668\u4e3a\u7a7a");
            this.compileClasspathElements.forEach(e -> ConfigUtils.addURLToClassLoad(this.classLoader, e));
            this.executeComplement();
        }
        catch (Exception e2) {
            this.getLog().error((Throwable)e2);
        }
    }

    protected abstract void executeComplement() throws Exception;

    protected String getOutputDirectory() {
        return this.mvnProject.getBuild().getOutputDirectory();
    }

    protected Set<File> scanFilesWithAnnotation(Class clazz) throws IOException {
        HashSet<File> sourceCodeFiles = new HashSet<File>();
        for (String compileSourceRoot : this.mvnProject.getCompileSourceRoots()) {
            Collection<File> files;
            File dir = new File(compileSourceRoot);
            if (dir.isDirectory()) {
                files = FileUtils.listFiles((File)dir, (String[])new String[]{"java"}, (boolean)true);
            } else {
                if (!dir.exists()) continue;
                files = Collections.singletonList(dir);
            }
            for (File file : files) {
                String content = FileUtils.readFileToString((File)file, (Charset)this.CHARSET_DEF);
                boolean putIn = false;
                if (content.contains(clazz.getCanonicalName())) {
                    putIn = true;
                } else if (content.contains(clazz.getPackage().getName() + ".*")) {
                    putIn = true;
                }
                if (!putIn) continue;
                sourceCodeFiles.add(file);
            }
        }
        return sourceCodeFiles;
    }
}

