/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.maven.plugin.complement.swagger;

import com.dtyunxi.cube.enhance.generator.annotation.CubeDto;
import com.dtyunxi.cube.maven.plugin.AbstractCubeMojo;
import com.dtyunxi.cube.maven.plugin.complement.conf.AppendUtil;
import com.dtyunxi.cube.maven.plugin.complement.swagger.CubeSwaggerASTVisitor;
import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="genSwaggerAnnotationFromJavaDocMojo", requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class GenSwaggerAnnotationFromJavaDocMojo
extends AbstractCubeMojo {
    @Override
    protected void executeComplement() throws Exception {
        ClassPool pool = ClassPool.getDefault();
        pool.insertClassPath(this.getOutputDirectory());
        Set<File> sourceCodeFilesWithCubeDto = this.scanFilesWithAnnotation(CubeDto.class);
        for (File file : sourceCodeFilesWithCubeDto) {
            this.modifyClassWithAnnotation(file, pool);
        }
    }

    private void modifyClassWithAnnotation(File sourceCodeFile, ClassPool pool) throws IOException, NotFoundException, CannotCompileException {
        CompilationUnit unit = JavaParser.parse((File)sourceCodeFile);
        CubeSwaggerASTVisitor<Object> cubeSwaggerASTVisitor = new CubeSwaggerASTVisitor<Object>();
        cubeSwaggerASTVisitor.visit(unit, null);
        if (cubeSwaggerASTVisitor.isDoAppend()) {
            CtClass ctClass = AppendUtil.fetchCtClass4CompilationUnit(pool, unit);
            ctClass = this.appendApiModel(cubeSwaggerASTVisitor, ctClass);
            ctClass = this.appendApiModelProperty(cubeSwaggerASTVisitor, ctClass);
            ctClass.writeFile(this.getOutputDirectory());
        }
    }

    private CtClass appendApiModelProperty(CubeSwaggerASTVisitor<Object> cubeSwaggerASTVisitor, CtClass ctClass) throws NotFoundException {
        ConstPool constpool = ctClass.getClassFile().getConstPool();
        for (Map.Entry<String, String> entry : cubeSwaggerASTVisitor.getFieldComments().entrySet()) {
            CtField field = ctClass.getField(entry.getKey());
            Annotation apiModelPropertyAnnotation = new Annotation(ApiModelProperty.class.getCanonicalName(), constpool);
            apiModelPropertyAnnotation.addMemberValue("value", (MemberValue)new StringMemberValue(entry.getValue(), constpool));
            AnnotationsAttribute fieldAttr = new AnnotationsAttribute(constpool, "RuntimeVisibleAnnotations");
            fieldAttr.addAnnotation(apiModelPropertyAnnotation);
            field.getFieldInfo().addAttribute((AttributeInfo)fieldAttr);
        }
        return ctClass;
    }

    private CtClass appendApiModel(CubeSwaggerASTVisitor<Object> cubeSwaggerASTVisitor, CtClass ctClass) {
        ClassFile ccFile = ctClass.getClassFile();
        ConstPool constpool = ctClass.getClassFile().getConstPool();
        AnnotationsAttribute attr = new AnnotationsAttribute(constpool, "RuntimeVisibleAnnotations");
        Annotation apiModelAnnotation = new Annotation(ApiModel.class.getCanonicalName(), constpool);
        for (Map.Entry<String, String> entry : cubeSwaggerASTVisitor.getApiModelValueMembers().entrySet()) {
            apiModelAnnotation.addMemberValue(entry.getKey(), (MemberValue)new StringMemberValue(entry.getValue(), constpool));
            attr.addAnnotation(apiModelAnnotation);
        }
        ccFile.addAttribute((AttributeInfo)attr);
        return ctClass;
    }
}

