/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.maven.plugin.scan.mojo;

import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.cube.domain.event.service.IDomainEventListener;
import com.dtyunxi.cube.enhance.CubeResource;
import com.dtyunxi.cube.enhance.extension.CubeExtImpl;
import com.dtyunxi.cube.enhance.extension.DomainEvent;
import com.dtyunxi.cube.enhance.extension.ICubeExtension;
import com.dtyunxi.cube.maven.plugin.scan.constant.Constants;
import com.dtyunxi.cube.maven.plugin.scan.dto.BundleSettingDto;
import com.dtyunxi.cube.maven.plugin.scan.mojo.BaseScanMojo;
import com.dtyunxi.cube.maven.plugin.scan.util.PropertyUtil;
import com.dtyunxi.cube.utils.Pair;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.springframework.util.CollectionUtils;

public class BizScanMojo
extends BaseScanMojo {
    public BizScanMojo(MavenProject mavenProject, Log log) {
        super(mavenProject, log);
    }

    @Override
    public void execute() {
        try {
            List<Class<?>> classes = this.getModuleClasses();
            if (CollectionUtils.isEmpty(classes)) {
                return;
            }
            PropertyUtil.getProperties(this.mavenProject, this.log);
            Pair<List<BundleSettingDto.Option>, List<BundleSettingDto.DepdSetting>> pairOption = this.readSpiExt(classes);
            ArrayList<BundleSettingDto.Option> options = new ArrayList<BundleSettingDto.Option>((Collection)pairOption.key);
            ArrayList<BundleSettingDto.DepdSetting> depdSettings = new ArrayList<BundleSettingDto.DepdSetting>((Collection)pairOption.value);
            pairOption = this.readDomainEventListener(classes);
            options.addAll((Collection)pairOption.key);
            depdSettings.addAll((Collection)pairOption.value);
            BundleSettingDto projectSettings = new BundleSettingDto();
            projectSettings.setGroupId(this.groupId);
            projectSettings.setArtifactId(this.artifactId);
            projectSettings.setVersion(this.version);
            projectSettings.setOptions(options);
            if (CollectionUtil.isNotEmpty(options)) {
                this.writeFile(projectSettings, Constants.SETTING_OPTION_LOCATION);
            }
            projectSettings.setSettings(null);
            projectSettings.setOptions(null);
            projectSettings.setDepdSettings(depdSettings);
            if (CollectionUtil.isNotEmpty(depdSettings)) {
                this.writeFile(projectSettings, Constants.OPTION_SETTING_RELATION_LOCATION);
            }
        }
        catch (Exception e) {
            this.log.error((CharSequence)("\u751f\u6210" + Constants.SETTING_OPTION_LOCATION + "\u6587\u4ef6\u5931\u8d25"), (Throwable)e);
        }
    }

    private Pair<List<BundleSettingDto.Option>, List<BundleSettingDto.DepdSetting>> readSpiExt(List<Class<?>> classes) {
        ArrayList options = new ArrayList();
        ArrayList depdSettings = new ArrayList();
        if (CollectionUtils.isEmpty(classes)) {
            return new Pair(options, depdSettings);
        }
        Map<Class, List<Class>> extPointMap = classes.stream().filter(implClazz -> !implClazz.isInterface() && ICubeExtension.class.isAssignableFrom((Class<?>)implClazz)).collect(Collectors.groupingBy(clazz -> Arrays.stream(clazz.getInterfaces()).filter(extPointClazz -> ICubeExtension.class.isAssignableFrom((Class<?>)extPointClazz)).findFirst().orElseThrow(() -> new RuntimeException("\u83b7\u53d6\u6269\u5c55\u63a5\u53e3\u5f02\u5e38"))));
        extPointMap.forEach((k, v) -> {
            List settingOptions = v.stream().map(extPointImplClazz -> {
                BundleSettingDto.Option settingOption = new BundleSettingDto.Option();
                settingOption.setSettingCode(k.getCanonicalName());
                settingOption.setCode(extPointImplClazz.getCanonicalName());
                settingOption.setValue(extPointImplClazz.getCanonicalName());
                CubeExtImpl extPointImpl = extPointImplClazz.getAnnotation(CubeExtImpl.class);
                if (extPointImpl != null) {
                    settingOption.setName(extPointImpl.name());
                    settingOption.setDescr(extPointImpl.descr());
                    settingOption.setSort(extPointImpl.sort());
                } else {
                    try {
                        ICubeExtension extPointImplInstance = (ICubeExtension)extPointImplClazz.newInstance();
                        settingOption.setName(extPointImplInstance.getName());
                        settingOption.setDescr(extPointImplInstance.getDesc());
                        settingOption.setSort(0);
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        e.printStackTrace();
                    }
                }
                List<String> depdSettingCodes = this.readDepdSettingCode((Class<?>)extPointImplClazz);
                if (!CollectionUtils.isEmpty(depdSettingCodes)) {
                    BundleSettingDto.DepdSetting depdSetting = new BundleSettingDto.DepdSetting();
                    depdSetting.setSettingCode(settingOption.getSettingCode());
                    depdSetting.setOptionCode(settingOption.getCode());
                    depdSetting.setDepdSettingCode(depdSettingCodes);
                    depdSettings.add(depdSetting);
                }
                return settingOption;
            }).collect(Collectors.toList());
            options.addAll(settingOptions);
        });
        return new Pair(options, depdSettings);
    }

    private Pair<List<BundleSettingDto.Option>, List<BundleSettingDto.DepdSetting>> readDomainEventListener(List<Class<?>> classes) {
        List<Object> options = new ArrayList();
        ArrayList depdSettings = new ArrayList();
        if (CollectionUtils.isEmpty(classes)) {
            return new Pair(options, depdSettings);
        }
        List eventOptionClassList = classes.stream().filter(clazz -> {
            if (IDomainEventListener.class.isAssignableFrom((Class<?>)clazz)) {
                return true;
            }
            if (IMessageProcessor.class.isAssignableFrom((Class<?>)clazz) && !clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers())) {
                Class<?> parameterType = BizScanMojo.getMessageType(clazz);
                if (null == parameterType) {
                    return false;
                }
                return BizScanMojo.getMessageType(clazz).isAnnotationPresent(DomainEvent.class);
            }
            return false;
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(eventOptionClassList)) {
            return new Pair(options, depdSettings);
        }
        options = eventOptionClassList.stream().map(clazz -> {
            this.log.info((CharSequence)("\u9886\u57df\u4e8b\u4ef6\u8ba2\u9605\u8005\uff1a" + clazz.getCanonicalName()));
            this.log.info((CharSequence)("\u9886\u57df\u4e8b\u4ef6DTO\uff1a" + BizScanMojo.getMessageType(clazz)));
            DomainEvent domainEvent = BizScanMojo.getMessageType(clazz).getAnnotation(DomainEvent.class);
            List<String> depdSettingCodes = this.readDepdSettingCode((Class<?>)clazz);
            if (!CollectionUtils.isEmpty(depdSettingCodes)) {
                BundleSettingDto.DepdSetting depdSetting = new BundleSettingDto.DepdSetting();
                depdSetting.setSettingCode(PropertyUtil.replacePlaceHolder(domainEvent.code()));
                depdSetting.setOptionCode(clazz.getCanonicalName());
                depdSetting.setDepdSettingCode(depdSettingCodes);
                depdSettings.add(depdSetting);
            }
            return this.parseDomainEventListener((Class<?>)clazz, domainEvent);
        }).collect(Collectors.toList());
        return new Pair(options, depdSettings);
    }

    public static Class<?> getMessageType(Class<?> clazz) {
        Type[] genTypes = clazz.getGenericInterfaces();
        if (genTypes != null && genTypes.length > 0) {
            for (Type genType : genTypes) {
                ParameterizedType parameterizedType;
                if (!(genType instanceof ParameterizedType) || !IMessageProcessor.class.equals((Object)(parameterizedType = (ParameterizedType)genType).getRawType()) && !IDomainEventListener.class.equals((Object)parameterizedType.getRawType())) continue;
                Type arguType = parameterizedType.getActualTypeArguments()[0];
                return (Class)(arguType instanceof ParameterizedType ? ((ParameterizedType)arguType).getRawType() : arguType);
            }
        }
        return null;
    }

    private BundleSettingDto.Option parseDomainEventListener(Class<?> clazz, DomainEvent domainEvent) {
        BundleSettingDto.Option settingOption = new BundleSettingDto.Option();
        settingOption.setSettingCode(PropertyUtil.replacePlaceHolder(domainEvent.code()));
        settingOption.setCode(clazz.getCanonicalName());
        settingOption.setValue(clazz.getCanonicalName());
        settingOption.setName(domainEvent.name());
        settingOption.setDescr(domainEvent.descr());
        return settingOption;
    }

    private List<String> readDepdSettingCode(Class<?> clazz) {
        Field[] resourceFields = clazz.getDeclaredFields();
        ArrayList<String> depdSettingCodes = new ArrayList<String>();
        for (Field field : resourceFields) {
            CubeResource cubeResource = field.getAnnotation(CubeResource.class);
            if (null == cubeResource) continue;
            depdSettingCodes.add(field.getType().getName());
        }
        return depdSettingCodes;
    }
}

