/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.maven.plugin.scan.mojo;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.dto.TimeSlotDto;
import com.dtyunxi.cube.enhance.extension.CubeExt;
import com.dtyunxi.cube.enhance.extension.ICubeExtension;
import com.dtyunxi.cube.enhance.param.CubeParam;
import com.dtyunxi.cube.enhance.param.ICubeParam;
import com.dtyunxi.cube.maven.plugin.scan.constant.Constants;
import com.dtyunxi.cube.maven.plugin.scan.dto.BundleSettingDto;
import com.dtyunxi.cube.maven.plugin.scan.dto.TabularDto;
import com.dtyunxi.cube.maven.plugin.scan.mojo.BaseScanMojo;
import com.dtyunxi.cube.utils.Util;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BasicDynaBean;
import org.apache.commons.beanutils.BasicDynaClass;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class ConfScanMojo
extends BaseScanMojo {
    public ConfScanMojo(MavenProject mavenProject, Log log) {
        super(mavenProject, log);
    }

    @Override
    public void execute() {
        try {
            List<Class<?>> classes = this.getModuleClasses();
            List paramClazzList = classes.stream().filter(c -> c.isInterface() && c != ICubeParam.class && ICubeParam.class.isAssignableFrom((Class<?>)c)).collect(Collectors.toList());
            List<BundleSettingDto.Setting> parameters = paramClazzList.stream().map(paramClazz -> {
                CubeParam defineParam = paramClazz.getAnnotation(CubeParam.class);
                return defineParam != null ? ConfScanMojo.convertParamFromAnnotation(paramClazz, defineParam, this.log) : ConfScanMojo.convertParamFromInterface(paramClazz, this.log);
            }).collect(Collectors.toList());
            List extPointClazzList = classes.stream().filter(c -> c.isInterface() && c != ICubeExtension.class && ICubeExtension.class.isAssignableFrom((Class<?>)c)).collect(Collectors.toList());
            List extensions = extPointClazzList.stream().map(extPointClazz -> {
                CubeExt defineExtPoint = extPointClazz.getAnnotation(CubeExt.class);
                return defineExtPoint != null ? ConfScanMojo.convertExtPointFromAnnotation(extPointClazz, defineExtPoint) : ConfScanMojo.convertExtPointFromInterface(extPointClazz);
            }).collect(Collectors.toList());
            parameters.addAll(extensions);
            List<BundleSettingDto.Option> options = parameters.stream().filter(e -> !CollectionUtils.isEmpty(e.getOptions())).flatMap(e -> e.getOptions().stream()).collect(Collectors.toList());
            BundleSettingDto bundleSetting = new BundleSettingDto();
            bundleSetting.setGroupId(this.groupId);
            bundleSetting.setArtifactId(this.artifactId);
            bundleSetting.setVersion(this.version);
            bundleSetting.setSettings(parameters);
            bundleSetting.setOptions(options);
            this.writeFile(bundleSetting, Constants.SETTING_LOCATION);
        }
        catch (Exception e2) {
            this.log.error((CharSequence)("\u751f\u6210" + Constants.SETTING_LOCATION + "\u6587\u4ef6\u5931\u8d25"), (Throwable)e2);
        }
    }

    private static BundleSettingDto.Setting convertParamFromAnnotation(Class<?> paramClazz, CubeParam defineParam, Log logger) {
        BundleSettingDto.Setting paramSetting = new BundleSettingDto.Setting();
        paramSetting.setCode(paramClazz.getCanonicalName());
        paramSetting.setViewVisible(BundleSettingDto.ViewVisible.YES.getValue());
        paramSetting.setCapabilityCode(defineParam.capabilityCode());
        paramSetting.setName(defineParam.name());
        paramSetting.setDescr(defineParam.descr());
        Integer optionSourceType = defineParam.optionSourceType().getValue();
        paramSetting.setOptionSourceType(optionSourceType);
        paramSetting.setAbortPolicy(CubeExt.AbortPolicy.BREAK.getValue());
        paramSetting.setExecMechanism(CubeExt.ExecMechanism.SERIAL.getValue());
        CubeParam.Option[] paramOptions = defineParam.options();
        CubeParam.Tabular tabular = defineParam.tabular();
        CubeParam.Tabular.Header[] headers = tabular.headers();
        boolean isTabular = false;
        if (paramOptions.length > 0 && headers.length > 0) {
            throw new RuntimeException("\u8868\u683c\u7c7b\u578b\u914d\u7f6e\u9879\u65e0\u9700Options\u8d4b\u503c:" + paramClazz.getCanonicalName());
        }
        if (paramOptions.length == 0 && headers.length > 0) {
            isTabular = true;
        }
        Type parameterizedType = Util.readValueType(paramClazz);
        if (isTabular) {
            ConfScanMojo.handleTabular(paramSetting, tabular);
        } else if (CubeParam.OptionSourceType.DYNAMIC_FROM_BUNDLE.equals(optionSourceType) || CubeParam.OptionSourceType.DYNAMIC_FROM_DICT.equals(optionSourceType) || parameterizedType instanceof ParameterizedType || parameterizedType == Boolean.class || paramOptions.length > 0) {
            ConfScanMojo.handleSelect(paramClazz, paramSetting, parameterizedType, paramOptions);
        } else {
            ConfScanMojo.handleInput(paramClazz, paramSetting, parameterizedType);
        }
        return paramSetting;
    }

    private static void handleTabular(BundleSettingDto.Setting paramSetting, CubeParam.Tabular tabular) {
        CubeParam.Tabular.Header[] headers = tabular.headers();
        CubeParam.Tabular.Row[] rows = tabular.rows();
        paramSetting.setEditType(tabular.choice() ? BundleSettingDto.EditType.SELECT.getValue() : BundleSettingDto.EditType.INPUT.getValue());
        paramSetting.setValueType(BundleSettingDto.ValueType.TABULAR.getValue());
        paramSetting.setValueScope("");
        paramSetting.setIsMultiChoice(BundleSettingDto.MultiChoice.YES.getValue());
        TabularDto tabularDto = new TabularDto();
        ArrayList<TabularDto.Header> headerList = new ArrayList<TabularDto.Header>();
        for (CubeParam.Tabular.Header header : headers) {
            TabularDto.Header h = new TabularDto.Header();
            h.setCode(header.code());
            h.setName(header.name());
            h.setRemark(header.remark());
            headerList.add(h);
        }
        tabularDto.setHeaders(headerList);
        List<TabularDto.Row> rowList = Arrays.stream(rows).map(line -> {
            TabularDto.Row row = new TabularDto.Row();
            HashMap<String, String> key2ValueMap = new HashMap<String, String>();
            for (CubeParam.Tabular.ColumnValue key2Value : line.columnValues()) {
                key2ValueMap.put(key2Value.key(), key2Value.value());
            }
            row.setValues(key2ValueMap);
            return row;
        }).collect(Collectors.toList());
        tabularDto.setRows(ConfScanMojo.convertDynTabularField(paramSetting.getEditType(), rowList));
        paramSetting.setDefaultValue(JSONObject.toJSONString((Object)tabularDto));
    }

    private static List<Object> convertDynTabularField(Integer editType, List<TabularDto.Row> rowList) {
        ArrayList<Object> viewRows = new ArrayList<Object>();
        for (TabularDto.Row row : rowList) {
            ArrayList<DynaProperty> props = new ArrayList<DynaProperty>();
            props.add(new DynaProperty("sort", Integer.class));
            props.add(new DynaProperty("isSelected", Integer.class));
            for (String key : row.getValues().keySet()) {
                DynaProperty dynaProperty = new DynaProperty(key, String.class);
                props.add(dynaProperty);
            }
            BasicDynaClass dynaClass = new BasicDynaClass("tabular", null, props.toArray(new DynaProperty[0]));
            BasicDynaBean tabular = new BasicDynaBean((DynaClass)dynaClass);
            tabular.set("sort", null);
            if (editType.equals(BundleSettingDto.EditType.INPUT.getValue())) {
                tabular.set("isSelected", (Object)1);
            } else {
                tabular.set("isSelected", (Object)0);
            }
            for (String key : row.getValues().keySet()) {
                tabular.set(key, (Object)row.getValues().get(key));
            }
            viewRows.add(JSONObject.parse((String)JSONObject.toJSONString((Object)tabular.getMap())));
        }
        return viewRows;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void handleSelect(Class<?> paramClazz, BundleSettingDto.Setting paramSetting, Type parameterizedType, CubeParam.Option[] paramOptions) {
        int valueType;
        int isMultiChoice;
        if (parameterizedType instanceof ParameterizedType) {
            if (!Collection.class.isAssignableFrom((Class)((ParameterizedType)parameterizedType).getRawType())) throw new RuntimeException(paramClazz.getCanonicalName() + "ICubeParam\u6cdb\u578b\u7c7b\u578b\u4e3a\u9009\u62e9\u65f6,\u53ef\u4ee5\u4e3aInteger,Long,Double,BigDecimal,Date,String,BooleanList<Integer>,List<Long>,List<Double>,List<BigDecimal>,List<Date>,List<String>,List<Boolean>");
            isMultiChoice = BundleSettingDto.MultiChoice.YES.getValue();
            valueType = BundleSettingDto.ValueType.ENUM.getValue();
        } else if (parameterizedType == Boolean.class) {
            isMultiChoice = BundleSettingDto.MultiChoice.NO.getValue();
            valueType = BundleSettingDto.ValueType.BOOLEAN.getValue();
        } else {
            if (parameterizedType != String.class && parameterizedType != Integer.class && parameterizedType != Long.class && parameterizedType != Double.class && parameterizedType != BigDecimal.class && parameterizedType != Date.class) throw new RuntimeException(paramClazz.getCanonicalName() + "ICubeParam\u6cdb\u578b\u7c7b\u578b\u4e3a\u9009\u62e9\u65f6,\u53ef\u4ee5\u4e3aInteger,Long,Double,BigDecimal,Date,String,BooleanList<Integer>,List<Long>,List<Double>,List<BigDecimal>,List<Date>,List<String>,List<Boolean>");
            isMultiChoice = BundleSettingDto.MultiChoice.NO.getValue();
            valueType = BundleSettingDto.ValueType.ENUM.getValue();
        }
        paramSetting.setIsMultiChoice(isMultiChoice);
        paramSetting.setValueType(valueType);
        paramSetting.setEditType(BundleSettingDto.EditType.SELECT.getValue());
        paramSetting.setValueScope("");
        List<BundleSettingDto.Option> settingOptions = Arrays.stream(paramOptions).map(option -> {
            BundleSettingDto.Option settingOption = new BundleSettingDto.Option();
            settingOption.setSettingCode(paramSetting.getCode());
            settingOption.setCode(option.code());
            settingOption.setValue(option.value());
            settingOption.setName(option.name());
            settingOption.setDescr(option.descr());
            settingOption.setIsDefault(option.isDefault() ? 1 : 0);
            return settingOption;
        }).collect(Collectors.toList());
        if (BundleSettingDto.ValueType.BOOLEAN.equals(paramSetting.getValueType()) && settingOptions.size() == 0) {
            BundleSettingDto.Option trueOption = new BundleSettingDto.Option();
            trueOption.setSettingCode(paramSetting.getCode());
            trueOption.setCode("true");
            trueOption.setName("true");
            trueOption.setValue("true");
            BundleSettingDto.Option falseOption = new BundleSettingDto.Option();
            falseOption.setSettingCode(paramSetting.getCode());
            falseOption.setCode("false");
            falseOption.setName("false");
            falseOption.setValue("false");
            settingOptions.add(trueOption);
            settingOptions.add(falseOption);
        }
        paramSetting.setOptions(settingOptions);
    }

    private static void handleInput(Class<?> paramClazz, BundleSettingDto.Setting paramSetting, Type parameterizedType) {
        int valueType;
        paramSetting.setEditType(BundleSettingDto.EditType.INPUT.getValue());
        if (parameterizedType == Integer.class || parameterizedType == Long.class) {
            valueType = BundleSettingDto.ValueType.INTEGER.getValue();
        } else if (parameterizedType == BigDecimal.class || parameterizedType == Double.class || parameterizedType == Float.class) {
            valueType = BundleSettingDto.ValueType.DECIMAL.getValue();
        } else if (parameterizedType == Date.class) {
            valueType = BundleSettingDto.ValueType.DATE.getValue();
        } else if (parameterizedType == String.class) {
            valueType = BundleSettingDto.ValueType.STRING.getValue();
        } else if (parameterizedType == TimeSlotDto.class) {
            valueType = BundleSettingDto.ValueType.TIME_SLOT.getValue();
        } else {
            throw new RuntimeException(paramClazz.getCanonicalName() + "ICubeParam\u6cdb\u578b\u7c7b\u578b\u4e3a\u8f93\u5165\u65f6,\u503c\u7c7b\u578b\u53ea\u53ef\u4ee5\u662fInteger,BigDecimal,Date,String,TimeSlot");
        }
        paramSetting.setValueType(valueType);
        paramSetting.setDefaultValue("");
        paramSetting.setValueScope("");
    }

    private static BundleSettingDto.Setting convertParamFromInterface(Class<?> paramClazz, Log logger) {
        BundleSettingDto.Setting paramSetting = new BundleSettingDto.Setting();
        paramSetting.setCode(paramClazz.getCanonicalName());
        paramSetting.setViewVisible(BundleSettingDto.ViewVisible.YES.getValue());
        paramSetting.setCapabilityCode("");
        paramSetting.setOptionSourceType(CubeParam.OptionSourceType.STATIC.getValue());
        paramSetting.setAbortPolicy(CubeExt.AbortPolicy.BREAK.getValue());
        paramSetting.setExecMechanism(CubeExt.ExecMechanism.SERIAL.getValue());
        try {
            Method method = paramClazz.getDeclaredMethod("description", null);
            if (method.isDefault()) {
                Object target = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{paramClazz}, (proxy, m, arguments) -> null);
                Object o = ConfScanMojo.invokeDefaultMethod(target, method);
                paramSetting.setDescr(o.toString());
                paramSetting.setName(o.toString());
            }
        }
        catch (Exception e) {
            logger.error((CharSequence)e.getMessage());
        }
        Type parameterizedType = Util.readValueType(paramClazz);
        if (parameterizedType == List.class || parameterizedType == Set.class) {
            paramSetting.setEditType(BundleSettingDto.EditType.SELECT.getValue());
            paramSetting.setIsMultiChoice(BundleSettingDto.MultiChoice.YES.getValue());
            Class componentType = Util.getComponentType((Type)parameterizedType);
            paramSetting.setValueType(componentType == Boolean.class ? BundleSettingDto.ValueType.BOOLEAN.getValue() : BundleSettingDto.ValueType.ENUM.getValue());
        } else if (parameterizedType == Boolean.class) {
            paramSetting.setEditType(BundleSettingDto.EditType.SELECT.getValue());
            paramSetting.setIsMultiChoice(BundleSettingDto.MultiChoice.NO.getValue());
            paramSetting.setValueType(BundleSettingDto.ValueType.BOOLEAN.getValue());
            BundleSettingDto.Option trueOption = new BundleSettingDto.Option();
            trueOption.setSettingCode(paramSetting.getCode());
            trueOption.setCode("true");
            trueOption.setName("true");
            trueOption.setValue("true");
            BundleSettingDto.Option falseOption = new BundleSettingDto.Option();
            falseOption.setSettingCode(paramSetting.getCode());
            falseOption.setCode("false");
            falseOption.setName("false");
            falseOption.setValue("false");
            paramSetting.setOptions(Arrays.asList(trueOption, falseOption));
        } else {
            int valueType;
            paramSetting.setEditType(BundleSettingDto.EditType.INPUT.getValue());
            paramSetting.setIsMultiChoice(BundleSettingDto.MultiChoice.NO.getValue());
            if (parameterizedType == Integer.class || parameterizedType == Long.class) {
                valueType = BundleSettingDto.ValueType.INTEGER.getValue();
            } else if (parameterizedType == BigDecimal.class || parameterizedType == Double.class || parameterizedType == Float.class) {
                valueType = BundleSettingDto.ValueType.DECIMAL.getValue();
            } else if (parameterizedType == Date.class) {
                valueType = BundleSettingDto.ValueType.DATE.getValue();
            } else if (parameterizedType == String.class) {
                valueType = BundleSettingDto.ValueType.STRING.getValue();
            } else {
                throw new RuntimeException(paramClazz.getCanonicalName() + "\u7f16\u8f91\u7c7b\u578b\u4e3a\u8f93\u5165\u65f6,\u503c\u7c7b\u578b\u53ef\u4ee5\u662fInteger,BigDecimal,Date,String");
            }
            paramSetting.setValueType(valueType);
            paramSetting.setDefaultValue("");
            paramSetting.setValueScope("");
        }
        if (!StringUtils.hasText((String)paramSetting.getName())) {
            paramSetting.setName(paramClazz.getSimpleName());
        }
        return paramSetting;
    }

    private static BundleSettingDto.Setting convertExtPointFromAnnotation(Class<?> extPointClazz, CubeExt cubeExt) {
        BundleSettingDto.Setting extPointSetting = new BundleSettingDto.Setting();
        extPointSetting.setCode(extPointClazz.getCanonicalName());
        extPointSetting.setViewVisible(BundleSettingDto.ViewVisible.YES.getValue());
        extPointSetting.setCapabilityCode(cubeExt.capabilityCode());
        extPointSetting.setName(cubeExt.name());
        extPointSetting.setDescr(cubeExt.descr());
        extPointSetting.setExecMechanism(cubeExt.execMechanism().getValue());
        extPointSetting.setAbortPolicy(cubeExt.abortPolicy().getValue());
        extPointSetting.setIsMultiChoice(cubeExt.multiChoice().getValue());
        extPointSetting.setEditType(BundleSettingDto.EditType.SELECT.getValue());
        extPointSetting.setValueType(BundleSettingDto.ValueType.SPI_EXT.getValue());
        extPointSetting.setOptionSourceType(CubeParam.OptionSourceType.STATIC.getValue());
        return extPointSetting;
    }

    private static BundleSettingDto.Setting convertExtPointFromInterface(Class<?> extPointClazz) {
        BundleSettingDto.Setting extPointSetting = new BundleSettingDto.Setting();
        extPointSetting.setCode(extPointClazz.getCanonicalName());
        extPointSetting.setViewVisible(BundleSettingDto.ViewVisible.YES.getValue());
        extPointSetting.setCapabilityCode("");
        extPointSetting.setName(extPointClazz.getSimpleName());
        extPointSetting.setDescr(extPointClazz.getCanonicalName());
        extPointSetting.setExecMechanism(CubeExt.ExecMechanism.SERIAL.getValue());
        extPointSetting.setAbortPolicy(CubeExt.AbortPolicy.BREAK.getValue());
        extPointSetting.setIsMultiChoice(CubeExt.MultiChoice.NO.getValue());
        extPointSetting.setEditType(BundleSettingDto.EditType.SELECT.getValue());
        extPointSetting.setValueType(BundleSettingDto.ValueType.SPI_EXT.getValue());
        extPointSetting.setOptionSourceType(CubeParam.OptionSourceType.STATIC.getValue());
        return extPointSetting;
    }

    private static Object invokeDefaultMethod(Object proxy, Method method) {
        try {
            Object o;
            float version = Float.parseFloat(System.getProperty("java.class.version"));
            if (version <= 52.0f) {
                Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class);
                constructor.setAccessible(true);
                Class<?> clazz = method.getDeclaringClass();
                o = ((MethodHandles.Lookup)constructor.newInstance(clazz)).in(clazz).unreflectSpecial(method, clazz).bindTo(proxy).invokeWithArguments(new Object[0]);
            } else {
                o = MethodHandles.lookup().findSpecial(method.getDeclaringClass(), method.getName(), MethodType.methodType(method.getReturnType(), new Class[0]), method.getDeclaringClass()).bindTo(proxy).invokeWithArguments(new Object[0]);
            }
            return o;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }
}

