/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.maven.plugin.complement.conf;

import com.dtyunxi.cube.maven.plugin.JavaparserUtil;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.logging.Log;

public class AppendUtil {
    private static Map<String, Class> BASE_TYPES = new HashMap<String, Class>();
    private static Map<Class, String> PRIMITIVE_NAMES = new HashMap<Class, String>();
    private static Map<String, CtClass> BASE_CT_TYPES = new HashMap<String, CtClass>();
    private static Map<CtClass, String> CT_TYPES_READ_METHOD = new HashMap<CtClass, String>();
    private static Map<String, String> STR_TYPES_READ_METHOD = new HashMap<String, String>();

    public static final String packCubeAcquireMethodName(String fieldName) {
        char[] cs = fieldName.toCharArray();
        if (cs[0] >= 'a' && cs[0] <= 'z') {
            cs[0] = (char)(cs[0] - 32);
        } else if (cs[0] < 'A' || cs[0] > 'Z') {
            throw new RuntimeException("CubeValue\u4fee\u9970\u7684\u53d8\u91cf,\u53ea\u80fd\u4ee5\u5b57\u6bcd\u5f00\u5934,\u73b0\u5728\u7684\u540d\u79f0\u4e0d\u7b26\u5408\u8981\u6c42:" + fieldName);
        }
        return "cubeAcquire" + String.valueOf(cs);
    }

    public static CtClass fetchFieldCtType(FieldDeclaration fieldDeclaration, ClassPool pool) {
        String resultTypeClassName = ((VariableDeclarator)fieldDeclaration.getVariables().get(0)).getType().asString();
        CtClass ctType = BASE_CT_TYPES.get(resultTypeClassName);
        if (ctType != null) {
            return ctType;
        }
        String canonicalName = resultTypeClassName;
        return AppendUtil.findCtClassByCanonicalName(pool, canonicalName);
    }

    public static CtClass findCtClassByCanonicalName(ClassPool pool, String canonicalName) {
        try {
            return pool.get(canonicalName);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static CtClass fetchCtClass4CompilationUnit(ClassPool pool, CompilationUnit unit) {
        String classCanonicalName = JavaparserUtil.compilationUnit2canonicalName(unit);
        return AppendUtil.findCtClassByCanonicalName(pool, classCanonicalName);
    }

    public static String packConfReaderMethodName(CtClass resultTypeCtClass) {
        String readMethodName = CT_TYPES_READ_METHOD.get(resultTypeCtClass);
        if (StringUtils.isBlank((CharSequence)readMethodName)) {
            return "readString";
        }
        return readMethodName;
    }

    public static String packConfReaderMethodName(String resultType) {
        String readMethodName = STR_TYPES_READ_METHOD.get(resultType);
        if (StringUtils.isBlank((CharSequence)readMethodName)) {
            return "readString";
        }
        return readMethodName;
    }

    public static Class primitive2packed(Class resultType) {
        Class clazz = BASE_TYPES.get(resultType.getSimpleName());
        if (clazz != null) {
            return clazz;
        }
        return resultType;
    }

    public static CtClass[] packCtClassByNames(List<String> typeNames, ClassPool classPool, CompilationUnit unit, Log log) {
        ArrayList<CtClass> collect = new ArrayList<CtClass>();
        for (String typeName : typeNames) {
            CtClass ctClass = null;
            if (ctClass == null) {
                String canonicalName = JavaparserUtil.packCanonicalName(typeName, unit);
                try {
                    ctClass = classPool.get(canonicalName);
                }
                catch (NotFoundException ex) {
                    log.info((CharSequence)(canonicalName + "\u4e0d\u5728class\u8def\u5f84,\u5c1d\u8bd5java.lang\u4e0b\u67e5\u627e"));
                    ctClass = null;
                }
            }
            if (ctClass == null) {
                String langTypeName = "java.lang." + typeName;
                try {
                    ctClass = classPool.get(langTypeName);
                }
                catch (NotFoundException ex) {
                    log.info((CharSequence)(langTypeName + "\u4e0d\u5728java.lang\u8def\u5f84,\u5c1d\u8bd5\u7528\u57fa\u7840\u7c7b\u578b\u67e5\u627e"));
                    ctClass = null;
                }
            }
            if (ctClass == null) {
                try {
                    ctClass = classPool.get(typeName);
                }
                catch (NotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            collect.add(ctClass);
        }
        if (CollectionUtils.isNotEmpty(collect)) {
            return collect.toArray(new CtClass[collect.size()]);
        }
        return new CtClass[0];
    }

    public static String packed2primitiveName(Class resultTypeClass) {
        String resultTypeName = PRIMITIVE_NAMES.get(resultTypeClass);
        if (StringUtils.isEmpty((CharSequence)resultTypeName)) {
            resultTypeName = "String";
        }
        return resultTypeName;
    }

    static {
        BASE_TYPES.put("boolean", Boolean.class);
        BASE_TYPES.put("int", Integer.class);
        BASE_TYPES.put("long", Long.class);
        PRIMITIVE_NAMES.put(Boolean.class, "boolean");
        PRIMITIVE_NAMES.put(Integer.class, "int");
        PRIMITIVE_NAMES.put(Long.class, "long");
        BASE_CT_TYPES.put("boolean", CtClass.booleanType);
        BASE_CT_TYPES.put("int", CtClass.intType);
        BASE_CT_TYPES.put("long", CtClass.longType);
        CT_TYPES_READ_METHOD.put(CtClass.booleanType, "readBoolean");
        CT_TYPES_READ_METHOD.put(CtClass.intType, "readInt");
        CT_TYPES_READ_METHOD.put(CtClass.longType, "readLong");
        STR_TYPES_READ_METHOD.put("boolean", "readBoolean");
        STR_TYPES_READ_METHOD.put(Boolean.class.getSimpleName(), "readBoolean");
        STR_TYPES_READ_METHOD.put("int", "readInt");
        STR_TYPES_READ_METHOD.put(Integer.class.getSimpleName(), "readInt");
        STR_TYPES_READ_METHOD.put("long", "readLong");
        STR_TYPES_READ_METHOD.put(Long.class.getSimpleName(), "readLong");
    }
}

