/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.maven.plugin.scan.mojo;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.enhance.generator.annotation.Capability;
import com.dtyunxi.cube.maven.plugin.scan.constant.Constants;
import com.dtyunxi.cube.maven.plugin.scan.dto.ApiBatchDto;
import com.dtyunxi.cube.maven.plugin.scan.dto.ApiInfoDto;
import com.dtyunxi.cube.maven.plugin.scan.dto.MethodInfoDto;
import com.dtyunxi.cube.maven.plugin.scan.dto.ParamDetailInfoDto;
import com.dtyunxi.cube.maven.plugin.scan.dto.ParamInfoDto;
import com.dtyunxi.cube.maven.plugin.scan.util.CenterNameUtil;
import com.dtyunxi.cube.maven.plugin.scan.util.ConfigUtils;
import com.dtyunxi.cube.maven.plugin.scan.util.ParamUtil;
import com.dtyunxi.cube.maven.plugin.scan.util.ScanClassUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.util.JacksonUtil;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Mojo(name="gen-api-json", requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.COMPILE)
public class ApiScanMojo
extends AbstractMojo {
    private static final String BACKSLASH = "/";
    private static final String BODY = "body";
    private static final String PATH = "query";
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="${project.compileClasspathElements}", readonly=true, required=true)
    private List<String> compileClasspathElements;
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="${project.parent.groupId}", readonly=true)
    private String parentGroupId;
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="${project.parent.artifactId}", readonly=true)
    private String parentArtifactId;
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="${project.name}", readonly=true)
    private String name;
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="${project.version}", readonly=true)
    private String version;
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="${project.build.outputDirectory}", readonly=true)
    private String outputDirectory;
    @org.apache.maven.plugins.annotations.Parameter(defaultValue="${project}", readonly=true)
    private MavenProject mavenProject;
    private List<String> apiInterfaceList = new ArrayList<String>();
    private static final String APISUFFIX = "Api";
    private URLClassLoader classLoader = Objects.requireNonNull((URLClassLoader)ClassUtils.getDefaultClassLoader(), "\u7c7b\u52a0\u8f7d\u5668\u4e3a\u7a7a");
    private Log log;

    public ApiScanMojo() {
        this.log = this.getLog();
    }

    public ApiScanMojo(MavenProject mavenProject, Log log) {
        this.mavenProject = mavenProject;
        if (null == this.compileClasspathElements) {
            try {
                this.compileClasspathElements = mavenProject.getCompileClasspathElements();
            }
            catch (DependencyResolutionRequiredException e) {
                throw new RuntimeException("\u83b7\u53d6CompileClasspathElements\u5f02\u5e38", e);
            }
        }
        this.outputDirectory = mavenProject.getBuild().getOutputDirectory();
        this.parentGroupId = mavenProject.getParent().getGroupId();
        this.parentArtifactId = mavenProject.getParent().getArtifactId();
        this.name = mavenProject.getName();
        this.version = mavenProject.getVersion();
        this.log = log;
    }

    public void execute() {
        ApiBatchDto apiBatchDto = null;
        try {
            apiBatchDto = this.reflectApiScan();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        if (null == apiBatchDto) {
            return;
        }
        File file = new File(this.outputDirectory + File.separator + Constants.RESOURCE_API_LOCATION);
        File parentFile = file.getParentFile();
        if (parentFile.exists() || parentFile.mkdirs()) {
            try {
                FileCopyUtils.copy((byte[])Objects.requireNonNull(JacksonUtil.toJson((Object)((Object)apiBatchDto))).getBytes(StandardCharsets.UTF_8), (File)file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.log.info((CharSequence)("\u751f\u6210" + Constants.RESOURCE_API_LOCATION + "\u6587\u4ef6\u6210\u529f"));
        }
    }

    private List<Class> getClz() {
        this.compileClasspathElements.forEach(e -> ConfigUtils.addURLToClassLoad(this.classLoader, e));
        return this.compileClasspathElements.stream().filter(classpath -> new File((String)classpath).isDirectory()).flatMap(classpath -> ConfigUtils.getClasses(new File((String)classpath).getAbsolutePath().length(), new File((String)classpath), this.classLoader).stream()).collect(Collectors.toList());
    }

    private ApiBatchDto reflectApiScan() throws ClassNotFoundException {
        List<Class> clzzs = this.getClz();
        List<Class> apiClasses = ScanClassUtil.filterClzByCondition(clzzs, APISUFFIX);
        if (CollectionUtils.isEmpty(apiClasses)) {
            return null;
        }
        clzzs.removeAll(apiClasses);
        Map<String, Class> clzNameMap = clzzs.stream().collect(Collectors.toMap(Class::getName, v -> v, (k1, k2) -> k1));
        ApiBatchDto apiBatchDto = this.getApiDetail(apiClasses, clzNameMap);
        return apiBatchDto;
    }

    private ApiBatchDto getApiDetail(List<Class> classes, Map<String, Class> clzNameMap) throws ClassNotFoundException {
        String centerName = CenterNameUtil.getCenterName(this.mavenProject.getResources());
        ApiBatchDto apiBatchDto = new ApiBatchDto();
        apiBatchDto.setGroupId(this.parentGroupId);
        apiBatchDto.setArtifactId(this.parentArtifactId);
        apiBatchDto.setCenterCode(this.parentArtifactId);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)centerName)) {
            apiBatchDto.setCenterName(this.name);
        } else {
            apiBatchDto.setCenterName(centerName);
        }
        apiBatchDto.setVersion(this.version);
        ArrayList<ApiBatchDto.ApiList> apiList = new ArrayList<ApiBatchDto.ApiList>();
        Class currentClz = null;
        Class dataLimitFunctionClass = this.getDataLimitAnnotationClass();
        try {
            Iterator<Class> iterator = classes.iterator();
            while (iterator.hasNext()) {
                Class c;
                currentClz = c = iterator.next();
                ApiBatchDto.ApiList apiGroup = new ApiBatchDto.ApiList();
                FeignClient feignClient = c.getAnnotation(FeignClient.class);
                String groupUrl = null;
                if (feignClient == null) continue;
                groupUrl = feignClient.path();
                Api api = c.getAnnotation(Api.class);
                String groupName = null;
                String groupDesc = null;
                if (null != api && api.tags().length > 0) {
                    groupName = api.tags()[0];
                    groupDesc = api.tags()[0];
                }
                apiGroup.setGroupCode(c.getCanonicalName());
                apiGroup.setGroupName(groupName);
                apiGroup.setGroupDesc(groupDesc);
                Method[] methods = c.getMethods();
                ArrayList<ApiBatchDto.ApiList.PathList> paths = new ArrayList<ApiBatchDto.ApiList.PathList>();
                for (Method m : methods) {
                    Capability capability;
                    String apiName = null;
                    String apiDesc = null;
                    String capabilityCode = null;
                    ApiOperation apiOperation = m.getAnnotation(ApiOperation.class);
                    if (apiOperation != null) {
                        apiName = apiOperation.value();
                        apiDesc = apiOperation.notes();
                    } else {
                        apiName = m.getName();
                    }
                    Integer isDataLimitFunction = Constants.NOT_DATA_LIMIT_FUNCTION;
                    String beanName = null;
                    String methodName = null;
                    String desc = null;
                    if (null != dataLimitFunctionClass && m.isAnnotationPresent(dataLimitFunctionClass)) {
                        this.log.debug((CharSequence)(m.getName() + " \u662f\u6570\u636e\u6743\u9650\u51fd\u6570"));
                        isDataLimitFunction = Constants.IS_DATA_LIMIT_FUNCTION;
                        Object funcAnnotation = m.getAnnotation(dataLimitFunctionClass);
                        beanName = this.getAnnotationValue(funcAnnotation, "beanName");
                        if (StringUtils.isEmpty((Object)beanName)) {
                            beanName = c.getName();
                        }
                        methodName = this.getAnnotationValue(funcAnnotation, "funcName");
                        desc = this.getAnnotationValue(funcAnnotation, "desc");
                    }
                    if (null != (capability = m.getAnnotation(Capability.class))) {
                        capabilityCode = capability.capabilityCode();
                    }
                    Map<Class, Map<String, Class>> genericRealParamTypeMap = this.getTheGeneric(c);
                    Parameter[] parameters = m.getParameters();
                    List<ApiBatchDto.ApiList.PathList.Param> requestParams = this.getReqParam(parameters, clzNameMap, genericRealParamTypeMap);
                    String reqDemo = this.getReqParamDemo(requestParams);
                    ApiBatchDto.ApiList.PathList.Param respParam = this.getRealResp(m, genericRealParamTypeMap, clzNameMap);
                    List<ApiBatchDto.ApiList.PathList> resultApiDtos = this.getApiMsgByUrl(m, groupUrl);
                    for (ApiBatchDto.ApiList.PathList dto : resultApiDtos) {
                        dto.setApiName(apiName);
                        dto.setApiDesc(apiDesc);
                        dto.setRequestParams(requestParams);
                        dto.setRequestDemo(reqDemo);
                        dto.setResponseParam(respParam);
                        dto.setCapabilityCode(capabilityCode);
                        dto.setDataLimitFunc(isDataLimitFunction);
                        dto.setBeanName(beanName);
                        dto.setFuncName(methodName);
                        dto.setFuncDesc(desc);
                    }
                    paths.addAll(resultApiDtos);
                }
                apiGroup.setPaths(paths);
                apiList.add(apiGroup);
            }
        }
        catch (Throwable e) {
            this.log.error((CharSequence)e.getMessage(), e);
            this.log.info((CharSequence)("\u53d1\u751f\u9519\u8bef\u65f6\uff0c\u5f53\u524d\u7c7b\uff1a" + currentClz.getName()));
        }
        apiBatchDto.setApiList(apiList);
        return apiBatchDto;
    }

    private Class getDataLimitAnnotationClass() {
        Class<?> clz = null;
        try {
            clz = Class.forName("com.dtyunxi.annotation.DataLimitCalcFunc");
        }
        catch (ClassNotFoundException e) {
            this.log.warn((CharSequence)"\u5f53\u524d\u7cfb\u7edf\u6ca1\u6709\u52a0\u8f7d\u51fd\u6570\u6ce8\u89e3\u7c7b:com.dtyunxi.annotation.DataLimitCalcFunc");
        }
        return clz;
    }

    private String getAnnotationValue(Object functionAnnotationObject, String annotationMethodName) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> dataLimitFunctionClass = functionAnnotationObject.getClass();
        Method beanNameMethod = dataLimitFunctionClass.getDeclaredMethod(annotationMethodName, new Class[0]);
        beanNameMethod.setAccessible(true);
        Object beanNameObject = beanNameMethod.invoke(functionAnnotationObject, new Object[0]);
        if (null != beanNameObject) {
            return (String)beanNameObject;
        }
        return null;
    }

    private List<ApiBatchDto.ApiList.PathList> getApiMsgByUrl(Method m, String groupUrl) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)groupUrl)) {
            groupUrl = "";
        }
        ArrayList<ApiBatchDto.ApiList.PathList> resultApiDtos = new ArrayList<ApiBatchDto.ApiList.PathList>();
        Integer isDeprecated = 0;
        String apiUrl = null;
        String apiMethod = null;
        String[] urls = null;
        if (null != m.getAnnotation(Deprecated.class)) {
            isDeprecated = 1;
        }
        if (null != m.getAnnotation(PostMapping.class)) {
            PostMapping post = m.getAnnotation(PostMapping.class);
            urls = post.value();
            apiMethod = "POST";
        } else if (null != m.getAnnotation(PutMapping.class)) {
            PutMapping put = m.getAnnotation(PutMapping.class);
            urls = put.value();
            apiMethod = "PUT";
        } else if (null != m.getAnnotation(DeleteMapping.class)) {
            DeleteMapping delete = m.getAnnotation(DeleteMapping.class);
            urls = delete.value();
            apiMethod = "DELETE";
        } else if (null != m.getAnnotation(GetMapping.class)) {
            GetMapping get = m.getAnnotation(GetMapping.class);
            urls = get.value();
            apiMethod = "GET";
        } else if (null != m.getAnnotation(RequestMapping.class)) {
            RequestMapping requestMapping = m.getAnnotation(RequestMapping.class);
            urls = requestMapping.value();
            if (!ObjectUtils.isEmpty((Object[])requestMapping.method())) {
                apiMethod = requestMapping.method()[0].toString();
            }
        }
        if (null == urls || urls.length == 0) {
            ApiBatchDto.ApiList.PathList apiDto = new ApiBatchDto.ApiList.PathList();
            apiDto.setMethod(apiMethod);
            apiDto.setPath(groupUrl);
            apiDto.setDeprecate(isDeprecated);
            resultApiDtos.add(apiDto);
            return resultApiDtos;
        }
        for (String url : urls) {
            ApiBatchDto.ApiList.PathList apiDto = new ApiBatchDto.ApiList.PathList();
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)groupUrl) && groupUrl.endsWith(BACKSLASH)) {
                groupUrl = groupUrl.substring(0, groupUrl.length() - 1);
            }
            if (url.startsWith(BACKSLASH)) {
                url = url.substring(1);
            }
            apiUrl = groupUrl + BACKSLASH + url;
            apiDto.setMethod(apiMethod);
            apiDto.setPath(apiUrl);
            apiDto.setDeprecate(isDeprecated);
            resultApiDtos.add(apiDto);
        }
        return resultApiDtos;
    }

    private Map<Class, Map<String, Class>> getTheGeneric(Class clz) throws ClassNotFoundException {
        HashMap<Class, Map<String, Class>> genericClz2genericNameAndRealType = new HashMap<Class, Map<String, Class>>();
        try {
            HashMap interfaceClz2ParamList = new HashMap();
            Class<?>[] parentInterfaceArray = clz.getInterfaces();
            if (null == parentInterfaceArray || parentInterfaceArray.length == 0) {
                return genericClz2genericNameAndRealType;
            }
            for (Class<?> parentInterface : parentInterfaceArray) {
                TypeVariable<Class<?>>[] parentIntefaceTypeParamNameArray = parentInterface.getTypeParameters();
                if (parentIntefaceTypeParamNameArray == null || parentIntefaceTypeParamNameArray.length <= 0) continue;
                List parentIntefaceTypeParamNameList = Arrays.stream(parentIntefaceTypeParamNameArray).map(TypeVariable::getName).collect(Collectors.toList());
                interfaceClz2ParamList.put(parentInterface, parentIntefaceTypeParamNameList);
            }
            HashMap interfaceClz2RealParam = new HashMap();
            Type[] genericParamTypeArray = clz.getGenericInterfaces();
            for (Type generic : genericParamTypeArray) {
                Type[] realType;
                ArrayList realParamTypeList = new ArrayList();
                ParameterizedType genericParameterizedType = (ParameterizedType)generic;
                for (Type t : realType = genericParameterizedType.getActualTypeArguments()) {
                    Class<?> realTypeClz = Class.forName(t.getTypeName());
                    if (realTypeClz == null) {
                        realTypeClz = this.classLoader.loadClass(t.getTypeName());
                    }
                    realParamTypeList.add(realTypeClz);
                }
                if (CollectionUtils.isEmpty(realParamTypeList)) continue;
                String genericClzName = genericParameterizedType.getRawType().getTypeName();
                Class<?> genericClz = Class.forName(genericClzName);
                if (genericClz == null) {
                    try {
                        genericClz = this.classLoader.loadClass(genericClzName);
                    }
                    catch (Exception e) {
                        this.log.info((CharSequence)e.getMessage());
                    }
                }
                interfaceClz2RealParam.put(genericClz, realParamTypeList);
            }
            for (Class c : interfaceClz2ParamList.keySet()) {
                HashMap genericName2RealType = new HashMap();
                List paramList = (List)interfaceClz2ParamList.get(c);
                List realTypeList = (List)interfaceClz2RealParam.get(c);
                for (int index = 0; index < paramList.size(); ++index) {
                    genericName2RealType.put(paramList.get(index), realTypeList.get(index));
                }
                genericClz2genericNameAndRealType.put(c, genericName2RealType);
            }
        }
        catch (Exception e) {
            this.log.warn((CharSequence)("\u83b7\u53d6\u6cdb\u578b\u63a5\u53e3\u9519\u8bef\uff1a" + e.getMessage()));
        }
        return genericClz2genericNameAndRealType;
    }

    private ApiBatchDto.ApiList.PathList.Param processReqParamDto(Class dtoClass, Map<String, Class> clzNameMap, Set<String> processedClz) {
        if (null == processedClz) {
            processedClz = new HashSet<String>();
        }
        if (processedClz.contains(dtoClass.getName())) {
            return null;
        }
        processedClz.add(dtoClass.getName());
        ApiBatchDto.ApiList.PathList.Param param = new ApiBatchDto.ApiList.PathList.Param();
        param.setName(dtoClass.getName());
        param.setType(dtoClass.getTypeName());
        if (dtoClass.getAnnotation(ApiModel.class) != null) {
            ApiModel apiModel = dtoClass.getAnnotation(ApiModel.class);
            if (!StringUtils.isEmpty((Object)apiModel.description())) {
                param.setName(apiModel.description());
            }
            param.setDescription(apiModel.description());
        }
        HashSet<Object> fieldSet = new HashSet<Object>();
        HashSet<String> fieldNameSet = new HashSet<String>();
        for (Class clazz = dtoClass; clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fields = clazz.getDeclaredFields();
            for (Field f : fields) {
                if (fieldNameSet.contains(f.getName())) continue;
                fieldNameSet.add(f.getName());
                fieldSet.add(f);
            }
        }
        ArrayList<ApiBatchDto.ApiList.PathList.Param> properties = new ArrayList<ApiBatchDto.ApiList.PathList.Param>();
        for (Field field : fieldSet) {
            if (field.getType().equals(dtoClass)) continue;
            ApiBatchDto.ApiList.PathList.Param propertie = new ApiBatchDto.ApiList.PathList.Param();
            propertie.setName(field.getName());
            String fieldType = field.getAnnotatedType().getType().getTypeName();
            Class fieldClz = clzNameMap.get(fieldType);
            if (!"extFields".equals(field.getName())) {
                if (fieldClz != null) {
                    ApiBatchDto.ApiList.PathList.Param fieldWithProperties = this.processReqParamDto(fieldClz, clzNameMap, processedClz);
                    if (null != fieldWithProperties) {
                        CubeBeanUtils.copyProperties((Object)propertie, (Object)fieldWithProperties, (String[])new String[]{"name"});
                    }
                } else if (Map.class.isAssignableFrom(field.getType()) || Collection.class.isAssignableFrom(field.getType())) {
                    ParameterizedType parameterizedType = null;
                    boolean toParameterizedTypeSuccess = true;
                    try {
                        parameterizedType = (ParameterizedType)field.getAnnotatedType().getType();
                    }
                    catch (Exception e) {
                        this.log.info((CharSequence)(e.getMessage() + ":" + field.getType().getName()));
                        toParameterizedTypeSuccess = false;
                    }
                    if (toParameterizedTypeSuccess) {
                        Set<String> fieldPropertieTypeSet = null;
                        try {
                            fieldPropertieTypeSet = ParamUtil.getRealParamType(parameterizedType);
                            ArrayList<ApiBatchDto.ApiList.PathList.Param> fieldProperties = new ArrayList<ApiBatchDto.ApiList.PathList.Param>();
                            for (String fieldPropertieType : fieldPropertieTypeSet) {
                                ApiBatchDto.ApiList.PathList.Param fieldWithProperties;
                                Class fieldPropertieClz = clzNameMap.get(fieldPropertieType);
                                if (null == fieldPropertieClz || fieldPropertieClz.equals(dtoClass) || null == (fieldWithProperties = this.processReqParamDto(fieldPropertieClz, clzNameMap, processedClz))) continue;
                                fieldProperties.add(fieldWithProperties);
                            }
                            propertie.setProperties(fieldProperties);
                        }
                        catch (ClassNotFoundException e) {
                            this.log.info((CharSequence)e.getMessage());
                        }
                    }
                } else if (field.getType().isArray()) {
                    Type paramArrayType = field.getAnnotatedType().getType();
                    String realType = paramArrayType.getTypeName().replaceAll("\\[]", "");
                    Class realArrayClz = clzNameMap.get(realType);
                    if (null == realArrayClz || realArrayClz.equals(dtoClass)) continue;
                    ApiBatchDto.ApiList.PathList.Param fieldWithProperties = this.processReqParamDto(realArrayClz, clzNameMap, processedClz);
                    if (null != fieldWithProperties) {
                        CubeBeanUtils.copyProperties((Object)propertie, (Object)fieldWithProperties, (String[])new String[]{"name"});
                    }
                }
            }
            propertie.setType(field.getAnnotatedType().getType().getTypeName());
            if (field.getAnnotation(ApiModelProperty.class) != null) {
                ApiModelProperty apiModelProperty = field.getAnnotation(ApiModelProperty.class);
                String description = apiModelProperty.value();
                if (!StringUtils.isEmpty((Object)description)) {
                    description = description.replace("\"", "\\\"");
                }
                propertie.setDescription(description);
            }
            if (field.getAnnotation(NotNull.class) != null) {
                propertie.setRequired(true);
                param.setRequired(true);
            } else {
                propertie.setRequired(false);
            }
            properties.add(propertie);
        }
        param.setProperties(properties);
        return param;
    }

    private ApiBatchDto.ApiList.PathList.Param getRealResp(Method m, Map<Class, Map<String, Class>> genericRealParamTypeMap, Map<String, Class> clzNameMap) {
        block7: {
            Type paramRsp = m.getGenericReturnType();
            Class<?> genericClz = m.getDeclaringClass();
            try {
                if (genericClz != null && genericRealParamTypeMap.get(genericClz) != null && genericRealParamTypeMap.get(genericClz).size() > 0) {
                    Map<String, Class> genericParam = genericRealParamTypeMap.get(genericClz);
                    if (genericParam != null && genericParam.size() > 0) {
                        Type genericReturnType = m.getGenericReturnType();
                        ParameterizedType type = (ParameterizedType)genericReturnType;
                        Type[] actualTypeArguments = type.getActualTypeArguments();
                        String actualTypeName = actualTypeArguments[0].getTypeName();
                        if (actualTypeName != null && genericParam.get(actualTypeName) != null) {
                            ApiBatchDto.ApiList.PathList.Param respParam = new ApiBatchDto.ApiList.PathList.Param();
                            respParam.setName(actualTypeName);
                            respParam.setType(genericParam.get(actualTypeName).getName());
                            if (clzNameMap.get(genericParam.get(actualTypeName).getName()) != null) {
                                Class<?> resp = Class.forName(genericParam.get(actualTypeName).getName());
                                HashSet<String> processedClz = new HashSet<String>();
                                ApiBatchDto.ApiList.PathList.Param proc = this.processReqParamDto(resp, clzNameMap, processedClz);
                                CubeBeanUtils.copyProperties((Object)respParam, (Object)proc, (String[])new String[]{"name", "type"});
                            }
                            return respParam;
                        }
                        ApiBatchDto.ApiList.PathList.Param respNull = new ApiBatchDto.ApiList.PathList.Param();
                        respNull.setName(actualTypeName);
                        respNull.setType(actualTypeName);
                        return respNull;
                    }
                    break block7;
                }
                Type[] params = null;
                if (paramRsp instanceof ParameterizedType) {
                    ParameterizedType type = (ParameterizedType)paramRsp;
                    params = type.getActualTypeArguments();
                    ApiBatchDto.ApiList.PathList.Param respParam = this.getRespParam(params, clzNameMap);
                    respParam.setName(paramRsp.getTypeName());
                    respParam.setType(paramRsp.getTypeName());
                    return respParam;
                }
                params = new Type[]{paramRsp};
                ApiBatchDto.ApiList.PathList.Param respParam = this.getRespParam(params, clzNameMap);
                return respParam;
            }
            catch (Exception e) {
                this.log.error((CharSequence)(m.getName() + " \u8fd4\u56de\u53c2\u6570\u7684\u83b7\u53d6\u9519\u8bef" + e.getMessage()), (Throwable)e);
            }
        }
        return null;
    }

    private ApiBatchDto.ApiList.PathList.Param getRespParam(Type[] params, Map<String, Class> clzNameMap) throws ClassNotFoundException {
        ApiBatchDto.ApiList.PathList.Param respNull;
        ApiBatchDto.ApiList.PathList.Param respParam = new ApiBatchDto.ApiList.PathList.Param();
        ArrayList<ApiBatchDto.ApiList.PathList.Param> properties = new ArrayList<ApiBatchDto.ApiList.PathList.Param>();
        Class clz = null;
        if (params[0] instanceof ParameterizedType) {
            ParameterizedType genericParameterizedType = (ParameterizedType)params[0];
            Type[] types = genericParameterizedType.getActualTypeArguments();
            clz = this.getClassByType(types[0]);
        }
        HashSet<String> processedClz = new HashSet<String>();
        if (clz != null) {
            ParameterizedType pageInfoType;
            if (PageInfo.class.isAssignableFrom(clz)) {
                pageInfoType = (ParameterizedType)params[0];
                Type[] childrenType = pageInfoType.getActualTypeArguments();
                if (childrenType[0].getClass().isAssignableFrom(ParameterizedType.class)) {
                    ParameterizedType childrenParameterizedType = (ParameterizedType)childrenType[0];
                    Set<String> realRespClzNameSet = ParamUtil.getRealParamType(childrenParameterizedType);
                    List<ApiBatchDto.ApiList.PathList.Param> childrenProperties = this.getParamFieldDetail(realRespClzNameSet, clzNameMap, processedClz);
                    properties.addAll(childrenProperties);
                } else {
                    clz = clzNameMap.get(childrenType[0].getTypeName());
                    if (clz == null) {
                        try {
                            clz = ClassUtils.forName((String)childrenType[0].getTypeName(), (ClassLoader)this.classLoader);
                        }
                        catch (Exception e) {
                            this.log.info((CharSequence)e.getMessage());
                        }
                        if (null != clz && clz.isArray()) {
                            Type paramArrayType = childrenType[0];
                            String realType = paramArrayType.getTypeName().replaceAll("\\[]", "");
                            Class realArrayClz = ClassUtils.forName((String)realType, (ClassLoader)this.classLoader);
                            ApiBatchDto.ApiList.PathList.Param chilidrenParam = this.processReqParamDto(realArrayClz, clzNameMap, processedClz);
                            properties.add(chilidrenParam);
                        }
                    } else {
                        ApiBatchDto.ApiList.PathList.Param chilidrenParam = this.processReqParamDto(clz, clzNameMap, processedClz);
                        properties.add(chilidrenParam);
                    }
                }
                respParam.setProperties(properties);
            } else if (Collection.class.isAssignableFrom(clz) || Map.class.isAssignableFrom(clz)) {
                ParameterizedType collectionType = (ParameterizedType)params[0];
                Set<String> realRespClzNameSet = ParamUtil.getRealParamType(collectionType);
                List<ApiBatchDto.ApiList.PathList.Param> childrenProperties = this.getParamFieldDetail(realRespClzNameSet, clzNameMap, processedClz);
                properties.addAll(childrenProperties);
                respParam.setProperties(properties);
            } else if (clz.isArray()) {
                pageInfoType = (ParameterizedType)params[0];
                Type[] paramArrayType = pageInfoType.getActualTypeArguments();
                String realType = paramArrayType[0].getTypeName().replaceAll("\\[]", "");
                Class realArrayClz = ClassUtils.forName((String)realType, (ClassLoader)this.classLoader);
                respParam = this.processReqParamDto(realArrayClz, clzNameMap, processedClz);
                respParam.setName(paramArrayType[0].getTypeName());
                respParam.setType(paramArrayType[0].getTypeName());
            } else if (clz != null) {
                respParam = this.processReqParamDto(clz, clzNameMap, processedClz);
            } else {
                clz = clzNameMap.get(params[0].getTypeName());
                if (clz == null) {
                    respNull = new ApiBatchDto.ApiList.PathList.Param();
                    respNull.setName(params[0].getTypeName());
                    respNull.setType(params[0].getTypeName());
                    return respNull;
                }
                respParam = this.processReqParamDto(clz, clzNameMap, processedClz);
            }
        } else {
            clz = clzNameMap.get(params[0].getTypeName());
            if (clz == null) {
                respNull = new ApiBatchDto.ApiList.PathList.Param();
                respNull.setName(params[0].getTypeName());
                respNull.setType(params[0].getTypeName());
                return respNull;
            }
            respParam = this.processReqParamDto(clz, clzNameMap, processedClz);
        }
        return respParam;
    }

    private List<ApiBatchDto.ApiList.PathList.Param> getReqParam(Parameter[] parameters, Map<String, Class> clzNameMap, Map<Class, Map<String, Class>> genericRealParamTypeMap) throws ClassNotFoundException {
        ArrayList<ApiBatchDto.ApiList.PathList.Param> requestParams = new ArrayList<ApiBatchDto.ApiList.PathList.Param>();
        for (Parameter parameter : parameters) {
            ApiBatchDto.ApiList.PathList.Param requestParam;
            Boolean required;
            String paramType;
            block20: {
                Annotation[] annotations;
                paramType = PATH;
                required = false;
                for (Annotation paramAnnotation : annotations = parameter.getAnnotations()) {
                    if (paramAnnotation.annotationType().equals(RequestBody.class)) {
                        RequestBody requestBody = (RequestBody)paramAnnotation;
                        paramType = BODY;
                        required = requestBody.required();
                        break;
                    }
                    if (paramAnnotation.annotationType().equals(PathVariable.class)) {
                        PathVariable pathVariable = (PathVariable)paramAnnotation;
                        required = pathVariable.required();
                        break;
                    }
                    if (paramAnnotation.annotationType().equals(SpringQueryMap.class)) {
                        required = false;
                        break;
                    }
                    if (!paramAnnotation.annotationType().equals(RequestParam.class)) continue;
                    RequestParam r = (RequestParam)paramAnnotation;
                    required = r.required();
                    break;
                }
                requestParam = new ApiBatchDto.ApiList.PathList.Param();
                requestParam.setName(parameter.getName());
                HashSet<String> processedClz = new HashSet<String>();
                try {
                    String realParamType = parameter.getAnnotatedType().getType().getTypeName();
                    Class reqParamClz = clzNameMap.get(realParamType);
                    if (reqParamClz != null) {
                        requestParam = this.processReqParamDto(reqParamClz, clzNameMap, processedClz);
                        requestParam.setName(parameter.getName());
                        requestParam.setType(parameter.getType().getName());
                        break block20;
                    }
                    if (Map.class.isAssignableFrom(parameter.getType()) || Collection.class.isAssignableFrom(parameter.getType())) {
                        ParameterizedType parameterizedType = null;
                        boolean toParameterizedTypeSuccess = true;
                        try {
                            parameterizedType = (ParameterizedType)parameter.getParameterizedType();
                        }
                        catch (Exception e) {
                            this.log.info((CharSequence)(e.getMessage() + ":" + parameter.getType().getName()));
                            toParameterizedTypeSuccess = false;
                        }
                        if (toParameterizedTypeSuccess) {
                            Set<String> paramTypeSet = ParamUtil.getRealParamType(parameterizedType);
                            List<ApiBatchDto.ApiList.PathList.Param> properties = this.getParamFieldDetail(paramTypeSet, clzNameMap, processedClz);
                            requestParam.setType(realParamType);
                            requestParam.setProperties(properties);
                        } else {
                            requestParam.setType(parameter.getType().getName());
                            requestParam.setProperties(new ArrayList<ApiBatchDto.ApiList.PathList.Param>());
                        }
                        break block20;
                    }
                    if (parameter.getType().isArray()) {
                        Type paramArrayType = parameter.getAnnotatedType().getType();
                        String realType = paramArrayType.getTypeName().replaceAll("\\[]", "");
                        Class realArrayClz = ClassUtils.forName((String)realType, (ClassLoader)this.classLoader);
                        requestParam = this.processReqParamDto(realArrayClz, clzNameMap, processedClz);
                        requestParam.setName(paramArrayType.getTypeName());
                        requestParam.setType(paramArrayType.getTypeName());
                    } else {
                        Class genericParamClz = null;
                        if (genericRealParamTypeMap != null && genericRealParamTypeMap.size() > 0) {
                            Type type = parameter.getParameterizedType();
                            if (type.getClass().isAssignableFrom(ParameterizedType.class)) {
                                ParameterizedType parameterizedType = (ParameterizedType)type;
                                type = parameterizedType.getRawType();
                            }
                            String typeName = type.getTypeName();
                            TypeVariable typeVariable = (TypeVariable)type;
                            Object genericDeclaration = typeVariable.getGenericDeclaration();
                            Class genericClzz = (Class)genericDeclaration;
                            Map<String, Class> genericParam = genericRealParamTypeMap.get(genericClzz);
                            genericParamClz = genericParam.get(typeName);
                        }
                        if (genericParamClz != null) {
                            if (clzNameMap.get(genericParamClz.getName()) != null) {
                                requestParam = this.processReqParamDto(genericParamClz, clzNameMap, processedClz);
                            }
                            requestParam.setType(genericParamClz.getName());
                        } else {
                            requestParam.setType(parameter.getType().getName());
                            requestParam.setDescription(parameter.getName());
                        }
                    }
                }
                catch (Exception e) {
                    this.log.info((CharSequence)("\u8bf7\u6c42\u53c2\u6570\u7684\u83b7\u53d6\u9519\u8bef" + e.getMessage()));
                    this.log.info((CharSequence)("\u8bf7\u6c42\u53c2\u6570\u7684\u83b7\u53d6\u9519\u8bef\u65f6\uff0c\u53c2\u6570\u7c7b\u4e3a\uff1a" + parameter.getAnnotatedType().getType().getTypeName()));
                }
            }
            requestParam.setParamType(paramType);
            requestParam.setRequired(required);
            requestParams.add(requestParam);
        }
        return requestParams;
    }

    private List<ApiBatchDto.ApiList.PathList.Param> getParamFieldDetail(Set<String> paramClzNameSet, Map<String, Class> clzNameMap, Set<String> processedClz) throws ClassNotFoundException {
        ArrayList<ApiBatchDto.ApiList.PathList.Param> paramFieldDetails = new ArrayList<ApiBatchDto.ApiList.PathList.Param>();
        for (String paramClzName : paramClzNameSet) {
            Class c = clzNameMap.get(paramClzName);
            if (null != c) {
                ApiBatchDto.ApiList.PathList.Param resultParam = this.processReqParamDto(c, clzNameMap, processedClz);
                paramFieldDetails.add(resultParam);
                continue;
            }
            ApiBatchDto.ApiList.PathList.Param paramNull = new ApiBatchDto.ApiList.PathList.Param();
            paramNull.setName(paramClzName);
            paramNull.setType(paramClzName);
            paramFieldDetails.add(paramNull);
        }
        return paramFieldDetails;
    }

    private Class getClassByType(Type type) {
        Class<?> clz = null;
        String className = null;
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            clz = (Class)pt.getRawType();
            className = clz.getName();
        } else if (type instanceof TypeVariable) {
            TypeVariable tType = (TypeVariable)type;
            className = tType.getGenericDeclaration().toString();
        } else {
            clz = (Class<?>)type;
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank(className)) {
            try {
                clz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return clz;
    }

    private String getReqParamDemo(List<ApiBatchDto.ApiList.PathList.Param> requestParams) {
        if (CollectionUtils.isEmpty(requestParams)) {
            return null;
        }
        return JSONObject.toJSONString(this.getParamDemoDetails(requestParams));
    }

    private Map<String, Object> getParamDemoDetails(List<ApiBatchDto.ApiList.PathList.Param> requestParams) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (ApiBatchDto.ApiList.PathList.Param param : requestParams) {
            List<ApiBatchDto.ApiList.PathList.Param> properties = param.getProperties();
            if (CollectionUtils.isEmpty(properties)) {
                map.put(param.getName(), this.cutPre(param.getType()));
                continue;
            }
            Map<Object, Object> propertyMap = new HashMap();
            if (param.getType().startsWith("java.util.List<") || param.getType().startsWith("List<") || param.getType().startsWith("Set<") || param.getType().startsWith("java.util.Set<") || param.getType().startsWith("java.util.Collection<") || param.getType().startsWith("Collection<")) {
                ApiBatchDto.ApiList.PathList.Param subTypeParam = properties.get(0);
                properties = new ArrayList<ApiBatchDto.ApiList.PathList.Param>();
                List<ApiBatchDto.ApiList.PathList.Param> subTypePros = subTypeParam.getProperties();
                if (CollectionUtils.isEmpty(subTypePros)) {
                    map.put(param.getName(), "[]");
                } else {
                    properties.addAll(subTypePros);
                }
                propertyMap = this.getParamDemoDetails(properties);
            } else if (param.getType().startsWith("Map<") || param.getType().startsWith("java.util.Map<")) {
                for (ApiBatchDto.ApiList.PathList.Param mapPro : properties) {
                    List<ApiBatchDto.ApiList.PathList.Param> subTypePros = mapPro.getProperties();
                    if (CollectionUtils.isEmpty(subTypePros)) continue;
                    Map<String, Object> subPropertyMap = this.getParamDemoDetails(subTypePros);
                    propertyMap.put(this.cutPre(mapPro.getType()), subPropertyMap);
                }
            } else {
                propertyMap = this.getParamDemoDetails(properties);
            }
            if (param.getType().startsWith("java.util.List<") || param.getType().startsWith("List<") || param.getType().startsWith("Set<") || param.getType().startsWith("java.util.Set<")) {
                String value = "[" + JSONObject.toJSONString(propertyMap) + "]";
                map.put(param.getName(), value);
                continue;
            }
            map.put(param.getName(), propertyMap);
        }
        return map;
    }

    private String cutPre(String str) {
        String[] strArray;
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)str)) {
            return str;
        }
        if (str.contains("RestResponse")) {
            str = str.substring(str.indexOf("RestResponse") + 13);
            str = str.substring(0, str.length() - 1);
        }
        StringBuilder sb = new StringBuilder();
        for (String s : strArray = str.trim().split("<")) {
            if (!(s.contains("<") || s.contains(".") || s.contains(","))) {
                sb.append(s).append("<");
                continue;
            }
            if (!s.contains("<") && s.contains(",")) {
                String[] cs;
                for (String c : cs = s.trim().split(",")) {
                    if (c.contains(".")) {
                        c = c.substring(c.lastIndexOf(".") + 1);
                    }
                    sb.append(c).append(",");
                }
                sb.deleteCharAt(sb.length() - 1);
                sb.append("<");
                continue;
            }
            if (s.contains("<") || !s.contains(".")) continue;
            s = s.substring(s.lastIndexOf(".") + 1);
            sb.append(s).append("<");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    private void apiScanService() {
        try {
            String classesPath = this.loadJar();
            this.makeApiList(new File(classesPath));
            List<ApiInfoDto> apiInfoDtoList = this.makeApiInfoDto();
            this.createDescFile(apiInfoDtoList);
        }
        catch (Exception e) {
            System.out.println("error-" + e.getMessage());
            e.printStackTrace();
        }
    }

    private void makeApiList(File file) {
        if (!file.exists()) {
            return;
        }
        File[] files = file.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    this.makeApiList(f);
                    continue;
                }
                if (!f.getName().contains(APISUFFIX)) continue;
                StringBuilder className = new StringBuilder(f.getAbsolutePath());
                className = new StringBuilder(className.substring(className.indexOf("com")));
                String[] classNameInfo = className.toString().split("[\\\\|/]");
                className = new StringBuilder();
                for (String info : classNameInfo) {
                    className.append(info).append(".");
                }
                this.apiInterfaceList.add(className.toString().replaceAll(".class.", ""));
            }
        }
    }

    private String loadJar() throws Exception {
        String classesPath = null;
        URLClassLoader classLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        for (String jarPath : this.compileClasspathElements) {
            if (classesPath == null && jarPath.contains("classes")) {
                classesPath = jarPath;
            }
            ConfigUtils.addURLToClassLoad(classLoader, jarPath);
        }
        return classesPath;
    }

    private List<ApiInfoDto> makeApiInfoDto() throws Exception {
        ArrayList<ApiInfoDto> apiInfoDtoList = new ArrayList<ApiInfoDto>(this.apiInterfaceList.size());
        for (String className : this.apiInterfaceList) {
            Class<?> clazz = Class.forName(className);
            apiInfoDtoList.add(this.apiScanProcess(clazz));
        }
        return apiInfoDtoList;
    }

    private void createDescFile(List<ApiInfoDto> apiScanDtoList) throws IOException {
        String str = System.getProperty("user.dir");
        String applicationName = str.substring(str.lastIndexOf(File.separator) + 1);
        File file = new File(str + File.separator + applicationName + "service" + File.separator + "src" + File.separator + "main" + File.separator + "resources" + File.separator + "apiScan.json");
        File parentFile = file.getParentFile();
        if (!parentFile.exists() && parentFile.mkdirs()) {
            this.log.info((CharSequence)("\u751f\u6210" + parentFile.getName() + "\u76ee\u5f55\u6210\u529f"));
        }
        FileCopyUtils.copy((byte[])Objects.requireNonNull(JacksonUtil.toJson(apiScanDtoList)).getBytes(StandardCharsets.UTF_8), (File)file);
    }

    private List<String> makeAllClass(File file) {
        ArrayList<String> allClassPath = new ArrayList<String>();
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                if (files != null) {
                    for (File f : files) {
                        if (f.isDirectory()) {
                            allClassPath.addAll(this.makeAllClass(f));
                            continue;
                        }
                        if (!f.getName().endsWith(".class")) continue;
                        allClassPath.add(f.getAbsolutePath());
                    }
                }
            } else if (file.isFile() && file.getName().endsWith(".class")) {
                allClassPath.add(file.getAbsolutePath());
            }
        }
        return allClassPath;
    }

    private ApiInfoDto apiScanProcess(Class clazz) throws Exception {
        Method[] methods;
        ApiInfoDto apiInfoDto = new ApiInfoDto();
        String preUri = "";
        for (Annotation annotation : clazz.getAnnotations()) {
            String aStr = annotation.toString();
            if (aStr.contains(APISUFFIX)) {
                apiInfoDto.setApis((String[])ConfigUtils.invoke(annotation, "tags"));
                continue;
            }
            if (!aStr.contains("FeignClient")) continue;
            preUri = (String)ConfigUtils.invoke(annotation, "path");
            if (!preUri.startsWith(BACKSLASH)) {
                preUri = BACKSLASH + preUri;
            }
            if (!preUri.endsWith(BACKSLASH)) continue;
            preUri = preUri.substring(0, preUri.length() - 1);
        }
        ArrayList<MethodInfoDto> methodInfoDtoList = new ArrayList<MethodInfoDto>();
        for (Method method : methods = clazz.getMethods()) {
            MethodInfoDto methodInfoDto = new MethodInfoDto();
            for (Annotation annotation : method.getAnnotations()) {
                String aStr = annotation.toString();
                if (aStr.contains("ApiOperation")) {
                    methodInfoDto.setValue((String)ConfigUtils.invoke(annotation, "value"));
                    methodInfoDto.setNotes((String)ConfigUtils.invoke(annotation, "notes"));
                }
                if (!aStr.contains("Mapping")) continue;
                String value = ((String[])ConfigUtils.invoke(annotation, "value"))[0];
                if (aStr.contains("GetMapping")) {
                    methodInfoDto.setMethod("GET");
                } else if (aStr.contains("PostMapping")) {
                    methodInfoDto.setMethod("POST");
                } else if (aStr.contains("PutMapping")) {
                    methodInfoDto.setMethod("PUT");
                } else if (aStr.contains("DeleteMapping")) {
                    methodInfoDto.setMethod("DELETE");
                } else {
                    methodInfoDto.setMethod(Arrays.toString((String[])ConfigUtils.invoke(annotation, "method")));
                }
                if (value != null && !value.startsWith(BACKSLASH) && value.length() != 0) {
                    value = BACKSLASH + value;
                }
                methodInfoDto.setUri(preUri + value);
            }
            ArrayList<ParamInfoDto> paramInfoDtoList = new ArrayList<ParamInfoDto>();
            Class<?>[] types = method.getParameterTypes();
            int paramIndex = 0;
            for (Class<?> cl : types) {
                try {
                    ParamInfoDto paramInfoDto = new ParamInfoDto();
                    paramInfoDto.setParamTypeName(cl.getSimpleName());
                    if (cl.getName().indexOf(".") > 0 && !cl.getName().contains("java.lang")) {
                        ArrayList<ParamDetailInfoDto> paramDetailInfoDtoList = new ArrayList<ParamDetailInfoDto>();
                        if (cl.getSimpleName().endsWith("Dto")) {
                            Field[] fields;
                            block6: for (Field field : fields = cl.getDeclaredFields()) {
                                Annotation[] annotations;
                                for (Annotation fA : annotations = field.getAnnotations()) {
                                    String fAStr = fA.toString();
                                    if (!fAStr.contains("ApiModelProperty")) continue;
                                    ParamDetailInfoDto paramDetailInfoDto = new ParamDetailInfoDto();
                                    paramDetailInfoDto.setType(field.getType().getSimpleName());
                                    paramDetailInfoDto.setName((String)ConfigUtils.invoke(fA, "name"));
                                    paramDetailInfoDto.setValue((String)ConfigUtils.invoke(fA, "value"));
                                    paramDetailInfoDtoList.add(paramDetailInfoDto);
                                    continue block6;
                                }
                            }
                            ++paramIndex;
                            paramInfoDto.setParamDetailInfoDtoList(paramDetailInfoDtoList);
                        }
                    } else {
                        Annotation[] tempA;
                        int index = 0;
                        Annotation[][] tempAnnotations = method.getParameterAnnotations();
                        if (tempAnnotations.length > 0 && (tempA = tempAnnotations[paramIndex++]).length > 0) {
                            Annotation annotations = tempA[index++];
                            boolean complete = false;
                            while (!complete) {
                                if (annotations.toString().contains("PathVariable")) {
                                    paramInfoDto.setName((String)ConfigUtils.invoke(annotations, "value"));
                                    paramInfoDto.setRequired((Boolean)ConfigUtils.invoke(annotations, "required"));
                                    complete = true;
                                    continue;
                                }
                                if (annotations.toString().contains("RequestParam")) {
                                    String tempValue = (String)ConfigUtils.invoke(annotations, "value");
                                    if (tempValue == null || tempValue.length() == 0) {
                                        paramInfoDto.setName((String)ConfigUtils.invoke(annotations, "name"));
                                    } else {
                                        paramInfoDto.setName(tempValue);
                                    }
                                    paramInfoDto.setRequired((Boolean)ConfigUtils.invoke(annotations, "required"));
                                    complete = true;
                                    continue;
                                }
                                if (method.getParameterAnnotations()[paramIndex - 1].length <= index) {
                                    complete = true;
                                    continue;
                                }
                                annotations = method.getParameterAnnotations()[paramIndex - 1][index++];
                            }
                        }
                    }
                    paramInfoDtoList.add(paramInfoDto);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            methodInfoDto.setParamInfoDtoList(paramInfoDtoList);
            methodInfoDtoList.add(methodInfoDto);
            apiInfoDto.setMethodInfoDtoList(methodInfoDtoList);
        }
        return apiInfoDto;
    }
}

