/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.maven.plugin.scan.mojo;

import com.dtyunxi.cube.maven.plugin.scan.constant.Constants;
import com.dtyunxi.cube.maven.plugin.scan.dto.DtoJson;
import com.dtyunxi.cube.maven.plugin.scan.util.ConfigUtils;
import com.dtyunxi.cube.maven.plugin.scan.util.FileUtil;
import com.dtyunxi.cube.maven.plugin.scan.util.ParamUtil;
import com.dtyunxi.cube.maven.plugin.scan.util.ScanClassUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.Max;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@Mojo(name="gen-dto-json", requiresDependencyResolution=ResolutionScope.COMPILE, defaultPhase=LifecyclePhase.COMPILE)
public class DtoScanMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.compileClasspathElements}", readonly=true)
    private List<String> compileClasspathElements;
    @Parameter(defaultValue="${project.build.outputDirectory}", readonly=true)
    private String outputDirectory;
    @Parameter(defaultValue="${project.parent.groupId}", readonly=true)
    private String parentGroupId;
    @Parameter(defaultValue="${project.parent.artifactId}", readonly=true)
    private String parentArtifactId;
    @Parameter(defaultValue="${project.version}", readonly=true)
    private String version;
    private static final Integer TRUE = 1;
    private static final String DTOSUFFIX = "Dto";
    private URLClassLoader classLoader = Objects.requireNonNull((URLClassLoader)ClassUtils.getDefaultClassLoader(), "\u7c7b\u52a0\u8f7d\u5668\u4e3a\u7a7a");
    private Log log;

    public DtoScanMojo() {
        this.log = this.getLog();
    }

    public DtoScanMojo(MavenProject mavenProject, Log log) {
        if (null == this.compileClasspathElements) {
            try {
                this.compileClasspathElements = mavenProject.getCompileClasspathElements();
            }
            catch (DependencyResolutionRequiredException e) {
                throw new RuntimeException("\u83b7\u53d6CompileClasspathElements\u5f02\u5e38", e);
            }
        }
        this.outputDirectory = mavenProject.getBuild().getOutputDirectory();
        this.parentGroupId = mavenProject.getParent().getGroupId();
        this.parentArtifactId = mavenProject.getParent().getArtifactId();
        this.version = mavenProject.getVersion();
        this.log = log;
    }

    public void execute() {
        DtoJson dtoJson = null;
        try {
            dtoJson = this.reflectDtoScan();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        if (null == dtoJson) {
            return;
        }
        dtoJson.setArtifactId(this.parentArtifactId);
        dtoJson.setGroupId(this.parentGroupId);
        dtoJson.setVersion(this.version);
        FileUtil.writeFile((Object)dtoJson, this.outputDirectory, Constants.RESOURCE_DTO_LOCATION);
    }

    private DtoJson reflectDtoScan() throws ClassNotFoundException {
        this.compileClasspathElements.forEach(e -> ConfigUtils.addURLToClassLoad(this.classLoader, e));
        List<Class> classes = this.compileClasspathElements.stream().filter(classpath -> new File((String)classpath).isDirectory()).flatMap(classpath -> ConfigUtils.getClasses(new File((String)classpath).getAbsolutePath().length(), new File((String)classpath), this.classLoader).stream()).collect(Collectors.toList());
        List<Class> dtoClzs = ScanClassUtil.filterClzByCondition(classes, DTOSUFFIX);
        return DtoScanMojo.getDtoJson(dtoClzs);
    }

    public static DtoJson getDtoJson(List<Class> dtoClzs) {
        ArrayList<DtoJson.DtoDetail> dtoDetails = new ArrayList<DtoJson.DtoDetail>();
        if (CollectionUtils.isNotEmpty(dtoClzs)) {
            Map<String, Class> clzNameMap = dtoClzs.stream().collect(Collectors.toMap(Class::getName, v -> v, (k1, k2) -> k1));
            for (Class dtoClz : dtoClzs) {
                HashSet<String> processedClz = new HashSet<String>();
                DtoJson.DtoDetail dtoDetail = DtoScanMojo.getDtoDetail(dtoClz, clzNameMap, processedClz);
                dtoDetails.add(dtoDetail);
            }
        } else {
            return null;
        }
        DtoJson dtoJson = new DtoJson();
        dtoJson.setDtos(dtoDetails);
        return dtoJson;
    }

    private static DtoJson.DtoDetail getDtoDetail(Class dtoClass, Map<String, Class> clzNameMap, Set<String> processedClz) {
        if (null == processedClz) {
            processedClz = new HashSet<String>();
        }
        if (processedClz.contains(dtoClass.getName())) {
            return null;
        }
        processedClz.add(dtoClass.getName());
        DtoJson.DtoDetail dtoDetail = new DtoJson.DtoDetail();
        dtoDetail.setName(dtoClass.getSimpleName());
        dtoDetail.setCode(dtoClass.getTypeName());
        if (dtoClass.getAnnotation(ApiModel.class) != null) {
            ApiModel apiModel = dtoClass.getAnnotation(ApiModel.class);
            if (!StringUtils.isEmpty((Object)apiModel.description())) {
                dtoDetail.setName(apiModel.description());
            }
            dtoDetail.setDescr(apiModel.description());
        }
        ArrayList<DtoJson.DtoDetail.Attribute> attributes = new ArrayList<DtoJson.DtoDetail.Attribute>();
        HashSet<Field> fieldSet = new HashSet<Field>();
        HashSet<String> fieldNameSet = new HashSet<String>();
        for (Class clazz = dtoClass; clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fields;
            for (Field f : fields = clazz.getDeclaredFields()) {
                if (fieldNameSet.contains(f.getName())) continue;
                fieldNameSet.add(f.getName());
                fieldSet.add(f);
            }
        }
        try {
            for (Field f : fieldSet) {
                Max maxLength;
                NotNull isNotNull;
                if (f.getType().equals(dtoClass)) continue;
                DtoJson.DtoDetail.Attribute attribute = new DtoJson.DtoDetail.Attribute();
                attribute.setName(f.getName());
                String fieldType = f.getAnnotatedType().getType().getTypeName();
                Class fieldClz = clzNameMap.get(fieldType);
                if (!"extFields".equals(f.getName())) {
                    if (fieldClz != null) {
                        DtoJson.DtoDetail fieldWithAttr = DtoScanMojo.getDtoDetail(fieldClz, clzNameMap, processedClz);
                        if (null != fieldWithAttr) {
                            CubeBeanUtils.copyProperties((Object)attribute, (Object)fieldWithAttr, (String[])new String[]{"name"});
                        }
                    } else if (Map.class.isAssignableFrom(f.getType()) || Collection.class.isAssignableFrom(f.getType())) {
                        ParameterizedType parameterizedType = (ParameterizedType)f.getAnnotatedType().getType();
                        Set<String> fieldPropertieTypeSet = null;
                        try {
                            fieldPropertieTypeSet = ParamUtil.getRealParamType(parameterizedType);
                            ArrayList<DtoJson.DtoDetail> fieldProperties = new ArrayList<DtoJson.DtoDetail>();
                            for (String fieldPropertieType : fieldPropertieTypeSet) {
                                DtoJson.DtoDetail fieldWithProperties;
                                Class fieldPropertieClz = clzNameMap.get(fieldPropertieType);
                                if (null == fieldPropertieClz || fieldPropertieClz.equals(dtoClass) || null == (fieldWithProperties = DtoScanMojo.getDtoDetail(fieldPropertieClz, clzNameMap, processedClz))) continue;
                                fieldProperties.add(fieldWithProperties);
                            }
                            attribute.setAttributes(fieldProperties);
                        }
                        catch (ClassNotFoundException fieldProperties) {}
                    } else if (f.getType().isArray()) {
                        Type paramArrayType = f.getAnnotatedType().getType();
                        String realType = paramArrayType.getTypeName().replaceAll("\\[]", "");
                        Class realArrayClz = clzNameMap.get(realType);
                        if (null == realArrayClz || realArrayClz.equals(dtoClass)) continue;
                        DtoJson.DtoDetail fieldWithAttr = DtoScanMojo.getDtoDetail(realArrayClz, clzNameMap, processedClz);
                        if (null != fieldWithAttr) {
                            CubeBeanUtils.copyProperties((Object)attribute, (Object)fieldWithAttr, (String[])new String[]{"name"});
                        }
                    }
                }
                attribute.setCode(f.getName());
                attribute.setDataType(f.getAnnotatedType().getType().getTypeName());
                ApiModelProperty apiModelProperty = f.getAnnotation(ApiModelProperty.class);
                if (null != apiModelProperty) {
                    attribute.setName(apiModelProperty.value());
                }
                if (null != (isNotNull = f.getAnnotation(NotNull.class))) {
                    attribute.setIsNullable(TRUE);
                }
                if (null != (maxLength = f.getAnnotation(Max.class))) {
                    attribute.setLength(maxLength.value());
                }
                attributes.add(attribute);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        dtoDetail.setAttributes(attributes);
        return dtoDetail;
    }
}

