/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.maven.plugin.scan.mojo;

import com.dtyunxi.cube.enhance.flow.IFlowEntity;
import com.dtyunxi.cube.maven.plugin.scan.constant.Constants;
import com.dtyunxi.cube.maven.plugin.scan.dto.FlowDocDto;
import com.dtyunxi.cube.maven.plugin.scan.util.ConfigUtils;
import com.dtyunxi.util.JacksonUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.springframework.util.ClassUtils;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;

public class FlowDocScanMojo
extends AbstractMojo {
    public static final YAMLMapper yamlMapper = new YAMLMapper();
    private Log log;
    private String outputDirectory;
    private MavenProject mavenProject;

    public FlowDocScanMojo(MavenProject mavenProject, Log log) {
        this.log = log;
        this.mavenProject = mavenProject;
    }

    private static String getDomainFromApplicationYml(URLClassLoader classLoader) throws IOException {
        try (InputStream resourceAsStream = classLoader.getResourceAsStream("application.yml");){
            if (resourceAsStream == null) {
                throw new RuntimeException("\u529f\u80fd\u5305\u57fa\u672c\u4fe1\u606f\u6ca1\u5b9a\u4e49:application.yml\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            JsonNode jsonNode = yamlMapper.readTree(resourceAsStream);
            JsonNode bundleJsonNode = jsonNode.path("bundle");
            if (bundleJsonNode instanceof MissingNode) {
                throw new RuntimeException("\u529f\u80fd\u5305\u57fa\u672c\u4fe1\u606f\u6ca1\u5b9a\u4e49:application.yml\u6587\u4ef6bundle\u8282\u70b9\u914d\u7f6e\u4e0d\u5b58\u5728");
            }
            String domain = bundleJsonNode.path("domain").asText();
            if (!StringUtils.hasText((String)domain)) {
                throw new RuntimeException("\u8bf7\u5148\u5728application.yml\u6587\u4ef6\u914d\u7f6e\u9886\u57df\u7f16\u7801bundle.domain");
            }
            String string = domain;
            return string;
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        List compileClasspathElements;
        this.log = this.getLog();
        try {
            compileClasspathElements = this.mavenProject.getCompileClasspathElements();
        }
        catch (DependencyResolutionRequiredException e2) {
            throw new RuntimeException("\u83b7\u53d6CompileClasspathElements\u5f02\u5e38", e2);
        }
        this.outputDirectory = this.mavenProject.getBuild().getOutputDirectory();
        String groupId = this.mavenProject.getGroupId();
        String artifactId = this.mavenProject.getParent().getArtifactId();
        String version = this.mavenProject.getVersion();
        try {
            URLClassLoader classLoader = Objects.requireNonNull((URLClassLoader)ClassUtils.getDefaultClassLoader(), "\u7c7b\u52a0\u8f7d\u5668\u4e3a\u7a7a");
            compileClasspathElements.forEach(e -> ConfigUtils.addURLToClassLoad(classLoader, e));
            String domain = "all";
            List<FlowDocDto.FlowDoc> flowDocs = compileClasspathElements.stream().filter(classpath -> new File((String)classpath).isDirectory()).flatMap(classpath -> ConfigUtils.getClasses(new File((String)classpath).getAbsolutePath().length(), new File((String)classpath), classLoader).stream()).filter(clazz -> !Modifier.isAbstract(clazz.getModifiers()) && !clazz.isInterface() && IFlowEntity.class.isAssignableFrom((Class<?>)clazz)).map(e -> {
                FlowDocDto.FlowDoc doc = new FlowDocDto.FlowDoc();
                doc.setDomain(domain);
                doc.setCode(domain + "." + e.getName());
                try {
                    IFlowEntity o = (IFlowEntity)e.newInstance();
                    doc.setName(o.getEntityName());
                    doc.setStatusPropDesc(o.getStatusDesc());
                }
                catch (IllegalAccessException | InstantiationException ex) {
                    this.log.error((CharSequence)"\u521d\u59cb\u5316\u6d41\u7a0b\u5b9e\u4f53\u8f6c\u6362\u5f02\u5e38\uff1a", (Throwable)ex);
                }
                return doc;
            }).collect(Collectors.toList());
            FlowDocDto dto = new FlowDocDto();
            dto.setGroupId(groupId);
            dto.setArtifactId(artifactId);
            dto.setVersion(version);
            dto.setFlowDocs(flowDocs);
            this.writeFile(dto, Constants.FLOW_DOC_LOCATION);
        }
        catch (Exception e3) {
            this.log.error((CharSequence)("\u751f\u6210" + Constants.FLOW_DOC_LOCATION + "\u6587\u4ef6\u5931\u8d25"), (Throwable)e3);
        }
    }

    public void writeFile(Object obj, String filepath) throws IOException {
        File file = new File(this.outputDirectory + File.separator + filepath);
        File parentFile = file.getParentFile();
        if (parentFile.exists() || parentFile.mkdirs()) {
            FileCopyUtils.copy((byte[])Objects.requireNonNull(JacksonUtil.toJson((Object)obj)).getBytes(StandardCharsets.UTF_8), (File)file);
            this.log.info((CharSequence)("\u751f\u6210" + Constants.SETTING_OPTION_LOCATION + "\u6587\u4ef6\u6210\u529f"));
        } else {
            this.log.error((CharSequence)("\u521b\u5efa\u76ee\u5f55\u5931\u8d25:" + parentFile.getAbsolutePath()));
        }
    }
}

