/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.maven.plugin.scan.mojo;

import com.dtyunxi.cube.maven.plugin.scan.constant.Constants;
import com.dtyunxi.cube.maven.plugin.scan.dto.BundleBaseDto;
import com.dtyunxi.cube.maven.plugin.scan.mojo.BaseScanMojo;
import com.dtyunxi.cube.maven.plugin.scan.util.ConfigUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class ServiceScanMojo
extends BaseScanMojo {
    private static final String stopCompilingWhenBundleDefinitionMissing = "stop-compiling-when-bundle-definition-missing";
    private static Boolean stopWhenBundleDefinitionMissing = false;
    public static final YAMLMapper yamlMapper = new YAMLMapper();

    public ServiceScanMojo(MavenProject mavenProject, Log log) {
        super(mavenProject, log);
    }

    @Override
    public void execute() {
        try {
            URLClassLoader classLoader = Objects.requireNonNull((URLClassLoader)ClassUtils.getDefaultClassLoader(), "\u7c7b\u52a0\u8f7d\u5668\u4e3a\u7a7a");
            this.compileClasspathElements.stream().filter(classpath -> new File((String)classpath).isDirectory()).forEach(e -> ConfigUtils.addURLToClassLoad(classLoader, e));
            Set artifacts = this.mavenProject.getArtifacts();
            BundleBaseDto bundleBase = this.getInfoFromApplicationYml(classLoader, artifacts);
            bundleBase.setGroupId(this.groupId);
            bundleBase.setArtifactId(this.artifactId);
            bundleBase.setVersion(this.version);
            bundleBase.setCreateTime(new Date());
            this.writeFile(bundleBase, Constants.BASE_LOCATION);
        }
        catch (Exception e2) {
            if (stopWhenBundleDefinitionMissing.booleanValue()) {
                this.log.error((CharSequence)("\u751f\u6210" + Constants.BASE_LOCATION + "\u6587\u4ef6\u5931\u8d25"));
                throw new RuntimeException(e2);
            }
            this.log.warn((CharSequence)("\u751f\u6210" + Constants.BASE_LOCATION + "\u6587\u4ef6\u5931\u8d25\uff0c" + stopCompilingWhenBundleDefinitionMissing + "\u8bbe\u7f6e\u4e3afalse\uff0c\u529f\u80fd\u5305\u7ee7\u7eed\u7f16\u8bd1"));
        }
    }

    private BundleBaseDto getInfoFromApplicationYml(URLClassLoader classLoader, Set<Artifact> artifactSet) throws IOException {
        BundleBaseDto bundleBase = new BundleBaseDto();
        try (InputStream resourceAsStream = classLoader.getResourceAsStream("application.yml");){
            String[] dependencyArray;
            if (resourceAsStream == null) {
                throw new RuntimeException("\u529f\u80fd\u5305\u57fa\u672c\u4fe1\u606f\u6ca1\u5b9a\u4e49:application.yml\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            JsonNode jsonNode = yamlMapper.readTree(resourceAsStream);
            stopWhenBundleDefinitionMissing = jsonNode.path(stopCompilingWhenBundleDefinitionMissing).asBoolean(true);
            JsonNode bundleJsonNode = jsonNode.path("bundle");
            if (bundleJsonNode instanceof MissingNode) {
                throw new RuntimeException("\u529f\u80fd\u5305\u57fa\u672c\u4fe1\u606f\u6ca1\u5b9a\u4e49:application.yml\u6587\u4ef6bundle\u8282\u70b9\u914d\u7f6e\u4e0d\u5b58\u5728");
            }
            StringBuilder sb = new StringBuilder();
            String type = bundleJsonNode.path("type").asText();
            ServiceScanMojo.notEmpty(sb, type, "bundle.type\u4e0d\u80fd\u4e3a\u7a7a");
            ServiceScanMojo.requireIn(sb, type, Arrays.asList("frontend", "backend", "center"), "bundle.type\u7684\u503c\u53ea\u80fd\u4e3afrontend, backend, center\u5176\u4e2d\u4e00\u4e2a");
            bundleBase.setType(type);
            String parent = bundleJsonNode.path("parent").asText();
            ServiceScanMojo.notEmpty(sb, parent, "bundle.parent\u4e0d\u80fd\u4e3a\u7a7a");
            bundleBase.setParentBundle(parent);
            String module = bundleJsonNode.path("module").asText();
            ServiceScanMojo.notEmpty(sb, module, "bundle.module\u4e0d\u80fd\u4e3a\u7a7a");
            bundleBase.setModule(module);
            String application = bundleJsonNode.path("application").asText();
            bundleBase.setApplication(application);
            String domain = bundleJsonNode.path("domain").asText();
            ServiceScanMojo.notEmpty(sb, domain, "bundle.domain\u4e0d\u80fd\u4e3a\u7a7a");
            bundleBase.setDomain(domain);
            String name = bundleJsonNode.path("name").asText();
            ServiceScanMojo.notEmpty(sb, name, "bundle.name\u4e0d\u80fd\u4e3a\u7a7a");
            bundleBase.setName(name);
            String descr = bundleJsonNode.path("descr").asText();
            ServiceScanMojo.notEmpty(sb, descr, "bundle.descr\u4e0d\u80fd\u4e3a\u7a7a");
            bundleBase.setDescr(descr);
            ArrayList<BundleBaseDto.Dependency> dependencyResults = new ArrayList<BundleBaseDto.Dependency>();
            String dependencies = bundleJsonNode.path("dependencies").asText();
            block9: for (String dependency : dependencyArray = org.apache.commons.lang3.StringUtils.split((String)dependencies, (String)",")) {
                ArrayList dependencyList = new ArrayList();
                for (Artifact artifact : artifactSet) {
                    String[] segs;
                    String bundleArtifact = ServiceScanMojo.getBundleArtifact(artifact.getArtifactId());
                    if (!dependency.contains(bundleArtifact)) continue;
                    if (dependency.contains("_") && ((segs = dependency.split("_")).length < 2 || !segs[0].equals(artifact.getGroupId()))) {
                        this.log.info((CharSequence)(dependency + "\u548c" + artifact.getGroupId() + "\u7684\u5206\u7ec4\u4e0d\u4e00\u81f4"));
                        continue;
                    }
                    BundleBaseDto.Dependency dependencyDto = new BundleBaseDto.Dependency();
                    dependencyDto.setGroupId(artifact.getGroupId());
                    dependencyDto.setArtifactId(ServiceScanMojo.getArtifact(artifact.getArtifactId()));
                    dependencyDto.setVersion(artifact.getBaseVersion());
                    dependencyResults.add(dependencyDto);
                    continue block9;
                }
            }
            bundleBase.setDependencies(dependencyResults);
            if (sb.length() > 0) {
                throw new RuntimeException(sb.toString());
            }
        }
        return bundleBase;
    }

    public static String getBundleArtifact(String artifactId) {
        if (StringUtils.isEmpty((Object)artifactId)) {
            return null;
        }
        if (artifactId.startsWith("bundle-")) {
            artifactId = artifactId.replaceFirst("bundle-", "");
        }
        return ServiceScanMojo.removePostfix(artifactId);
    }

    public static String getArtifact(String artifactId) {
        if (StringUtils.isEmpty((Object)artifactId)) {
            return null;
        }
        return ServiceScanMojo.removePostfix(artifactId);
    }

    public static String removePostfix(String artifactId) {
        String[] modulePostfix;
        if (StringUtils.isEmpty((Object)artifactId)) {
            return null;
        }
        for (String postfix : modulePostfix = new String[]{"api", "stdeo", "eo", "conf", "dao", "biz", "service", "web", "event"}) {
            if (!artifactId.endsWith(postfix)) continue;
            return artifactId.substring(0, artifactId.lastIndexOf(postfix));
        }
        return artifactId;
    }

    private static void requireIn(StringBuilder sb, String value, List<String> list, String msg) {
        if (StringUtils.hasText((String)value) && !list.contains(value)) {
            sb.append(msg).append(";");
        }
    }

    private static StringBuilder notEmpty(StringBuilder sb, String value, String msg) {
        if (!StringUtils.hasText((String)value)) {
            sb.append(msg).append(";");
        }
        return sb;
    }
}

