/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.maven.plugin.scan.util;

import com.dtyunxi.cube.maven.plugin.scan.constant.Constants;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class PropertyUtil {
    private static Properties properties = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties(MavenProject mavenProject, Log log) {
        if (null != properties) {
            return properties;
        }
        List modules = mavenProject.getParent().getModules();
        log.info((CharSequence)("\u5f53\u524d\u5de5\u7a0bmaven module\u5217\u8868\uff1a" + StringUtils.join((Iterable)modules, (String)",")));
        Optional<String> serviceModule = modules.stream().filter(module -> module.endsWith("service")).findFirst();
        if (!serviceModule.isPresent()) {
            properties = new Properties();
            log.warn((CharSequence)"\u5f53\u524d\u9879\u76ee\u6ca1\u6709\u5b9a\u4e49service\u6a21\u5757\uff0c\u65e0\u6cd5\u52a0\u8f7dbundle-definition.yml\u6587\u4ef6");
            return properties;
        }
        String serviceModuleName = serviceModule.get();
        File basedir = mavenProject.getParent().getBasedir();
        String attributeFilename = basedir.getAbsolutePath() + File.separator + serviceModuleName + File.separator + Constants.BUNDLE_DEFINITION_LOCATION;
        FileInputStream inputStream = null;
        properties = new Properties();
        try {
            log.info((CharSequence)("\u5f00\u59cb\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6" + attributeFilename));
            inputStream = new FileInputStream(attributeFilename);
            properties.load(inputStream);
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                log.info((CharSequence)("\u914d\u7f6e\u5c5e\u6027key\uff1a" + enumeration.nextElement().toString()));
            }
        }
        catch (IOException e) {
            log.warn((CharSequence)("\u52a0\u8f7d\u6587\u4ef6\u5931\u8d25\uff1a" + Constants.BUNDLE_DEFINITION_LOCATION + ". " + e.getMessage()));
            log.debug((CharSequence)("\u52a0\u8f7d\u6587\u4ef6\u5931\u8d25\uff1a" + Constants.BUNDLE_DEFINITION_LOCATION), (Throwable)e);
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.warn((CharSequence)("\u5173\u95ed\u6587\u4ef6\u5931\u8d25" + attributeFilename));
                }
            }
        }
        return properties;
    }

    public static String replacePlaceHolder(String src) {
        if (null == properties) {
            return src;
        }
        String target = src;
        if (src.startsWith("${") && src.endsWith("}")) {
            String tmp = src.replaceFirst("\\$\\{", "");
            target = properties.getProperty(tmp.substring(0, tmp.lastIndexOf("}")), src);
        }
        return target;
    }
}

