/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.api.permission;

import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.api.permission.ApiPermissionConfig;
import com.dtyunxi.yundt.cube.center.data.api.IApiPermissionQueryApi;
import com.dtyunxi.yundt.cube.center.data.dto.AppInstanceApiAuthStatusReqDto;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.HandlerMapping;

public class ApiPermissionInterceptor
implements HandlerInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(ApiPermissionInterceptor.class);
    private static final String RESP_RESULT = "{\"resultCode\":403,\"resultMsg\":\"not allowed\"}";
    private final String module;
    private final ApiPermissionConfig apiPermissionConfig;
    private IApiPermissionQueryApi apiPermissionQueryApi;

    public ApiPermissionInterceptor(String module, ApiPermissionConfig apiPermissionConfig, IApiPermissionQueryApi apiPermissionQueryApi) {
        this.module = module;
        this.apiPermissionConfig = apiPermissionConfig;
        this.apiPermissionQueryApi = apiPermissionQueryApi;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String handleStatus;
        if (HttpMethod.OPTIONS.name().equalsIgnoreCase(request.getMethod())) {
            return true;
        }
        String apiPath = request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE).toString();
        if (!(!CollectionUtils.isEmpty(this.apiPermissionConfig.getWhiteList()) && this.apiPermissionConfig.getWhiteList().contains(apiPath) || "true".equals(handleStatus = request.getHeader("Api-Permission-Handle")))) {
            AppInstanceApiAuthStatusReqDto appInstanceApiAuthStatusReqDto = new AppInstanceApiAuthStatusReqDto();
            appInstanceApiAuthStatusReqDto.setModuleCode(this.module);
            appInstanceApiAuthStatusReqDto.setPath(apiPath);
            appInstanceApiAuthStatusReqDto.setMethod(request.getMethod());
            RestResponse<Boolean> restResponse = this.apiPermissionQueryApi.queryInstanceApiAuthStatus(appInstanceApiAuthStatusReqDto);
            if ("0".equals(restResponse.getResultCode()) && !((Boolean)restResponse.getData()).booleanValue()) {
                logger.info("moduleCode:{},path:{},method:{} no api access!", new Object[]{this.module, apiPath, request.getMethod()});
                response.setStatus(403);
                PrintWriter out = response.getWriter();
                out.append(RESP_RESULT);
                out.close();
                return false;
            }
            logger.info("moduleCode:{},path:{},method:{} have api access!", new Object[]{this.module, apiPath, request.getMethod()});
        }
        ServiceContext.getContext().setAttachment("Api-Permission-Handle", "true");
        logger.info("set param:{}, value:true in ServiceContext", (Object)"Api-Permission-Handle");
        return true;
    }
}

