/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.resp.permission;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.data.api.IRespPropPermissionQueryApi;
import com.dtyunxi.yundt.cube.center.data.dto.RespPermissionRespDto;
import com.dtyunxi.yundt.cube.center.data.dto.RespPropPermissionReqDto;
import com.dtyunxi.yundt.cube.center.data.enums.PermissionTypeEnum;
import com.dtyunxi.yundt.cube.resp.permission.ISearchApiPermissionParam;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ConditionalOnProperty(value={"api.resp.access.enable"}, havingValue="true")
@ControllerAdvice
@ConditionalOnMissingBean(value={RestResponseAdvice.class})
public class RestResponseAdvice
implements ResponseBodyAdvice {
    private Logger logger = LoggerFactory.getLogger(ResponseBodyAdvice.class);
    private IRespPropPermissionQueryApi respPropPermissionQueryApi;
    @Autowired
    private ISearchApiPermissionParam searchApiPermissionParam;

    public RestResponseAdvice(IRespPropPermissionQueryApi respPropPermissionQueryApi) {
        this.respPropPermissionQueryApi = respPropPermissionQueryApi;
    }

    public boolean supports(MethodParameter methodParameter, Class aClass) {
        return true;
    }

    public Object beforeBodyWrite(Object result, MethodParameter methodParameter, MediaType mediaType, Class aClass, ServerHttpRequest serverHttpRequest, ServerHttpResponse serverHttpResponse) {
        if (result instanceof RestResponse) {
            RespPermissionRespDto respPermissionRespDto;
            List<RespPermissionRespDto.Property> properties;
            long bt = System.currentTimeMillis();
            RestResponse restResponse = (RestResponse)result;
            Object data = restResponse.getData();
            if (data == null) {
                return result;
            }
            if (data instanceof RespPermissionRespDto) {
                return result;
            }
            RespPropPermissionReqDto respPropPermissionReqDto = this.searchApiPermissionParam.process(serverHttpRequest, data);
            RestResponse<RespPermissionRespDto> response = this.respPropPermissionQueryApi.list(respPropPermissionReqDto);
            if (response != null && response.getData() != null && CollectionUtils.isNotEmpty(properties = (respPermissionRespDto = (RespPermissionRespDto)response.getData()).getProperties())) {
                Object object;
                HashMap permissionPropMap = Maps.newHashMap();
                RestResponseAdvice.gatherAccessedPropMap("", properties, permissionPropMap);
                if (MapUtils.isNotEmpty((Map)permissionPropMap) && (object = JSONObject.toJSON((Object)data)) instanceof JSONObject) {
                    JSONObject jsonObject = (JSONObject)object;
                    RestResponseAdvice.removeFromJson("", jsonObject, permissionPropMap);
                    restResponse.setData((Object)jsonObject);
                }
            }
            this.logger.info("\u54cd\u5e94DTO\u5c5e\u6027\u6743\u9650\u8fc7\u6ee4\u8017\u65f6\uff1a{}ms", (Object)(System.currentTimeMillis() - bt));
            return restResponse;
        }
        return result;
    }

    public static void removeFromJson(String parents, JSONObject jsonObject, Map<String, boolean[]> permissionPropMap) {
        if (parents == null) {
            parents = "";
        }
        HashSet keySet = Sets.newHashSet((Iterable)jsonObject.keySet());
        String finalParent = parents;
        keySet.forEach(key -> {
            String permissionMapKey = String.format("%s%s", finalParent, key);
            if (permissionPropMap.containsKey(permissionMapKey)) {
                boolean[] permissions = (boolean[])permissionPropMap.get(permissionMapKey);
                if (permissions == null || permissions[PermissionTypeEnum.ERAD.getValue()]) {
                    Object subJsonObject = jsonObject.get(key);
                    if (subJsonObject instanceof JSONObject) {
                        RestResponseAdvice.removeFromJson(String.format("%s.", permissionMapKey), (JSONObject)subJsonObject, permissionPropMap);
                    } else if (subJsonObject instanceof JSONArray) {
                        JSONArray jsonArray = (JSONArray)subJsonObject;
                        String finalKey = permissionMapKey;
                        jsonArray.stream().filter(json -> json instanceof JSONObject).forEach(subJsonObject2 -> RestResponseAdvice.removeFromJson(String.format("%s.", finalKey), (JSONObject)subJsonObject2, permissionPropMap));
                    }
                } else {
                    jsonObject.remove(key);
                }
            } else {
                jsonObject.remove(key);
            }
        });
    }

    public static void gatherAccessedPropMap(String parent, List<RespPermissionRespDto.Property> properties, Map<String, boolean[]> permissionPropMap) {
        if (parent == null) {
            parent = "";
        }
        for (RespPermissionRespDto.Property property : properties) {
            String key = String.format("%s%s", parent, property.getPropertyCode());
            permissionPropMap.put(key, property.getPermissions());
            if (!CollectionUtils.isNotEmpty(property.getChildrens())) continue;
            RestResponseAdvice.gatherAccessedPropMap(String.format("%s.", key), property.getChildrens(), permissionPropMap);
        }
    }

    public static RespPermissionRespDto.Property buildProperty(String prop, RespPermissionRespDto.Property ... childrens) {
        RespPermissionRespDto.Property property = new RespPermissionRespDto.Property();
        property.setPropertyCode(prop);
        property.setChildrens(Arrays.asList(childrens));
        return property;
    }

    private static void fakeData(List<RemoveProperty> removeProperties) {
        removeProperties.add(RemoveProperty.init("testDto3s"));
        removeProperties.add(RemoveProperty.init("testDto2", RemoveProperty.init("baseDtos", RemoveProperty.init("extFields"), RemoveProperty.init("extension"))));
    }

    private void removeProperties(List<RemoveProperty> removeProperties, JSONObject jsonObject) {
        removeProperties.forEach(removePropertie -> {
            if (CollectionUtils.isEmpty((Collection)((RemoveProperty)removePropertie).childrens)) {
                jsonObject.remove((Object)removePropertie.getKey());
            } else {
                Object subJsonObject = jsonObject.get((Object)removePropertie.getKey());
                if (subJsonObject instanceof JSONObject) {
                    this.removeProperties(removePropertie.getChildrens(), (JSONObject)subJsonObject);
                } else if (subJsonObject instanceof JSONArray) {
                    JSONArray jsonArray = (JSONArray)subJsonObject;
                    jsonArray.stream().filter(json -> json instanceof JSONObject).forEach(subJsonObject2 -> this.removeProperties(removePropertie.getChildrens(), (JSONObject)subJsonObject2));
                }
            }
        });
    }

    public static RestResponse<RespPermissionRespDto> fakePermission() {
        RestResponse response = new RestResponse();
        RespPermissionRespDto respPermissionRespDto = new RespPermissionRespDto();
        respPermissionRespDto.setProperties(RestResponseAdvice.fakePermission0());
        response.setData((Object)respPermissionRespDto);
        return response;
    }

    public static List<RespPermissionRespDto.Property> fakePermission0() {
        LinkedList<RespPermissionRespDto.Property> properties = new LinkedList<RespPermissionRespDto.Property>();
        properties.add(RestResponseAdvice.buildProperty("name", new RespPermissionRespDto.Property[0]));
        properties.add(RestResponseAdvice.buildProperty("testDto2", RestResponseAdvice.buildProperty("grade", new RespPermissionRespDto.Property[0]), RestResponseAdvice.buildProperty("baseDtos", RestResponseAdvice.buildProperty("createPerson", new RespPermissionRespDto.Property[0]).appendPermissions(1, 2), RestResponseAdvice.buildProperty("createTime", new RespPermissionRespDto.Property[0]).appendPermissions(1, 2), RestResponseAdvice.buildProperty("extFields", new RespPermissionRespDto.Property[0]).appendPermissions(0, 2), RestResponseAdvice.buildProperty("extension", new RespPermissionRespDto.Property[0]).appendPermissions(0, 1, 2, 3), RestResponseAdvice.buildProperty("instanceId", new RespPermissionRespDto.Property[0]), RestResponseAdvice.buildProperty("tenantId", new RespPermissionRespDto.Property[0]), RestResponseAdvice.buildProperty("updatePerson", new RespPermissionRespDto.Property[0]), RestResponseAdvice.buildProperty("updateTime", new RespPermissionRespDto.Property[0])).appendPermissions(0, 1, 2)).appendPermissions(0, 2));
        properties.add(RestResponseAdvice.buildProperty("testDto3s", RestResponseAdvice.buildProperty("grade", new RespPermissionRespDto.Property[0]), RestResponseAdvice.buildProperty("baseDtos", RestResponseAdvice.buildProperty("createPerson", new RespPermissionRespDto.Property[0]), RestResponseAdvice.buildProperty("extension", new RespPermissionRespDto.Property[0]), RestResponseAdvice.buildProperty("updatePerson", new RespPermissionRespDto.Property[0]), RestResponseAdvice.buildProperty("instanceId", new RespPermissionRespDto.Property[0]))));
        return properties;
    }

    static class RemoveProperty {
        private String key;
        private List<RemoveProperty> childrens;

        RemoveProperty() {
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public List<RemoveProperty> getChildrens() {
            return this.childrens;
        }

        public void setChildrens(List<RemoveProperty> childrens) {
            this.childrens = childrens;
        }

        public static RemoveProperty init(String key) {
            RemoveProperty removeProperty = new RemoveProperty();
            removeProperty.key = key;
            return removeProperty;
        }

        public static RemoveProperty init(String key, RemoveProperty ... subRemoveProperty) {
            RemoveProperty removeProperty = new RemoveProperty();
            removeProperty.key = key;
            removeProperty.childrens = Arrays.asList(subRemoveProperty);
            return removeProperty;
        }
    }
}

