/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.starter.extension.bid;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BidIdentificationPropPoolPacker {
    private static final Logger logger = LoggerFactory.getLogger(BidIdentificationPropPoolPacker.class);
    private static final Map<Class, Set<Class<? extends BidCoreEntity>>> DTO2CORE_MAP = new HashMap<Class, Set<Class<? extends BidCoreEntity>>>(128);
    private static final Map<Class<? extends BidCoreEntity>, Map<Class, IIdentityPropInputPacker>> INPUT_PACKER_MAP = new HashMap<Class<? extends BidCoreEntity>, Map<Class, IIdentityPropInputPacker>>(128);

    public <I> Set<Class<? extends BidCoreEntity>> queryCoreEntityByDto(I inputDto) {
        Class<?> inputClass = inputDto.getClass();
        Set<Class<? extends BidCoreEntity>> result = DTO2CORE_MAP.get(inputClass);
        if (result == null) {
            result = new HashSet<Class<? extends BidCoreEntity>>(0);
        }
        return result;
    }

    public <I, T extends BidCoreEntity> T packBidCoreEntityByDto(I inputDto, Class<T> outputType) {
        IIdentityPropInputPacker inputPacker = INPUT_PACKER_MAP.get(outputType).get(inputDto.getClass());
        Object result = inputPacker.pack(inputDto);
        logger.debug("\u4e1a\u52a1\u8eab\u4efd\u8bc6\u522b\u5b9e\u4f53:{} -> {}", result.getClass(), result);
        return result;
    }

    public static class OrderPlaceRequestDto {
        private Long storeId;
        private List<Long> itemId;
        private Long skuId;
        private Long categoryId;
        private Long userId;
        private Map<Long, BigDecimal> prices;

        public Long getStoreId() {
            return this.storeId;
        }

        public OrderPlaceRequestDto setStoreId(Long storeId) {
            this.storeId = storeId;
            return this;
        }

        public List<Long> getItemId() {
            return this.itemId;
        }

        public OrderPlaceRequestDto setItemId(List<Long> itemId) {
            this.itemId = itemId;
            return this;
        }

        public Long getSkuId() {
            return this.skuId;
        }

        public OrderPlaceRequestDto setSkuId(Long skuId) {
            this.skuId = skuId;
            return this;
        }

        public Long getCategoryId() {
            return this.categoryId;
        }

        public OrderPlaceRequestDto setCategoryId(Long categoryId) {
            this.categoryId = categoryId;
            return this;
        }

        public Map<Long, BigDecimal> getPrices() {
            return this.prices;
        }

        public OrderPlaceRequestDto setPrices(Map<Long, BigDecimal> prices) {
            this.prices = prices;
            return this;
        }

        public Long getUserId() {
            return this.userId;
        }

        public OrderPlaceRequestDto setUserId(Long userId) {
            this.userId = userId;
            return this;
        }
    }

    public static class TradeBidEntity
    implements BidCoreEntity {
        private Long storeId;
        private LinkedHashSet<Long> categoryPath;
        private String userDomain;
        private String memberModel;

        public Long getStoreId() {
            return this.storeId;
        }

        public TradeBidEntity setStoreId(Long storeId) {
            this.storeId = storeId;
            return this;
        }

        public LinkedHashSet<Long> getCategoryPath() {
            return this.categoryPath;
        }

        public TradeBidEntity setCategoryPath(LinkedHashSet<Long> categoryPath) {
            this.categoryPath = categoryPath;
            return this;
        }

        public String getUserDomain() {
            return this.userDomain;
        }

        public TradeBidEntity setUserDomain(String userDomain) {
            this.userDomain = userDomain;
            return this;
        }

        public String getMemberModel() {
            return this.memberModel;
        }

        public TradeBidEntity setMemberModel(String memberModel) {
            this.memberModel = memberModel;
            return this;
        }
    }

    public static class TradeBidEntityIdentityPropInputPacker
    implements IIdentityPropInputPacker<OrderPlaceRequestDto, TradeBidEntity> {
        @Override
        public TradeBidEntity pack(OrderPlaceRequestDto inputDto) {
            return null;
        }
    }

    public static interface BidCoreEntity {
    }

    public static interface IIdentityPropInputPacker<I, T extends BidCoreEntity> {
        public T pack(I var1);
    }
}

