/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.notifier.api;

import com.dtyunxi.cube.notifier.config.NotifierFeignClientConfig;
import com.dtyunxi.cube.notifier.config.OpenFeignJackDateFormat;
import com.fasterxml.jackson.databind.ObjectMapper;
import feign.Feign;
import feign.Request;
import feign.RequestInterceptor;
import feign.Retryer;
import feign.Target;
import feign.codec.Decoder;
import feign.codec.Encoder;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.internal.CircuitBreakerStateMachine;
import io.vavr.control.Try;
import java.text.DateFormat;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cloud.openfeign.support.ResponseEntityDecoder;
import org.springframework.cloud.openfeign.support.SpringDecoder;
import org.springframework.cloud.openfeign.support.SpringEncoder;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;

public class RawFeignClientCaller<RESPONSE, FEIGN_CLIENT_API> {
    private static Logger logger = LoggerFactory.getLogger(RawFeignClientCaller.class);

    public Decoder feignDecoder() {
        ObjectMapper mapper = Jackson2ObjectMapperBuilder.json().build();
        DateFormat dateFormat = mapper.getDateFormat();
        mapper.setDateFormat((DateFormat)new OpenFeignJackDateFormat(dateFormat));
        HttpMessageConverters converters = new HttpMessageConverters(new HttpMessageConverter[]{new MappingJackson2HttpMessageConverter(mapper)});
        return new ResponseEntityDecoder((Decoder)new SpringDecoder(() -> converters));
    }

    public Encoder feignEncoder() {
        HttpMessageConverters converters = new HttpMessageConverters(new HttpMessageConverter[]{new MappingJackson2HttpMessageConverter()});
        return new SpringEncoder(() -> converters);
    }

    public FEIGN_CLIENT_API getApiInstance(String url, Class<FEIGN_CLIENT_API> apiClass, NotifierFeignClientConfig feignClientConfig) {
        return this.getApiInstance(url, apiClass, feignClientConfig, null);
    }

    public FEIGN_CLIENT_API getApiInstance(String url, Class<FEIGN_CLIENT_API> apiClass, NotifierFeignClientConfig feignClientConfig, RequestInterceptor requestInterceptor) {
        Feign.Builder builder = new Feign.Builder();
        builder.decoder(this.feignDecoder()).encoder(this.feignEncoder()).options(new Request.Options(feignClientConfig.getConnectTimeout(), feignClientConfig.getConnectTimeoutUnit(), feignClientConfig.getReadTimeout(), feignClientConfig.getReadTimeoutUnit(), true)).retryer((Retryer)new Retryer.Default(feignClientConfig.getPeriod(), feignClientConfig.getMaxPeriod(), feignClientConfig.getMaxAttempts()));
        if (requestInterceptor != null) {
            builder.requestInterceptor(requestInterceptor);
        }
        Target.HardCodedTarget target = new Target.HardCodedTarget(apiClass, feignClientConfig.getProtocol() + "://" + url);
        return (FEIGN_CLIENT_API)builder.target((Target)target);
    }

    public RESPONSE process(CallBack<RESPONSE, FEIGN_CLIENT_API> callBack, String ip, int port, Class<FEIGN_CLIENT_API> apiClass) {
        return this.process(callBack, ip, port, apiClass, new NotifierFeignClientConfig());
    }

    public RESPONSE process(CallBack<RESPONSE, FEIGN_CLIENT_API> callBack, String ip, int port, Class<FEIGN_CLIENT_API> apiClass, NotifierFeignClientConfig feignClientConfig) {
        return this.processDefault(callBack, ip + ":" + port, apiClass, feignClientConfig, null, null);
    }

    public RESPONSE process(CallBack<RESPONSE, FEIGN_CLIENT_API> callBack, String ip, int port, Class<FEIGN_CLIENT_API> apiClass, NotifierFeignClientConfig feignClientConfig, RequestInterceptor requestInterceptor) {
        return this.processDefault(callBack, ip + ":" + port, apiClass, feignClientConfig, requestInterceptor, null);
    }

    public RESPONSE process(CallBack<RESPONSE, FEIGN_CLIENT_API> callBack, String domain, Class<FEIGN_CLIENT_API> apiClass) {
        return this.processDefault(callBack, domain, apiClass, new NotifierFeignClientConfig(), null, null);
    }

    public RESPONSE processDefault(CallBack<RESPONSE, FEIGN_CLIENT_API> callBack, String domain, Class<FEIGN_CLIENT_API> apiClass, NotifierFeignClientConfig feignClientConfig, RequestInterceptor requestInterceptor, Function<? super Throwable, RESPONSE> fallback) {
        if (fallback == null) {
            fallback = throwable -> {
                logger.error("\u539f\u751ffeign\u8c03\u7528\u5f02\u5e38\uff1a", throwable);
                return callBack.fallbackResult();
            };
        }
        Function finalFallback = fallback;
        CircuitBreakerConfig circuitBreakerConfig = CircuitBreakerConfig.ofDefaults();
        CircuitBreakerStateMachine circuitBreakerStateMachine = new CircuitBreakerStateMachine(apiClass.getCanonicalName(), circuitBreakerConfig);
        Object feignClientApi = this.getApiInstance(domain, apiClass, feignClientConfig, requestInterceptor);
        return (RESPONSE)Try.ofSupplier((Supplier)circuitBreakerStateMachine.decorateSupplier(() -> callBack.onEvent(feignClientApi))).recover(throwable -> finalFallback.apply((Throwable)throwable)).get();
    }

    public static interface CallBack<RESPONSE, FEIGN_CLIENT_API> {
        public RESPONSE onEvent(FEIGN_CLIENT_API var1);

        default public RESPONSE fallbackResult() {
            return null;
        }
    }
}

