/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.notifier.starter.proxy;

import com.dtyunxi.cube.notifier.starter.publisher.DynamicRulePublisher;
import com.dtyunxi.cube.notifier.starter.rule.IRulePublisherChannel;
import com.dtyunxi.cube.notifier.starter.rule.IRuleType;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublisherProxy<T> {
    private static final Logger logger = LoggerFactory.getLogger(PublisherProxy.class);
    private Map<String, Map<String, DynamicRulePublisher<T>>> map = Maps.newHashMap();

    public void register(IRulePublisherChannel rulePublisherChannel, DynamicRulePublisher<T> rulePublisher) {
        HashMap ruleMap = this.map.get(rulePublisherChannel.channel());
        if (ruleMap == null) {
            ruleMap = Maps.newHashMap();
            this.map.put(rulePublisherChannel.channel(), ruleMap);
        }
        ruleMap.put(rulePublisher.key().type(), rulePublisher);
    }

    public void publish(IRulePublisherChannel rulePublisherChannel, IRuleType ruleType, T rule) {
        try {
            Map<String, DynamicRulePublisher<T>> ruleMap = this.map.get(rulePublisherChannel.channel());
            if (ruleMap != null) {
                DynamicRulePublisher<T> rulePublisher = ruleMap.get(ruleType.type());
                if (rulePublisher == null) {
                    logger.warn("\u53d1\u5e03\u89c4\u5219\u5f02\u5e38\u7ec8\u6b62\uff0c\u4e0d\u5b58\u5728\u9002\u914d\u8be5\u89c4\u5219\u7c7b\u578b[{}]\u7684\u89c4\u5219\u53d1\u5e03\u5668", (Object)ruleType.type());
                } else {
                    rulePublisher.publish(rule);
                }
            } else {
                logger.warn("\u53d1\u5e03\u89c4\u5219\u5f02\u5e38\u7ec8\u6b62\uff0c\u4e0d\u5b58\u5728\u8be5\u6e20\u9053[{}]\u7684\u53d1\u5e03\u5668", (Object)rulePublisherChannel.channel());
            }
        }
        catch (Exception e) {
            logger.warn("\u53d1\u5e03\u89c4\u5219\u5f02\u5e38", (Throwable)e);
        }
    }
}

