/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.notifier.starter.refresher.nacos;

import com.alibaba.csp.sentinel.concurrent.NamedThreadFactory;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import com.dtyunxi.cube.notifier.starter.publisher.nacos.NacosRule;
import com.dtyunxi.cube.notifier.starter.refresher.nacos.AbstractNacosProcessor;
import com.dtyunxi.cube.notifier.starter.refresher.nacos.NacosConfig;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractNacosReceiver {
    protected static Logger logger = LoggerFactory.getLogger(AbstractNacosReceiver.class);
    protected ConfigService configService;
    protected final Listener configListener;
    protected final ExecutorService pool;
    protected final Properties properties;
    protected NacosConfig nacosConfig;
    private boolean firstBoot = true;

    public <T> AbstractNacosReceiver(AbstractNacosProcessor<T> process) {
        this(process.getNacosConfig(), process);
    }

    public <T> AbstractNacosReceiver(NacosConfig nacosConfig, final AbstractNacosProcessor<T> process) {
        this.nacosConfig = nacosConfig;
        this.pool = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1), (ThreadFactory)new NamedThreadFactory("router-nacos-ds-update"), new ThreadPoolExecutor.DiscardOldestPolicy());
        this.properties = nacosConfig.getProperties();
        this.configListener = new Listener(){

            public Executor getExecutor() {
                return AbstractNacosReceiver.this.pool;
            }

            public void receiveConfigInfo(String configInfo) {
                logger.debug("{}-{}\u914d\u7f6e\u5237\u65b0\u901a\u77e5\u5185\u5bb9\uff1a{}", new Object[]{process.getGroupId(), process.getDataId(), configInfo});
                NacosRule nacosRule = (NacosRule)JSONObject.parseObject((String)configInfo, NacosRule.class);
                Object t = JSONObject.parseObject((String)nacosRule.getRule(), process.getType());
                if (t != null) {
                    process.process(t);
                }
            }
        };
        this.initNacosListener(process.getGroupId(), process.getDataId());
    }

    private void initNacosListener(String groupId, String dataId) {
        try {
            this.configService = NacosFactory.createConfigService((Properties)this.properties);
            this.configService.addListener(dataId, groupId, this.configListener);
        }
        catch (Exception e) {
            logger.warn("\u521d\u59cb\u5316\u8def\u7531\u914d\u7f6enacos\u76d1\u542c\u5668\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    public boolean isFirstBoot() {
        return this.firstBoot;
    }
}

