/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.commons.exceptions;

import com.dtyunxi.cube.commons.exceptions.CubeException;
import com.dtyunxi.cube.commons.exceptions.ExceptionCode;
import com.dtyunxi.cube.utils.bean.ObjectHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;

public class ValidateException
extends CubeException {
    private static final long serialVersionUID = 3822431451673643694L;
    private final Map<String, String> errors = new HashMap<String, String>();

    public ValidateException() {
        this(ExceptionCode.VALIDATION_FAIL);
    }

    public ValidateException(String code, String msg) {
        super(code, msg);
    }

    public ValidateException(String msg) {
        super(ExceptionCode.VALIDATION_FAIL.getCode(), msg);
    }

    public ValidateException(ExceptionCode status) {
        super(status.getCode(), status.getMsg());
    }

    public ValidateException(Map<String, String> errors) {
        super(ExceptionCode.VALIDATION_FAIL.getCode(), ExceptionCode.VALIDATION_FAIL.getMsg());
        if (errors != null) {
            this.errors.putAll(errors);
        }
    }

    public ValidateException(ConstraintViolationException ex) {
        super(ExceptionCode.VALIDATION_FAIL.getCode(), ExceptionCode.VALIDATION_FAIL.getMsg());
        this.errors.putAll(this.toMap(ex.getConstraintViolations()));
    }

    public <T> ValidateException(Set<ConstraintViolation<T>> violations) {
        super(ExceptionCode.VALIDATION_FAIL.getCode(), ExceptionCode.VALIDATION_FAIL.getMsg());
        this.errors.putAll(this.toErrorMap(violations));
    }

    public Map<String, String> getErrors() {
        return this.errors;
    }

    public ValidateException addError(String name, String message) {
        this.errors.put(name, message);
        return this;
    }

    private <T> Map<String, String> toErrorMap(Set<ConstraintViolation<T>> violations) {
        HashMap<String, String> errs = new HashMap<String, String>();
        if (!violations.isEmpty()) {
            for (ConstraintViolation<T> it : violations) {
                errs.put(it.getPropertyPath().toString(), it.getMessage());
            }
            this.errors.putAll(this.errors);
        }
        return errs;
    }

    private Map<String, String> toMap(Set<ConstraintViolation<?>> violations) {
        HashMap<String, String> errs = new HashMap<String, String>();
        if (!violations.isEmpty()) {
            for (ConstraintViolation<?> it : violations) {
                errs.put(it.getPropertyPath().toString(), it.getMessage());
            }
            this.errors.putAll(this.errors);
        }
        return errs;
    }

    @Override
    public String getMessage() {
        try {
            return ObjectHelper.bean2Json(this.errors);
        }
        catch (Exception ex) {
            return null;
        }
    }
}

