/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.app;

import com.dtyunxi.app.DeployEnv;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ConfigurableApplicationContext;

public abstract class AbstractBoot {
    private Class<?> source;
    private String[] args;

    public AbstractBoot(Class<?> source, String ... args) {
        this.source = source;
        this.args = args;
    }

    public ConfigurableApplicationContext run() throws Exception {
        this.setDiscoveryServer();
        Class<?> clazzPandora = null;
        System.out.println("[DTYUNXI BOOT] DeployEnv=" + DeployEnv.getDeployEnv());
        if (DeployEnv.isEdas()) {
            clazzPandora = Class.forName("com.taobao.pandora.boot.PandoraBootstrap");
            clazzPandora.getMethod("run", String[].class).invoke(null, new Object[]{this.args});
        }
        this.execute();
        ConfigurableApplicationContext applicationContext = null;
        try {
            applicationContext = SpringApplication.run(this.source, (String[])this.args);
        }
        catch (NoSuchMethodError e) {
            Class<?> clazzSpringApp = Class.forName("org.springframework.boot.SpringApplication");
            applicationContext = (ConfigurableApplicationContext)clazzSpringApp.getMethod("run", Class.class, String[].class).invoke(null, this.source, this.args);
        }
        if (clazzPandora != null) {
            clazzPandora.getMethod("markStartupAndWait", null).invoke(null, null);
        }
        return applicationContext;
    }

    private void setDiscoveryServer() {
        String discoveryServer = System.getProperty("dtyunxi.discovery.server");
        if (discoveryServer != null) {
            if (DeployEnv.isEdas()) {
                System.setProperty("vipserver.server.port", discoveryServer);
            } else if (DeployEnv.isSpringCloudPure()) {
                System.setProperty("eureka.client.serviceUrl.defaultZone", discoveryServer);
            }
        }
    }

    public abstract void execute() throws Exception;
}

