/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.commons.aop;

import com.dtyunxi.annotation.CheckParameter;
import com.dtyunxi.constant.RpcExceptionCode;
import com.dtyunxi.cube.commons.CheckParameterUtil;
import com.dtyunxi.cube.commons.exceptions.CommonBusinessRuntimeException;
import com.dtyunxi.dto.ResponseDto;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CheckRequestParamAspect {
    private static Logger logger = LoggerFactory.getLogger(CheckRequestParamAspect.class);

    public abstract void checkParamAop();

    @Around(value="checkParamAop()")
    public Object executeApiRequest(ProceedingJoinPoint point) throws Throwable {
        try {
            Object[] args = point.getArgs();
            CheckParameterUtil<Object> checker = new CheckParameterUtil<Object>();
            MethodSignature methodSignature = (MethodSignature)point.getSignature();
            String[] paramNames = methodSignature.getParameterNames();
            Method method = methodSignature.getMethod();
            Annotation[][] annotations = method.getParameterAnnotations();
            Class<?>[] paramTypes = method.getParameterTypes();
            block4: for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                if (paramTypes[i].getClass().isPrimitive()) {
                    if (annotations[i] == null || annotations[i].length <= 0) continue;
                    for (Annotation annotation : annotations[i]) {
                        if (!(annotation instanceof CheckParameter)) continue;
                        checker.check4PrimitiveObject(arg, (CheckParameter)annotation, paramNames[i]);
                        continue block4;
                    }
                    continue;
                }
                if (arg == null) continue;
                checker.check4Object(arg);
            }
        }
        catch (Exception e) {
            ResponseDto dto = null;
            if (e instanceof IllegalArgumentException) {
                logger.error("Api\u53c2\u6570\u6821\u9a8c\u5931\u8d25", (Throwable)e);
                dto = new ResponseDto("FAIL", null, RpcExceptionCode.CODE_INVALID_PARAM, e.getMessage());
            } else {
                logger.error("Api\u53c2\u6570\u6821\u9a8c\u7cfb\u7edf\u9519\u8bef", (Throwable)e);
                dto = new ResponseDto("ERROR", null, RpcExceptionCode.CODE_SYS_ERROR);
            }
            return dto;
        }
        try {
            return point.proceed();
        }
        catch (Exception e) {
            logger.error("\u63a5\u53e3\u6267\u884c\u5f02\u5e38", (Throwable)e);
            ResponseDto dto = null;
            dto = e instanceof CommonBusinessRuntimeException ? new ResponseDto("FAIL", null, ((CommonBusinessRuntimeException)e).getErrorCode()) : new ResponseDto("ERROR", null, RpcExceptionCode.CODE_SYS_ERROR);
            return dto;
        }
    }
}

