/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.commons.dto;

import com.dtyunxi.cube.utils.DateConverter;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DtoHelper {
    private static Logger logger = LoggerFactory.getLogger(DtoHelper.class);

    public static void eo2Dto(BaseEo baseEo, BaseVo baseVo) {
        DtoHelper.eo2Dto(baseEo, baseVo, new String[0]);
    }

    public static void eo2Dto(BaseEo baseEo, BaseVo baseVo, String ... ignoreProperties) {
        if (null == baseEo) {
            return;
        }
        try {
            if (DtoHelper.isExtEo(baseEo)) {
                Field[] fields;
                CubeBeanUtils.copyProperties((Object)baseVo, (Object)baseEo, (String[])ignoreProperties);
                HashMap<String, Object> extMap = new HashMap<String, Object>();
                for (Field field : fields = baseEo.getClass().getDeclaredFields()) {
                    field.setAccessible(true);
                    extMap.put(field.getName(), field.get(baseEo));
                }
                baseVo.setExtFields(extMap);
            } else {
                CubeBeanUtils.copyProperties((Object)baseVo, (Object)baseEo, (String[])ignoreProperties);
                if (baseEo.getClass().getSuperclass().getSimpleName().contains("Std") && baseEo.getClass().getSuperclass().getSimpleName().contains("Eo")) {
                    Field[] fields;
                    HashMap<String, Object> extMap = new HashMap<String, Object>();
                    for (Field field : fields = baseEo.getClass().getDeclaredFields()) {
                        field.setAccessible(true);
                        extMap.put(field.getName(), field.get(baseEo));
                    }
                    baseVo.setExtFields(extMap);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void dto2Eo(BaseVo baseVo, BaseEo baseEo, String ... ignoreProperties) {
        CubeBeanUtils.copyProperties((Object)baseEo, (Object)baseVo, (String[])ignoreProperties);
        try {
            if (null != baseVo.getExtFields()) {
                BeanUtils.copyProperties((Object)baseEo, (Object)baseVo.getExtFields());
            }
        }
        catch (Exception e) {
            logger.error("copyExtField Exception:", (Throwable)e);
        }
    }

    public static void dto2Eo(BaseVo baseVo, BaseEo baseEo) {
        DtoHelper.dto2Eo(baseVo, baseEo, new String[0]);
    }

    public static <T extends BaseVo> void eoList2DtoList(Collection<? extends BaseEo> eos, Collection<T> dtos, Class<T> targetClazz) {
        if (!CollectionUtils.isEmpty(eos)) {
            for (BaseEo baseEo : eos) {
                BaseVo newObj = null;
                try {
                    newObj = (BaseVo)targetClazz.newInstance();
                }
                catch (Exception var7) {
                    logger.error("copyCollection newInstance Exception:", (Throwable)var7);
                }
                DtoHelper.eo2Dto(baseEo, newObj);
                dtos.add(newObj);
            }
        }
    }

    public static <T extends BaseEo> void dtoList2EoList(Collection<? extends BaseVo> dtos, Collection<T> eos, Class<T> targetClazz) {
        if (!CollectionUtils.isEmpty(dtos)) {
            for (BaseVo baseVo : dtos) {
                BaseEo newObj = null;
                try {
                    newObj = (BaseEo)targetClazz.newInstance();
                }
                catch (Exception var7) {
                    logger.error("copyCollection newInstance Exception:", (Throwable)var7);
                }
                DtoHelper.dto2Eo(baseVo, newObj);
                eos.add(newObj);
            }
        }
    }

    private static boolean isExtEo(BaseEo baseEo) {
        String eoClassName = baseEo.getClass().getSimpleName();
        return eoClassName.contains("ExtEo");
    }

    static {
        ConvertUtils.register((Converter)new DateConverter(), Date.class);
    }
}

