/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.framework;

import com.dtyunxi.cube.commons.exceptions.ValidateException;
import java.lang.reflect.Method;
import java.util.Set;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.executable.ExecutableValidator;

public class CommonValidator {
    private static final Validator validator;

    public <T> void validateParams(T obj, Method method, Object ... values) {
        ExecutableValidator executableValidator = validator.forExecutables();
        Set violations = executableValidator.validateParameters(obj, method, values, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ValidateException(violations);
        }
    }

    public <T> void validate(T obj) {
        Set violations = validator.validate(obj, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ValidateException(violations);
        }
    }

    static {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        validator = factory.getValidator();
    }
}

