/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.framework;

import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import com.dtyunxi.cube.framework.interceptor.RestInterceptor;
import com.dtyunxi.cube.utils.threads.CommonThreadPool;
import com.dtyunxi.http.converter.JsLongFastJsonHttpMessageConverter;
import com.dtyunxi.huieryun.log.LoggerServletFilter;
import com.dtyunxi.util.SpringBeanUtil;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.validation.beanvalidation.MethodValidationPostProcessor;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

public class RestAppConfig
implements WebMvcConfigurer {
    private final List<RestInterceptor> interceptors = new ArrayList<RestInterceptor>();
    private static ApplicationContext ctx;
    @Value(value="${cube.response.enable-null-field:true}")
    private Boolean enableNullResponse = true;

    private FastJsonHttpMessageConverter customConverters() {
        JsLongFastJsonHttpMessageConverter fastJsonMsgConvert = new JsLongFastJsonHttpMessageConverter();
        Charset UTF8 = Charset.forName("UTF-8");
        fastJsonMsgConvert.setSupportedMediaTypes(Arrays.asList(new MediaType("application", "json", UTF8), new MediaType("application", "*+json", UTF8)));
        FastJsonConfig fastJsonConfig = new FastJsonConfig();
        if (this.enableNullResponse.booleanValue()) {
            fastJsonConfig.setSerializerFeatures(new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.WriteDateUseDateFormat, SerializerFeature.WriteMapNullValue});
        } else {
            fastJsonConfig.setSerializerFeatures(new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect, SerializerFeature.WriteDateUseDateFormat});
        }
        fastJsonMsgConvert.setFastJsonConfig(fastJsonConfig);
        return fastJsonMsgConvert;
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.add(0, (HttpMessageConverter<?>)this.customConverters());
    }

    public void configurePathMatch(PathMatchConfigurer matcher) {
        matcher.setUseRegisteredSuffixPatternMatch(Boolean.valueOf(true));
    }

    public void addInterceptors(InterceptorRegistry registry) {
        this.interceptors.forEach(item -> {
            InterceptorRegistration res = registry.addInterceptor((HandlerInterceptor)item);
            if (item.includePath().length > 0) {
                res.addPathPatterns(item.includePath());
            }
            if (item.excludePath().length > 0) {
                res.excludePathPatterns(item.excludePath());
            }
        });
    }

    public void addInterceptor(RestInterceptor ... item) {
        if (item != null) {
            this.interceptors.addAll(Arrays.asList(item));
        }
    }

    @Bean
    public MethodValidationPostProcessor methodValidationPostProcessor() {
        return new MethodValidationPostProcessor();
    }

    protected static void runApp(Class app, String[] args) {
        ctx = SpringApplication.run((Class)app, (String[])args);
    }

    public static ApplicationContext getCtx() {
        return ctx;
    }

    @Bean
    @ConditionalOnMissingBean(name={"loggerServletFilter"})
    public LoggerServletFilter loggerServletFilter() {
        return new LoggerServletFilter();
    }

    @Bean
    @ConditionalOnMissingBean(name={"springBeanUtil"})
    public SpringBeanUtil springBeanUtil() {
        return new SpringBeanUtil();
    }

    @Bean
    public CommonThreadPool createThreadPool() {
        CommonThreadPool pool = new CommonThreadPool();
        pool.setSize(100);
        pool.start();
        return pool;
    }

    @PreDestroy
    void cleanup() {
        CommonThreadPool pool = (CommonThreadPool)ctx.getBean(CommonThreadPool.class);
        if (pool != null) {
            pool.stop();
        }
    }
}

