/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.framework.annotation;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.dtyunxi.cube.framework.annotation.SensitiveInfo;
import com.google.gson.Gson;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public final class SensitiveInfoUtils {
    public static String chineseName(String fullName) {
        if (StringUtils.isBlank((CharSequence)fullName)) {
            return "";
        }
        String name = StringUtils.left((String)fullName, (int)3);
        return StringUtils.rightPad((String)name, (int)StringUtils.length((CharSequence)fullName), (String)"*");
    }

    public static String chineseName(String familyName, String givenName) {
        if (StringUtils.isBlank((CharSequence)familyName) || StringUtils.isBlank((CharSequence)givenName)) {
            return "";
        }
        return SensitiveInfoUtils.chineseName(familyName + givenName);
    }

    public static String idCardNum(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return "";
        }
        String num = StringUtils.right((String)id, (int)4);
        return StringUtils.leftPad((String)num, (int)StringUtils.length((CharSequence)id), (String)"*");
    }

    public static String fixedPhone(String num) {
        if (StringUtils.isBlank((CharSequence)num)) {
            return "";
        }
        return StringUtils.leftPad((String)StringUtils.right((String)num, (int)4), (int)StringUtils.length((CharSequence)num), (String)"*");
    }

    public static String mobilePhone(String num) {
        if (StringUtils.isBlank((CharSequence)num)) {
            return "";
        }
        return StringUtils.left((String)num, (int)3).concat(StringUtils.removeStart((String)StringUtils.leftPad((String)StringUtils.right((String)num, (int)4), (int)StringUtils.length((CharSequence)num), (String)"*"), (String)"***"));
    }

    public static String address(String address, int sensitiveSize) {
        if (StringUtils.isBlank((CharSequence)address)) {
            return "";
        }
        int length = StringUtils.length((CharSequence)address);
        return StringUtils.rightPad((String)StringUtils.left((String)address, (int)(length - sensitiveSize)), (int)length, (String)"*");
    }

    public static String email(String email) {
        if (StringUtils.isBlank((CharSequence)email)) {
            return "";
        }
        int index = StringUtils.indexOf((CharSequence)email, (CharSequence)"@");
        if (index <= 1) {
            return email;
        }
        return StringUtils.rightPad((String)StringUtils.left((String)email, (int)1), (int)index, (String)"*").concat(StringUtils.mid((String)email, (int)index, (int)StringUtils.length((CharSequence)email)));
    }

    public static String bankCard(String cardNum) {
        if (StringUtils.isBlank((CharSequence)cardNum)) {
            return "";
        }
        return StringUtils.left((String)cardNum, (int)6).concat(StringUtils.removeStart((String)StringUtils.leftPad((String)StringUtils.right((String)cardNum, (int)4), (int)StringUtils.length((CharSequence)cardNum), (String)"*"), (String)"******"));
    }

    public static String cnapsCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return "";
        }
        return StringUtils.rightPad((String)StringUtils.left((String)code, (int)2), (int)StringUtils.length((CharSequence)code), (String)"*");
    }

    public static String getJson(Object javaBean) {
        String json = null;
        if (null != javaBean) {
            Class<?> raw = javaBean.getClass();
            try {
                if (raw.isInterface()) {
                    return json;
                }
                Gson g = new Gson();
                Object clone = g.fromJson(g.toJson(javaBean, javaBean.getClass()), javaBean.getClass());
                HashSet<Integer> referenceCounter = new HashSet<Integer>();
                SensitiveInfoUtils.replace(SensitiveInfoUtils.findAllField(raw), clone, referenceCounter);
                json = JSON.toJSONString((Object)clone, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullListAsEmpty});
                referenceCounter.clear();
                referenceCounter = null;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return json;
    }

    private static Field[] findAllField(Class<?> clazz) {
        Object[] fileds = clazz.getDeclaredFields();
        while (null != clazz.getSuperclass() && !Object.class.equals(clazz.getSuperclass())) {
            fileds = (Field[])ArrayUtils.addAll((Object[])fileds, (Object[])clazz.getSuperclass().getDeclaredFields());
            clazz = clazz.getSuperclass();
        }
        return fileds;
    }

    private static void replace(Field[] fields, Object javaBean, Set<Integer> referenceCounter) throws IllegalArgumentException, IllegalAccessException {
        if (null != fields && fields.length > 0) {
            block10: for (Field field : fields) {
                String valueStr;
                field.setAccessible(true);
                if (null == field || null == javaBean) continue;
                Object value = field.get(javaBean);
                if (null != value) {
                    Class<?> type = value.getClass();
                    if (type.isArray()) {
                        int len = Array.getLength(value);
                        for (int i = 0; i < len; ++i) {
                            Object arrayObject = Array.get(value, i);
                            SensitiveInfoUtils.replace(SensitiveInfoUtils.findAllField(arrayObject.getClass()), arrayObject, referenceCounter);
                        }
                    } else if (value instanceof Collection) {
                        Collection c = (Collection)value;
                        for (Object collectionObj : c) {
                            SensitiveInfoUtils.replace(SensitiveInfoUtils.findAllField(collectionObj.getClass()), collectionObj, referenceCounter);
                        }
                    } else if (value instanceof Map) {
                        Map m = (Map)value;
                        Set set = m.entrySet();
                        Iterator iterator = set.iterator();
                        while (iterator.hasNext()) {
                            Map.Entry o;
                            Map.Entry entry = o = iterator.next();
                            Object mapVal = entry.getValue();
                            SensitiveInfoUtils.replace(SensitiveInfoUtils.findAllField(mapVal.getClass()), mapVal, referenceCounter);
                        }
                    } else if (!(type.isPrimitive() || StringUtils.startsWith((CharSequence)type.getPackage().getName(), (CharSequence)"javax.") || StringUtils.startsWith((CharSequence)type.getPackage().getName(), (CharSequence)"java.") || StringUtils.startsWith((CharSequence)field.getType().getName(), (CharSequence)"javax.") || StringUtils.startsWith((CharSequence)field.getName(), (CharSequence)"java.") || !referenceCounter.add(value.hashCode()))) {
                        SensitiveInfoUtils.replace(SensitiveInfoUtils.findAllField(type), value, referenceCounter);
                    }
                }
                SensitiveInfo annotation = field.getAnnotation(SensitiveInfo.class);
                if (!field.getType().equals(String.class) || null == annotation || !StringUtils.isNotBlank((CharSequence)(valueStr = (String)value))) continue;
                switch (annotation.type()) {
                    case CHINESE_NAME: {
                        field.set(javaBean, SensitiveInfoUtils.chineseName(valueStr));
                        continue block10;
                    }
                    case ID_CARD: {
                        field.set(javaBean, SensitiveInfoUtils.idCardNum(valueStr));
                        continue block10;
                    }
                    case FIXED_PHONE: {
                        field.set(javaBean, SensitiveInfoUtils.fixedPhone(valueStr));
                        continue block10;
                    }
                    case MOBILE_PHONE: {
                        field.set(javaBean, SensitiveInfoUtils.mobilePhone(valueStr));
                        continue block10;
                    }
                    case ADDRESS: {
                        field.set(javaBean, SensitiveInfoUtils.address(valueStr, 4));
                        continue block10;
                    }
                    case EMAIL: {
                        field.set(javaBean, SensitiveInfoUtils.email(valueStr));
                        continue block10;
                    }
                    case BANK_CARD: {
                        field.set(javaBean, SensitiveInfoUtils.bankCard(valueStr));
                        continue block10;
                    }
                    case CNAPS_CODE: {
                        field.set(javaBean, SensitiveInfoUtils.cnapsCode(valueStr));
                        continue block10;
                    }
                }
            }
        }
    }

    public static Method[] findAllMethod(Class<?> clazz) {
        Method[] methods = clazz.getMethods();
        return methods;
    }

    public static enum SensitiveType {
        CHINESE_NAME,
        ID_CARD,
        FIXED_PHONE,
        MOBILE_PHONE,
        ADDRESS,
        EMAIL,
        BANK_CARD,
        CNAPS_CODE;

    }
}

