/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.framework.api;

import com.dtyunxi.cube.framework.api.AbstractApi;
import com.dtyunxi.cube.framework.api.IBaseQueryApi;
import com.dtyunxi.cube.framework.api.filter.GeneralFilter;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.CamelToUnderline;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractBaseQueryApi
extends AbstractApi
implements IBaseQueryApi {
    @Override
    public <R extends BaseEo> RestResponse<R> queryById(Long id, Class<R> clazz) {
        return new RestResponse(this.getBaseDas(clazz.getSimpleName()).selectByPrimaryKey(id));
    }

    @Override
    public <R extends BaseEo> RestResponse<List<R>> queryByBatchIds(List<Long> ids, Class<R> clazz) {
        ArrayList batchResult = new ArrayList();
        for (Long id : ids) {
            Object record = this.getBaseDas(clazz.getSimpleName()).selectByPrimaryKey(id);
            batchResult.add(record);
        }
        return new RestResponse(batchResult);
    }

    @Override
    public <R extends BaseEo> RestResponse<List<R>> query(R dto) {
        List<R> list = this.getBaseDas(dto.getClass().getSimpleName()).select(dto, false);
        return new RestResponse(list);
    }

    @Override
    public <R extends BaseEo> RestResponse<List<R>> query(R dto, List<GeneralFilter> generalFilters) {
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        for (GeneralFilter filter : generalFilters) {
            SqlFilter sqlFilter = new SqlFilter(CamelToUnderline.camelToUnderline((String)filter.getProperty()), filter.getOperator(), filter.getValue());
            sqlFilters.add(sqlFilter);
        }
        dto.setSqlFilters(sqlFilters);
        List<R> list = this.getBaseDas(dto.getClass().getSimpleName()).select(dto);
        return new RestResponse(list);
    }

    @Override
    public <R extends BaseEo> RestResponse<List<R>> queryAll(Class<R> clazz) {
        List list = this.getBaseDas(clazz.getSimpleName()).selectAll();
        return new RestResponse(list);
    }

    @Override
    public <R extends BaseEo> RestResponse<PageInfo<R>> queryByPage(R dto, Integer pageNumber, Integer pageSize) {
        PageInfo<R> page = this.getBaseDas(dto.getClass().getSimpleName()).selectPage(dto, pageNumber, pageSize);
        return new RestResponse(page);
    }

    @Override
    public <R extends BaseEo> RestResponse<PageInfo<R>> queryByPage(R dto, List<GeneralFilter> generalFilters, Integer pageNumber, Integer pageSize) {
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        for (GeneralFilter filter : generalFilters) {
            SqlFilter sqlFilter = new SqlFilter(CamelToUnderline.camelToUnderline((String)filter.getProperty()), filter.getOperator(), filter.getValue());
            sqlFilters.add(sqlFilter);
        }
        dto.setSqlFilters(sqlFilters);
        PageInfo<R> page = this.getBaseDas(dto.getClass().getSimpleName()).selectPage(dto, pageNumber, pageSize);
        return new RestResponse(page);
    }

    @Override
    public <R extends BaseEo> RestResponse<Integer> countCondition(R dto) {
        int count = this.getBaseDas(dto.getClass().getSimpleName()).count(dto);
        return new RestResponse((Object)count);
    }
}

