/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.framework.das;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.annotation.LogicColumn;
import com.dtyunxi.annotation.ShardingColumn;
import com.dtyunxi.cube.framework.das.MapperInvocationHandler;
import com.dtyunxi.cube.utils.ReflectUtil;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.CamelToUnderline;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.ds.BaseMapper;
import com.dtyunxi.util.JacksonUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Id;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public abstract class ComBaseDas<T extends BaseEo, P> {
    private static final String FIELD_VALUE_SEPARATOR = "#";
    private static final String FIELDS_SEPARATOR = ";";
    private static Long EMPTY_ID = -9999L;
    private static Integer EMPTY_CACHE_SECONDS = 60;
    public static Integer DEFAULT_PAGE_NUMBER = 1;
    public static Integer DEFAULT_PAGE_SIZE = 10;
    private static String NULL_EXAMPLE_STR = "{}";
    private static Set<String> ignoreShardingField = Sets.newHashSet((Object[])new String[]{"dr", "serialVersionUID", "logger", "mapColumns", "mapId", "sqlFilters", "EO_ATTRIBUTE", "TAB_COLUMN", "orderByDesc", "orderBy", "sqlOrderBys"});
    private Logger logger = LoggerFactory.getLogger(ComBaseDas.class);
    private static final Map<String, BaseMapper> proxyMap = Maps.newHashMap();
    private Class<T> proxyT;
    private static final Object mutexMapper = new Object();
    private static final Object mutexT = new Object();
    private static Map<String, Boolean> classMap2ExistColumns = Maps.newHashMap();

    protected abstract ICacheService getCacheService();

    protected abstract Map<String, BaseMapper> getMappers();

    protected abstract String getVersion();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseMapper<T> getMapper() {
        String tClassName = this.getTClassName();
        String mapperName = tClassName.substring(0, 1).toLowerCase() + tClassName.substring(1, tClassName.length() - 2) + "Mapper";
        BaseMapper mapper = this.getMappers().get(mapperName);
        if (null == mapper) {
            mapperName = tClassName.substring(0, tClassName.length() - 2) + "Mapper";
            mapper = this.getMappers().get(mapperName);
        }
        String oMapperName = mapperName.replace("ExtMapper", "Mapper");
        BaseMapper backupMapper = this.getMappers().get(oMapperName);
        String key = mapperName + oMapperName;
        if (null == proxyMap.get(key)) {
            Object object = mutexMapper;
            synchronized (object) {
                if (null == proxyMap.get(key)) {
                    MapperInvocationHandler proxy = new MapperInvocationHandler(mapper, backupMapper);
                    proxyMap.put(key, (BaseMapper)Proxy.newProxyInstance(backupMapper.getClass().getClassLoader(), backupMapper.getClass().getInterfaces(), (InvocationHandler)proxy));
                }
            }
        }
        return proxyMap.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<T> getTClass() {
        if (null == this.proxyT) {
            Object object = mutexT;
            synchronized (object) {
                if (null == this.proxyT) {
                    Class entityClass;
                    this.proxyT = entityClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
                    if (entityClass != null) {
                        String eoName = entityClass.getPackage().getName() + "." + StringUtils.delete((String)entityClass.getSimpleName(), (String)"Eo") + "ExtEo";
                        try {
                            this.proxyT = Class.forName(eoName);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return this.proxyT;
    }

    protected Boolean isOnlyShardingColumnQueryEo(T record, String shardingProperty) {
        Boolean isOnlyShardingColumn = false;
        if (record != null) {
            List fields = ReflectUtil.getAllFields(record.getClass());
            isOnlyShardingColumn = this.isOnlyShardingColumnByFeild(record, shardingProperty, fields);
        }
        return isOnlyShardingColumn;
    }

    private Boolean isOnlyShardingColumnByFeild(T record, String shardingProperty, List<Field> fields) {
        Boolean isOnlyShardingColumn = false;
        HashSet haveValueProperties = Sets.newHashSet();
        for (Field field : fields) {
            if (ignoreShardingField.contains(field.getName())) continue;
            try {
                field.setAccessible(true);
                Object obj = field.get(record);
                if (obj == null) continue;
                haveValueProperties.add(field.getName());
            }
            catch (Exception e) {
                this.logger.warn("\u83b7\u53d6\u6307\u5b9afield:{} \u5f02\u5e38:{}", (Object)field.getName(), (Object)e.getMessage());
            }
        }
        List filters = record.getSqlFilters();
        if (CollectionUtils.isNotEmpty((Collection)filters)) {
            for (SqlFilter filter : filters) {
                Object obj;
                if (ignoreShardingField.contains(CamelToUnderline.underlineToCamel((String)filter.getProperty())) || (obj = filter.getValue()) == null) continue;
                haveValueProperties.add(CamelToUnderline.underlineToCamel((String)filter.getProperty()));
            }
        }
        if (haveValueProperties.size() == 1 && haveValueProperties.contains(shardingProperty)) {
            isOnlyShardingColumn = true;
        }
        return isOnlyShardingColumn;
    }

    private String getTClassName() {
        return this.getTClass().getSimpleName();
    }

    protected Set<P> getLogicKey(T record) {
        HashSet<Object> logicKeyValues = new HashSet<Object>();
        if (record != null) {
            List sqlFilters = record.getSqlFilters();
            HashMap filterMap = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty((Collection)sqlFilters)) {
                for (SqlFilter sqlFilter : sqlFilters) {
                    if (sqlFilter.getProperty() == null || sqlFilter.getValue() == null) continue;
                    filterMap.put(sqlFilter.getProperty(), sqlFilter.getValue());
                    filterMap.put(CamelToUnderline.underlineToCamel((String)sqlFilter.getProperty()), sqlFilter.getValue());
                }
            }
            String propertyName = this.getShardingProperties(record.getClass());
            List fields = ReflectUtil.getAllFields(record.getClass());
            for (Field field : fields) {
                if (!field.isAnnotationPresent(LogicColumn.class) && !field.getName().equals(propertyName)) continue;
                field.setAccessible(true);
                Object objectValue = null;
                try {
                    objectValue = field.get(record);
                }
                catch (IllegalAccessException e) {
                    this.logger.error("\u83b7\u53d6\u903b\u8f91\u4e3b\u952e\u51fa\u9519", (Throwable)e);
                }
                if (objectValue == null && filterMap.size() > 0 && filterMap.keySet().contains(field.getName())) {
                    objectValue = filterMap.get(field.getName());
                    if (objectValue instanceof String) {
                        String[] logicKeyValueStrs = org.apache.commons.lang3.StringUtils.split((String)String.valueOf(objectValue), (String)",");
                        if (null != logicKeyValueStrs && logicKeyValueStrs.length > 0) {
                            for (String logicKeyValue : logicKeyValueStrs) {
                                if (logicKeyValue == null) continue;
                                logicKeyValues.add(logicKeyValue);
                            }
                        }
                    } else if (objectValue instanceof List) {
                        List listFilterValues = (List)objectValue;
                        logicKeyValues.addAll(listFilterValues);
                    } else {
                        logicKeyValues.add(objectValue);
                    }
                } else {
                    logicKeyValues.add(objectValue);
                }
                return logicKeyValues;
            }
        }
        return logicKeyValues;
    }

    private String getShardingProperties(Class<? extends BaseEo> recordClass) {
        ShardingColumn annotation = recordClass.getAnnotation(ShardingColumn.class);
        String propertyName = null;
        if (annotation != null) {
            ShardingColumn shardingColumn = annotation;
            propertyName = CamelToUnderline.underlineToCamel((String)shardingColumn.name());
        }
        return propertyName;
    }

    private Set<Long> getId(T record) {
        HashSet<Long> ids = new HashSet<Long>();
        if (record != null) {
            if (record.getId() != null) {
                ids.add(record.getId());
                return ids;
            }
            List sqlFilters = record.getSqlFilters();
            HashMap filterMap = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty((Collection)sqlFilters)) {
                for (SqlFilter sqlFilter : sqlFilters) {
                    if (sqlFilter.getProperty() == null || sqlFilter.getValue() == null) continue;
                    filterMap.put(sqlFilter.getProperty(), sqlFilter.getValue());
                    filterMap.put(CamelToUnderline.underlineToCamel((String)sqlFilter.getProperty()), sqlFilter.getValue());
                }
            }
            List fields = ReflectUtil.getAllFields(record.getClass());
            for (Field field : fields) {
                if (!field.isAnnotationPresent(Id.class)) continue;
                field.setAccessible(true);
                Object objectValue = null;
                try {
                    objectValue = field.get(record);
                }
                catch (IllegalAccessException e) {
                    this.logger.error("\u83b7\u53d6\u4e3b\u952e\u51fa\u9519", (Throwable)e);
                }
                if (objectValue == null && filterMap.size() > 0 && filterMap.keySet().contains(field.getName())) {
                    objectValue = filterMap.get(field.getName());
                    if (objectValue instanceof String) {
                        String[] idStrs = org.apache.commons.lang3.StringUtils.split((String)String.valueOf(objectValue), (String)",");
                        if (null != idStrs && idStrs.length > 0) {
                            for (String idStr : idStrs) {
                                ids.add(Long.valueOf(idStr));
                            }
                        }
                    } else if (objectValue instanceof List) {
                        List listFilterValues = (List)objectValue;
                        ids.addAll(listFilterValues);
                    } else {
                        ids.add((Long)objectValue);
                    }
                } else {
                    ids.add((Long)objectValue);
                }
                return ids;
            }
        }
        return ids;
    }

    private T setLogicKey(P key) {
        if (key != null) {
            Class<T> entityClass = this.getTClass();
            try {
                BaseEo record = (BaseEo)entityClass.newInstance();
                List fields = ReflectUtil.getAllFields(record.getClass());
                for (Field field : fields) {
                    if (!field.isAnnotationPresent(LogicColumn.class) && !field.getName().equals(this.getShardingProperties(entityClass))) continue;
                    field.setAccessible(true);
                    if (key.getClass().equals(field.getType())) {
                        field.set(record, key);
                    } else if (field.getType().equals(Long.class)) {
                        field.set(record, Long.parseLong(key.toString()));
                    } else {
                        field.set(record, key.toString());
                    }
                    return (T)record;
                }
            }
            catch (Exception e) {
                this.logger.error("\u8bbe\u7f6e\u903b\u8f91\u4e3b\u952e\u51fa\u9519", (Throwable)e);
            }
        }
        return null;
    }

    public String getCachePre() {
        return this.getActualArgumentClassName(0) + this.getVersion();
    }

    public String getLogicCachePre() {
        return this.getActualArgumentClassName(0) + "_LOGIC_" + this.getVersion();
    }

    private String getActualArgumentClassName(int i) {
        Class entityClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[i];
        return entityClass.getSimpleName();
    }

    public void addCache(T record, Object key) {
        if (record == null || key == null) {
            this.logger.error("\u6dfb\u52a0\u7f13\u5b58\u5931\u8d25,record:{},key:{}", record, key);
            return;
        }
        try {
            this.getCacheService().setCache(this.getCachePre() + key, record);
        }
        catch (Exception e) {
            this.logger.error("\u6dfb\u52a0\u7f13\u5b58\u5931\u8d25,record=" + record, (Throwable)e);
        }
    }

    public void addLogicCache(T record, Object key) {
        if (record == null || key == null) {
            this.logger.error("\u6dfb\u52a0\u903b\u8f91\u7f13\u5b58\u5931\u8d25,record:{},key:{}", record, key);
            return;
        }
        try {
            this.getCacheService().setCache(this.getLogicCachePre() + key, record);
        }
        catch (Exception e) {
            this.logger.error("\u6dfb\u52a0\u903b\u8f91\u7f13\u5b58\u5931\u8d25,record=" + record, (Throwable)e);
        }
    }

    public void addEmptyCache(Object key) {
        this.addEmptyCache(key, EMPTY_CACHE_SECONDS);
    }

    public void addEmptyCache(Object key, Integer seconds) {
        try {
            BaseEo record = (BaseEo)this.getTClass().newInstance();
            record.setId(EMPTY_ID);
            if (seconds != null) {
                this.getCacheService().setCache(this.getCachePre() + key, (Object)record, seconds.intValue());
            } else {
                this.getCacheService().setCache(this.getCachePre() + key, (Object)record);
            }
        }
        catch (Exception e) {
            this.logger.error("\u6dfb\u52a0\u7a7a\u7f13\u5b58\u5931\u8d25,key:{}", key, (Object)e);
        }
    }

    public void addLogicEmptyCache(Object key, Integer seconds) {
        try {
            BaseEo record = (BaseEo)this.getTClass().newInstance();
            record.setId(EMPTY_ID);
            if (seconds != null) {
                this.getCacheService().setCache(this.getLogicCachePre() + key, (Object)record, seconds.intValue());
            } else {
                this.getCacheService().setCache(this.getLogicCachePre() + key, (Object)record);
            }
        }
        catch (Exception e) {
            this.logger.error("\u6dfb\u52a0\u7a7a\u7f13\u5b58\u5931\u8d25,key:{}", key, (Object)e);
        }
    }

    private void addCache(PageInfo<T> pageInfo, String key) {
        if (pageInfo == null) {
            this.logger.error("\u6dfb\u52a0\u7f13\u5b58\u5931\u8d25,pageInfo=null");
            return;
        }
        try {
            this.getCacheService().setCache(key, pageInfo);
        }
        catch (Exception e) {
            this.logger.error("\u6dfb\u52a0\u7f13\u5b58\u5931\u8d25,pageInfo=" + pageInfo, (Throwable)e);
        }
    }

    public T getCacheByKey(Object key) {
        try {
            return (T)((BaseEo)this.getCacheService().getCache(this.getCachePre() + key, (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0]));
        }
        catch (Exception e) {
            this.logger.error("\u6839\u636e\u4e3b\u952e\u83b7\u53d6\u7f13\u5b58\u5931\u8d25\uff0c\u4e3b\u952e=" + key, (Throwable)e);
            return null;
        }
    }

    public T getCacheByLogicKey(Object key) {
        try {
            return (T)((BaseEo)this.getCacheService().getCache(this.getLogicCachePre() + key, (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0]));
        }
        catch (Exception e) {
            this.logger.error("\u6839\u636e\u903b\u8f91\u4e3b\u952e\u83b7\u53d6\u7f13\u5b58\u5931\u8d25\uff0c\u903b\u8f91\u4e3b\u952e=" + key, (Throwable)e);
            return null;
        }
    }

    public void removeCache(Object key) {
        try {
            if (key instanceof Set) {
                Set keys = (Set)key;
                for (Object o : keys) {
                    this.getCacheService().delCache(this.getCachePre() + o);
                }
            } else {
                this.getCacheService().delCache(this.getCachePre() + key);
            }
        }
        catch (Exception e) {
            this.logger.error("\u5220\u9664\u7f13\u5b58\u5931\u8d25", (Throwable)e);
        }
    }

    public void removeLogicCache(T record, Set<P> logicColumns) {
        if (record != null && logicColumns != null) {
            for (P key : logicColumns) {
                this.getCacheService().delCache(this.getLogicCachePre() + key);
            }
        }
    }

    public List<T> select(T record) {
        try {
            return this.getMapper().findList(record);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u5217\u8868\u51fa\u9519", (Throwable)e);
            throw e;
        }
    }

    public List<T> select(T record, boolean cacheable) {
        if (cacheable) {
            return this.select(record);
        }
        return this.getMapper().findList(record);
    }

    private List<T> getCache(String key) {
        if (null == key) {
            return null;
        }
        List result = this.getCacheService().getList(key, (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0]);
        return result;
    }

    private PageInfo<T> getPageCache(String key) {
        if (null == key) {
            return null;
        }
        Object json = this.getCacheService().getCache(key, Object.class);
        if (json == null) {
            return null;
        }
        String jsonStr = JSON.toJSONString((Object)json);
        Class<T> tClass = this.getTClass();
        PageInfo result = (PageInfo)JacksonUtil.readValue((String)jsonStr, PageInfo.class, (Class[])new Class[]{tClass});
        return result;
    }

    public PageInfo<T> selectPage(T record, Integer currentPage, Integer pageSize) {
        currentPage = null == currentPage ? DEFAULT_PAGE_NUMBER : currentPage;
        pageSize = null == pageSize ? DEFAULT_PAGE_SIZE : pageSize;
        PageHelper.startPage((int)currentPage, (int)pageSize);
        List list = this.getMapper().findList(record);
        return new PageInfo(list);
    }

    public PageInfo<T> selectPage(T record, Integer currentPage, Integer pageSize, Boolean cacheable) {
        return this.selectPage(record, currentPage, pageSize);
    }

    public PageInfo<T> selectPage(T record) {
        return this.selectPage(record, DEFAULT_PAGE_NUMBER, DEFAULT_PAGE_SIZE);
    }

    public PageInfo<T> selectPage(T record, Boolean cacheable) {
        if (cacheable != null && cacheable.booleanValue()) {
            return this.selectPage(record, DEFAULT_PAGE_NUMBER, DEFAULT_PAGE_SIZE);
        }
        return this.selectPage(record, DEFAULT_PAGE_NUMBER, DEFAULT_PAGE_SIZE, cacheable);
    }

    public T selectByPrimaryKey(Long key) {
        Object record = this.getCacheByKey(key);
        if (record != null) {
            if (EMPTY_ID.equals(record.getId())) {
                return null;
            }
            return record;
        }
        record = this.getMapper().findById(this.getTClass(), key);
        if (record != null) {
            this.addCache(record, key);
        } else {
            this.addEmptyCache(key);
        }
        return record;
    }

    public T selectByLogicKey(P key) {
        try {
            Object returnRecord = this.getCacheByLogicKey(key);
            if (returnRecord != null) {
                if (EMPTY_ID.equals(returnRecord.getId())) {
                    return null;
                }
                return returnRecord;
            }
            T record = this.setLogicKey(key);
            if (record != null) {
                returnRecord = this.getMapper().find(record);
                if (returnRecord != null) {
                    this.addLogicCache(returnRecord, key);
                } else {
                    this.addLogicEmptyCache(key, EMPTY_CACHE_SECONDS);
                }
            }
            return returnRecord;
        }
        catch (Exception e) {
            this.logger.error("\u6839\u636e\u903b\u8f91\u4e3b\u952e\u67e5\u8be2\u51fa\u9519", (Throwable)e);
            throw e;
        }
    }

    public T selectOne(T record) {
        String shardingProperty = this.getShardingProperties(record.getClass());
        Object returnRecod = null;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)shardingProperty) && this.isOnlyShardingColumnQueryEo(record, shardingProperty).booleanValue()) {
            Set<P> logicKeys = this.getLogicKey(record);
            if (CollectionUtils.isNotEmpty(logicKeys) && logicKeys.size() == 1) {
                this.logger.info("only exist shardingColumn value && logicKey.size == 1, so replace selectOne by SelectByLogicKey");
                returnRecod = this.selectByLogicKey(logicKeys.iterator().next());
            } else {
                this.logger.error("\u8bf7\u6ce8\u610f\u8fd9\u91cc\uff0c\u5b58\u5728\u903b\u8f91\u4e3b\u952e\u4e14\u552f\u4e00\u6709\u503c\uff0c\u4e0d\u5e94\u8be5\u8d70\u8fd9\u4e2a\u67e5\u8be2\uff0c{}", logicKeys);
                returnRecod = this.getMapper().find(record);
            }
        } else {
            returnRecod = this.getMapper().find(record);
        }
        return (T)returnRecod;
    }

    public int count(T record) {
        try {
            return this.getMapper().countCondition(record);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u8ba1\u6570\u51fa\u9519", (Throwable)e);
            return -1;
        }
    }

    public int insert(T record) {
        int effectRow = this.getMapper().insert(record);
        try {
            if (record.getId() != null) {
                this.removeCache(this.getId(record));
            }
            this.removeLogicCache(record);
        }
        catch (Exception e) {
            this.logger.error("inset \u64cd\u4f5c\u65f6\uff0c\u63d0\u524d\u5220\u9664\u4e24\u79cd\u952e\u7f13\u5b58\u5931\u8d25", (Throwable)e);
        }
        return effectRow;
    }

    public void update(T record) {
        int effectRows = this.getMapper().update(record);
        this.removeLogicCache(record);
        this.removeCache(this.getId(record));
    }

    public void removeLogicCache(T record) {
        Boolean result;
        if (record != null && (result = this.isExistLogicColumnOrShardingColumn(record.getClass())).booleanValue()) {
            Set<P> logicColumns = this.getLogicKey(record);
            if (CollectionUtils.isEmpty(logicColumns)) {
                logicColumns = this.processLogicColumns(record, logicColumns);
            }
            this.removeLogicCache(record, logicColumns);
        }
    }

    private Boolean isExistLogicColumnOrShardingColumn(Class<? extends BaseEo> recordClass) {
        if (classMap2ExistColumns.get(recordClass.getName()) != null) {
            return classMap2ExistColumns.get(recordClass.getName());
        }
        String shardingProertyName = this.getShardingProperties(recordClass);
        List fields = ReflectUtil.getAllFields(recordClass);
        for (Field field : fields) {
            if (!field.isAnnotationPresent(LogicColumn.class) && !field.getName().equals(shardingProertyName)) continue;
            classMap2ExistColumns.put(recordClass.getName(), true);
            return true;
        }
        classMap2ExistColumns.put(recordClass.getName(), false);
        return false;
    }

    public void updateSelective(T record) {
        int effectRows = this.getMapper().updateSelective(record);
        this.removeLogicCache(record);
        this.removeCache(this.getId(record));
    }

    public void updateSelectiveSqlFilter(T record) {
        this.getMapper().updateSelectiveSqlFilter(record);
        try {
            this.removeLogicCache(record);
            this.removeCache(this.getId(record));
        }
        catch (Exception e) {
            this.logger.error("updateSelectiveSqlFilter \u79fb\u9664\u8bb0\u5f55 {} \u7f13\u5b58\u5931\u8d25", record, (Object)e);
        }
    }

    private Set<P> processLogicColumns(T record, Set<P> logicColumns) {
        T cacheRecord;
        if (CollectionUtils.isEmpty(logicColumns) && CollectionUtils.isEmpty(logicColumns = this.getLogicKey(cacheRecord = this.getCacheByKey(record.getId())))) {
            this.logger.warn("load logic key by select DB for delete cache");
            T dbRecord = this.selectByPrimaryKey(record.getId());
            logicColumns = this.getLogicKey(dbRecord);
        }
        return logicColumns;
    }

    public void delete(T record) {
        this.deleteByExample(record, false);
    }

    public void logicDelete(T record) {
        this.deleteByExample(record, true);
        this.removeLogicCache(record);
        this.removeCache(this.getId(record));
    }

    public void deleteById(Long id) {
        T record = this.selectByPrimaryKey(id);
        this.getMapper().deleteById(this.getTClass(), id);
        this.removeLogicCache(record);
        this.removeCache(id);
    }

    public void logicDeleteById(Long id) {
        T record = this.selectByPrimaryKey(id);
        this.removeLogicCache(record);
        this.removeCache(id);
        this.getMapper().deleteLogicById(this.getTClass(), id);
    }

    public void logicDeleteByExample(T example) {
        this.deleteByExample(example, true);
    }

    public void deleteByExample(T example) {
        this.deleteByExample(example, false);
    }

    private int deleteByExample(T example, Boolean isLogicDelete) {
        String json = JSON.toJSONString(example);
        if (NULL_EXAMPLE_STR.equals(json)) {
            return 0;
        }
        List<T> records = this.select(example);
        if (records.isEmpty()) {
            return 0;
        }
        int effects = 0;
        effects = isLogicDelete != false ? this.getMapper().deleteLogic(example) : this.getMapper().delete(example);
        for (BaseEo record : records) {
            Set<P> logicColumns = this.getLogicKey(record);
            if (CollectionUtils.isEmpty(logicColumns)) {
                logicColumns = this.processLogicColumns(record, logicColumns);
            }
            this.removeCache(this.getId(record));
            this.removeLogicCache(record, logicColumns);
        }
        return effects;
    }

    public void deleteByLogicKey(P key) {
        this.removeCache(key);
        T record = this.setLogicKey(key);
        if (record != null) {
            this.getMapper().delete(record);
            this.removeLogicCache(record);
            this.removeCache(this.getId(record));
        }
    }

    public void logicDeleteByLogicKey(P key) {
        this.removeCache(key);
        T record = this.setLogicKey(key);
        if (record != null) {
            this.getMapper().deleteLogic(record);
            this.removeLogicCache(record);
            this.removeCache(this.getId(record));
        }
    }

    public int insertBatch(List<T> records) {
        if (records.isEmpty()) {
            return 0;
        }
        return this.getMapper().insertBatch(records);
    }

    public List<Long> getIds(List<T> tList) {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (BaseEo t : tList) {
            ids.add(t.getId());
        }
        return ids;
    }

    public int insertBatchByExample(List<T> tList, T example) {
        String json = JSON.toJSONString(example);
        if (NULL_EXAMPLE_STR.equals(json)) {
            return 0;
        }
        int effectRows = 0;
        if (tList.isEmpty()) {
            return effectRows;
        }
        effectRows = this.deleteByExample(example, false);
        return (effectRows += this.insertBatch(tList)) + tList.size();
    }

    public List<T> selectAll() {
        return this.getMapper().findAll(this.getTClass());
    }
}

