/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.framework.dto;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import org.springframework.util.StringUtils;

public class SearchSort
implements Serializable {
    private static final long serialVersionUID = -6056743972633766976L;
    public static final Direction DEFAULT_DIRECTION = Direction.asc;
    private List<Order> orders = Lists.newArrayList();

    public List<Order> getOrders() {
        return this.orders;
    }

    public void setOrders(List<Order> orders) {
        this.orders = orders;
    }

    public static class Order
    implements Serializable {
        private static final long serialVersionUID = 6402139124846930959L;
        private final Direction direction;
        private final String property;

        public Order(Direction direction, String property) {
            if (StringUtils.isEmpty((Object)property)) {
                throw new IllegalArgumentException("Property must not null or empty!");
            }
            this.direction = direction;
            this.property = property;
        }

        public Order(String property) {
            this(DEFAULT_DIRECTION, property);
        }

        public Direction getDirection() {
            return this.direction;
        }

        public String getProperty() {
            return this.property;
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.direction.hashCode();
            result = 31 * result + this.property.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Order)) {
                return false;
            }
            Order that = (Order)obj;
            return this.direction.equals((Object)that.direction) && this.property.equals(that.property);
        }

        public String toString() {
            return String.format("{%s: %s}", new Object[]{this.property, this.direction});
        }
    }

    public static enum Direction {
        asc,
        desc;


        public static Direction fromString(String value) {
            try {
                return Direction.valueOf(value.toUpperCase(Locale.US));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Invalid value '%s' for orders given! Has to be either 'desc' or 'asc' (case insensitive).", value), e);
            }
        }
    }
}

