/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.framework.jpa;

import com.dtyunxi.cube.framework.dto.SearchFilter;
import com.dtyunxi.cube.framework.dto.SearchRequest;
import com.dtyunxi.cube.framework.dto.SearchSort;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.repository.NoRepositoryBean;

@NoRepositoryBean
public interface BaseDao<T, ID extends Serializable>
extends JpaRepository<T, ID>,
JpaSpecificationExecutor<T> {
    default public Page<T> findPage(SearchRequest searchRequest) {
        Sort sort = this.getSortBySearchRequest(searchRequest);
        List<SearchFilter> filterList = searchRequest.getFilters();
        Integer pageNum = searchRequest.getPageNum();
        pageNum = (pageNum = Integer.valueOf(pageNum - 1)) < 0 ? 0 : pageNum;
        PageRequest pageRequest = new PageRequest(pageNum.intValue(), searchRequest.getPageSize().intValue(), sort);
        Page page = this.findAll((Specification & Serializable)(root, query, cb) -> {
            this.queryWhere(filterList, root, query, cb);
            return null;
        }, (Pageable)pageRequest);
        return page;
    }

    default public List<T> findList(SearchRequest searchRequest) {
        Sort sort = this.getSortBySearchRequest(searchRequest);
        List<SearchFilter> filterList = searchRequest.getFilters();
        List list = this.findAll((Specification & Serializable)(root, query, cb) -> {
            this.queryWhere(filterList, root, query, cb);
            return null;
        }, sort);
        return list;
    }

    default public void queryWhere(List<SearchFilter> filterList, Root<T> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
        List<Predicate> predicateList = this.addPredicateList(filterList, root, query, cb);
        query.where(predicateList.toArray(new Predicate[predicateList.size()]));
    }

    default public List<Predicate> addPredicateList(List<SearchFilter> filterList, Root<T> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
        ArrayList list = Lists.newArrayList();
        if (CollectionUtils.isEmpty(filterList)) {
            return list;
        }
        Predicate predicate = null;
        for (SearchFilter searchFilter : filterList) {
            String ops = searchFilter.getOperator().getOps();
            if (searchFilter.getValue() == null) continue;
            Object value = searchFilter.getValue();
            Path path = root.get(searchFilter.getProperty());
            boolean bAnd = SearchFilter.SearchType.AND.getTypeStr().equals(searchFilter.getType().getTypeStr());
            Predicate p = cb.equal((Expression)path, value);
            switch (ops) {
                case "!=": {
                    p = cb.notEqual((Expression)path, value);
                    break;
                }
                case "like": {
                    p = cb.like((Expression)path, "%" + value + "%");
                    break;
                }
                case "not like": {
                    p = cb.notLike((Expression)path, "%" + value + "%");
                    break;
                }
                case ">": {
                    p = cb.gt((Expression)path, NumberUtils.createNumber((String)value.toString()));
                    break;
                }
                case ">=": {
                    p = cb.ge((Expression)path, NumberUtils.createNumber((String)value.toString()));
                    break;
                }
                case "<": {
                    p = cb.lt((Expression)path, NumberUtils.createNumber((String)value.toString()));
                    break;
                }
                case "<=": {
                    p = cb.le((Expression)path, NumberUtils.createNumber((String)value.toString()));
                    break;
                }
                case "is null": {
                    p = cb.isNull((Expression)path);
                    break;
                }
                case "is not null": {
                    p = cb.isNotNull((Expression)path);
                }
            }
            if (predicate == null) {
                predicate = p;
                continue;
            }
            predicate = bAnd ? cb.and((Expression)predicate, (Expression)p) : cb.or((Expression)predicate, (Expression)p);
        }
        list.add(predicate);
        return list;
    }

    default public Sort getSortBySearchRequest(SearchRequest searchRequest) {
        Sort sort = null;
        SearchSort searchSort = searchRequest.getSort();
        if (searchSort != null) {
            ArrayList orderList = Lists.newArrayList();
            for (SearchSort.Order sorder : searchSort.getOrders()) {
                Sort.Direction direction = sorder.getDirection() == SearchSort.Direction.asc ? Sort.Direction.ASC : Sort.Direction.DESC;
                Sort.Order so = new Sort.Order(direction, sorder.getProperty());
                orderList.add(so);
            }
            sort = new Sort((List)orderList);
        }
        return sort;
    }
}

