/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.framework.jpa;

import com.dtyunxi.cube.utils.bean.ObjectHelper;
import java.util.ArrayList;
import java.util.Map;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.data.jpa.domain.Specification;

public class SpecificationByExample<T>
implements Specification<T> {
    private final T example;

    public SpecificationByExample(T example) {
        this.example = example;
    }

    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> cq, CriteriaBuilder cb) {
        ArrayList<Predicate> list = new ArrayList<Predicate>();
        Map ex = ObjectHelper.bean2Map(this.example);
        for (Map.Entry entry : ex.entrySet()) {
            String field = (String)entry.getKey();
            Object obj = entry.getValue();
            if (obj == null) continue;
            if (ObjectHelper.isString(obj)) {
                String param = obj.toString();
                param = param.replaceAll("%", "\\\\%");
                list.add(cb.like((Expression)root.get(field), "%" + param + "%"));
                continue;
            }
            if (ObjectHelper.isInteger(obj)) {
                list.add(cb.equal((Expression)root.get(field), obj));
                continue;
            }
            if (ObjectHelper.isFloat(obj)) {
                list.add(cb.equal((Expression)root.get(field), obj));
                continue;
            }
            if (!ObjectHelper.isDate(obj)) continue;
            list.add(cb.equal((Expression)root.get(field), obj));
        }
        Predicate[] p = new Predicate[list.size()];
        return cb.and(list.toArray(p));
    }
}

