/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.framework.rest;

import com.dtyunxi.cube.utils.codec.RSAUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;

public class RestSignUtil {
    public static String sign(String appkey, String url, Map<String, String> queryMap, byte[] requestBody, String privateKey) {
        byte[] signData = RestSignUtil.genSignData(appkey, url, queryMap, requestBody);
        try {
            String sign = RSAUtils.sign((byte[])signData, (String)privateKey);
            return sign;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] genSignData(String appkey, String url, Map<String, String> queryMap, byte[] requestBody) {
        try {
            byte[] appkeyBytes = appkey.getBytes("UTF-8");
            byte[] urlBytes = url.getBytes("UTF-8");
            String queryString = RestSignUtil.queryMapToString(queryMap);
            byte[] queryStringBytes = queryString.getBytes("UTF-8");
            byte[] bytes = new byte[appkeyBytes.length + urlBytes.length + requestBody.length + queryStringBytes.length];
            System.arraycopy(appkeyBytes, 0, bytes, 0, appkeyBytes.length);
            System.arraycopy(urlBytes, 0, bytes, appkeyBytes.length, urlBytes.length);
            System.arraycopy(requestBody, 0, bytes, appkeyBytes.length + urlBytes.length, requestBody.length);
            System.arraycopy(queryStringBytes, 0, bytes, appkeyBytes.length + urlBytes.length + requestBody.length, queryStringBytes.length);
            return bytes;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean verify(String appkey, String url, Map<String, String> queryMap, byte[] requestBody, String publicKey, String sign) {
        byte[] signData = RestSignUtil.genSignData(appkey, url, queryMap, requestBody);
        try {
            return RSAUtils.verify((byte[])signData, (String)publicKey, (String)sign);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean verify(String md5String, String publicKey, String sign) {
        try {
            byte[] verifyData = md5String.getBytes("UTF-8");
            return RSAUtils.verify((byte[])verifyData, (String)publicKey, (String)sign);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String queryMapToString(Map<String, String> queryMap) {
        if (queryMap.isEmpty()) {
            return "";
        }
        ArrayList<Map.Entry<String, String>> mappingList = new ArrayList<Map.Entry<String, String>>(queryMap.entrySet());
        Collections.sort(mappingList, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        StringBuilder sf = new StringBuilder();
        for (Map.Entry entry : mappingList) {
            sf.append((String)entry.getKey()).append(entry.getValue() == null ? "" : (String)entry.getValue());
        }
        return sf.toString();
    }
}

