/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.utils.commons;

import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import java.util.Date;

public class MyDateUtils {
    public static int[] months = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    public static Instant round(Instant instant) {
        long second;
        long milli = instant.toEpochMilli();
        if (milli - (second = instant.getEpochSecond() * 1000L) > 500L) {
            instant = instant.plusSeconds(1L);
        }
        return instant;
    }

    public static LocalDateTime round2(LocalDateTime localDateTime) {
        long milli = localDateTime.get(ChronoField.MILLI_OF_SECOND);
        if (milli > 500L) {
            localDateTime = localDateTime.plusSeconds(1L);
        }
        return localDateTime;
    }

    public static String calculateTimeDifference(Temporal time) {
        return MyDateUtils.calculateTimeDifference(time, LocalDateTime.now());
    }

    public static String calculateTimeDifferenceZ(Temporal time) {
        return MyDateUtils.calculateTimeDifference(time, Instant.now());
    }

    public static String calculateTimeDifference(Temporal start, Temporal end) {
        Duration duration = Duration.between(start, end);
        return MyDateUtils.resolveTime(duration.getSeconds());
    }

    public static String resolveTime(long totalSeconds) {
        long minutes = totalSeconds / 60L;
        long seconds = totalSeconds - minutes * 60L;
        long hours = minutes / 60L;
        return String.format("%s\u65f6%s\u5206%s\u79d2", hours, minutes -= hours * 60L, seconds);
    }

    public static final String getDateString(Date date) {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS+0800").format(date);
    }

    public static final String getZeroTimeZone(LocalDateTime date) {
        return DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").format(date);
    }

    public static LocalDateTime getLocalDateTimeFromDate(Date date) {
        if (date == null) {
            return null;
        }
        Instant instant = date.toInstant();
        ZoneId zone = ZoneId.systemDefault();
        LocalDateTime lastUpdateDateTime = LocalDateTime.ofInstant(instant, zone);
        return lastUpdateDateTime;
    }

    public static Date localDateTime2Date(LocalDateTime localDateTime) {
        ZoneId zoneId = ZoneId.systemDefault();
        ZonedDateTime zdt = localDateTime.atZone(zoneId);
        return Date.from(zdt.toInstant());
    }

    public static String formateLocalDate(LocalDate localDate) {
        String month = localDate.getMonthValue() < 10 ? String.format("0%s", localDate.getMonthValue()) : String.format("%s", localDate.getMonthValue());
        String day = localDate.getDayOfMonth() < 10 ? String.format("0%s", localDate.getDayOfMonth()) : String.format("%s", localDate.getDayOfMonth());
        return String.format("%d-%s-%s", localDate.getYear(), month, day);
    }
}

