/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.cube.utils.threads.pattens;

import com.dtyunxi.cube.utils.threads.pattens.ProducerWorker;
import com.dtyunxi.cube.utils.threads.pattens.ProductStore;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerThread<T>
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ProducerThread.class);
    private ProductStore<T> prodStore;
    private boolean running;
    private ProducerWorker worker;

    public ProducerThread(ProductStore<T> prodStore, ProducerWorker worker) {
        this.running = true;
        this.prodStore = prodStore;
        this.worker = worker;
    }

    public ProducerThread() {
        this.running = false;
    }

    @Override
    public void run() {
        LOG.info("ProducerThread Started....");
        while (this.running && !Thread.currentThread().isInterrupted()) {
            try {
                List prods = this.worker.doWork();
                for (Object p : prods) {
                    this.prodStore.push(p);
                    LOG.debug("Producer-->{}", p);
                }
            }
            catch (InterruptedException ex) {
                LOG.warn("Producer\u7ebf\u7a0b\u88ab\u4e2d\u65ad");
                break;
            }
        }
        LOG.info("ProducerThread Stopped....");
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public ProductStore<T> getProdStore() {
        return this.prodStore;
    }

    public void setProdStore(ProductStore<T> prodStore) {
        this.prodStore = prodStore;
    }
}

